/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import java.util.ArrayList;
import java.util.List;

public class EprGroundEqualityAtom
extends EprGroundPredicateAtom {
    private final Term mLhs;
    private final Term mRhs;
    private final List<ApplicationTerm> mPoint;

    public EprGroundEqualityAtom(ApplicationTerm term, int hash, int assertionstacklevel, EprEqualityPredicate eqPred, SourceAnnotation source) {
        super(term, hash, assertionstacklevel, eqPred, source);
        assert (term.getParameters().length == 2);
        this.mLhs = term.getParameters()[0];
        this.mRhs = term.getParameters()[1];
        this.mPoint = new ArrayList<ApplicationTerm>();
        for (int i = 0; i < this.getArguments().length; ++i) {
            this.mPoint.add((ApplicationTerm)this.getArguments()[i]);
        }
    }

    @Override
    public Term getSMTFormula(Theory smtTheory) {
        return this.getTerm();
    }

    public CCEquality getCCEquality(Clausifier clausif) {
        EqualityProxy eq = clausif.createEqualityProxy(this.mLhs, this.mRhs, this.getSourceAnnotation());
        if (eq == EqualityProxy.getTrueProxy()) {
            return null;
        }
        assert (eq != EqualityProxy.getFalseProxy());
        CCEquality resultAtom = (CCEquality)eq.getLiteral(this.getSourceAnnotation());
        assert (resultAtom != null);
        return resultAtom;
    }

    public List<ApplicationTerm> getPoint() {
        return this.mPoint;
    }
}

