/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;

public class EprQuantifiedEqualityAtom
extends EprQuantifiedPredicateAtom {
    private final Term lhs;
    private final Term rhs;
    private final boolean bothQuantified;

    public EprQuantifiedEqualityAtom(ApplicationTerm term, int hash, int assertionstacklevel, EprEqualityPredicate equalityPred, SourceAnnotation source) {
        super(term, hash, assertionstacklevel, equalityPred, source);
        assert (term.getFunction().getName().equals("="));
        assert (term.getFreeVars().length > 0);
        this.lhs = term.getParameters()[0];
        this.rhs = term.getParameters()[1];
        boolean bl = this.bothQuantified = term.getParameters()[0] instanceof TermVariable && term.getParameters()[1] instanceof TermVariable;
        assert (!EprHelpers.containsBooleanTerm(term.getParameters()));
    }

    public Term getLhs() {
        return this.lhs;
    }

    public Term getRhs() {
        return this.rhs;
    }

    public boolean areBothQuantified() {
        return this.bothQuantified;
    }

    @Override
    public Term getSMTFormula(Theory smtTheory) {
        return this.getTerm();
    }

    @Override
    public String toString() {
        return this.getTerm().toString();
    }
}

