/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ClauseEprLiteral
extends ClauseLiteral {
    private DawgState<ApplicationTerm, EprTheory.TriBool> mLastState;
    protected final EprPredicateAtom mEprPredicateAtom;
    private DawgState<ApplicationTerm, EprTheory.TriBool> mCachedDawg;
    protected final List<Term> mArgumentTerms;
    protected final List<ApplicationTerm> mArgumentTermsAsAppTerm;

    public ClauseEprLiteral(boolean polarity, EprPredicateAtom atom, EprClause clause, EprTheory eprTheory) {
        super(polarity, atom, clause, eprTheory);
        this.mEprPredicateAtom = atom;
        this.mArgumentTerms = Collections.unmodifiableList(Arrays.asList(atom.getArguments()));
        ArrayList<ApplicationTerm> l = new ArrayList<ApplicationTerm>();
        for (Term at : this.mArgumentTerms) {
            if (at instanceof ApplicationTerm) {
                l.add((ApplicationTerm)at);
                continue;
            }
            assert (at instanceof TermVariable);
            l.add(null);
        }
        this.mArgumentTermsAsAppTerm = Collections.unmodifiableList(l);
    }

    public EprPredicate getEprPredicate() {
        return this.mEprPredicateAtom.getEprPredicate();
    }

    public void beginScope() {
    }

    public void endScope() {
    }

    public List<Term> getArguments() {
        return this.mArgumentTerms;
    }

    public List<ApplicationTerm> getArgumentsAsAppTerm() {
        return this.mArgumentTermsAsAppTerm;
    }

    protected abstract DawgState<ApplicationTerm, EprTheory.TriBool> computeDawg();

    @Override
    protected boolean isDirty() {
        return this.mLastState != this.getEprPredicate().getDawg();
    }

    @Override
    public DawgState<ApplicationTerm, EprTheory.TriBool> getDawg() {
        if (this.mLastState != this.getEprPredicate().getDawg()) {
            this.mLastState = this.getEprPredicate().getDawg();
            this.mCachedDawg = this.computeDawg();
        }
        return this.mCachedDawg;
    }

    public abstract ApplicationTerm[] getInstantiatedArguments(ApplicationTerm[] var1);

    public abstract boolean isDisjointFrom(DawgState<ApplicationTerm, Boolean> var1);

    public abstract <V> DawgState<ApplicationTerm, V> litDawg2clauseDawg(DawgState<ApplicationTerm, V> var1);

    public abstract DawgState<ApplicationTerm, Boolean> clauseDawg2litDawg(DawgState<ApplicationTerm, Boolean> var1);

    public abstract Clause getGroundingForGroundLiteral(DawgState<ApplicationTerm, Boolean> var1, Literal var2);
}

