/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClauseEprQuantifiedLiteral
extends ClauseEprLiteral {
    private final EprQuantifiedPredicateAtom mAtom;
    Map<Integer, Map<ClauseEprQuantifiedLiteral, Set<Integer>>> identicalVariablePositionsInOtherClauseLiterals = new HashMap<Integer, Map<ClauseEprQuantifiedLiteral, Set<Integer>>>();
    private final SortedSet<TermVariable> mDawgSignature;
    private final ApplicationTerm[] mGroundArguments;
    private final int[] mVariableArguments;
    final int[] mClauseToPredPosition;

    public ClauseEprQuantifiedLiteral(boolean polarity, EprQuantifiedPredicateAtom atom, EprClause clause, EprTheory eprTheory) {
        super(polarity, atom, clause, eprTheory);
        int i;
        this.mAtom = atom;
        TreeSet vars = new TreeSet(EprHelpers.getColumnNamesComparator());
        for (Term arg : atom.getArguments()) {
            if (!(arg instanceof TermVariable)) continue;
            vars.add((TermVariable)arg);
        }
        this.mDawgSignature = vars;
        this.mGroundArguments = new ApplicationTerm[this.mArgumentTerms.size()];
        this.mVariableArguments = new int[this.mArgumentTerms.size()];
        this.mClauseToPredPosition = new int[this.mEprClause.getVariables().size()];
        for (i = 0; i < this.mClauseToPredPosition.length; ++i) {
            this.mClauseToPredPosition[i] = -1;
        }
        for (i = 0; i < this.mArgumentTerms.size(); ++i) {
            Term atomT = (Term)this.mArgumentTerms.get(i);
            if (atomT instanceof ApplicationTerm) {
                this.mGroundArguments[i] = (ApplicationTerm)atomT;
                this.mVariableArguments[i] = -1;
                continue;
            }
            int clausePos = this.mEprClause.getVariablePos((TermVariable)atomT);
            this.mGroundArguments[i] = null;
            this.mVariableArguments[i] = clausePos;
            this.mClauseToPredPosition[clausePos] = i;
        }
    }

    @Override
    public DawgState<ApplicationTerm, EprTheory.TriBool> computeDawg() {
        DawgState<ApplicationTerm, EprTheory.TriBool> dawg = this.mEprPredicateAtom.mEprPredicate.getDawg();
        if (!this.mPolarity) {
            dawg = this.mDawgFactory.createMapped(dawg, t -> t.negate());
        }
        return this.litDawg2clauseDawg(dawg);
    }

    @Override
    public boolean isDisjointFrom(DawgState<ApplicationTerm, Boolean> dawg) {
        return DawgFactory.isEmpty(this.mDawgFactory.projectWithMap(dawg, this.mGroundArguments));
    }

    @Override
    public ApplicationTerm[] getInstantiatedArguments(ApplicationTerm[] clauseGrounding) {
        ApplicationTerm[] args = new ApplicationTerm[this.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.mGroundArguments[i] != null ? this.mGroundArguments[i] : clauseGrounding[this.mVariableArguments[i]];
        }
        return args;
    }

    @Override
    public Clause getGroundingForGroundLiteral(DawgState<ApplicationTerm, Boolean> dawg, Literal groundLiteral) {
        ApplicationTerm term = (ApplicationTerm)groundLiteral.getAtom().getSMTFormula(this.mEprTheory.getTheory());
        List<ApplicationTerm> args = EprHelpers.convertTermArrayToConstantList(term.getParameters());
        HashMap<TermVariable, ApplicationTerm> selectMap = new HashMap<TermVariable, ApplicationTerm>();
        for (int i = 0; i < this.getArguments().size(); ++i) {
            if (this.getArguments().get(i) instanceof TermVariable) {
                selectMap.put((TermVariable)this.getArguments().get(i), args.get(i));
                continue;
            }
            assert (this.getArguments().get(i) == args.get(i));
        }
        DawgState<ApplicationTerm, Boolean> selDawg = this.mDawgFactory.createIntersection(dawg, this.mDawgFactory.createFromSelectMap(this.mEprClause.getVariables(), selectMap));
        Set<Clause> groundings = this.getClause().getGroundings(selDawg);
        return groundings.iterator().next();
    }

    public EprQuantifiedPredicateAtom getAtom() {
        return this.mAtom;
    }

    public boolean isEqualityLiteral() {
        return this.mAtom instanceof EprQuantifiedEqualityAtom;
    }

    @Override
    public <V> DawgState<ApplicationTerm, V> litDawg2clauseDawg(DawgState<ApplicationTerm, V> litDawg) {
        DawgState<ApplicationTerm, V> dawg = this.mDawgFactory.projectWithMap(litDawg, this.mGroundArguments);
        dawg = this.mDawgFactory.remap(dawg, this.mVariableArguments, this.mEprClause.getVariables());
        return dawg;
    }

    @Override
    public DawgState<ApplicationTerm, Boolean> clauseDawg2litDawg(DawgState<ApplicationTerm, Boolean> clauseDawg) {
        return this.mDawgFactory.translateClauseSigToPredSig(clauseDawg, this.mClauseToPredPosition, this.mGroundArguments, this.getEprPredicate().getTermVariablesForArguments());
    }
}

