/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseDpllLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClauseState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.UnitPropagationData;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackLiteral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class EprClause {
    private static final int DAWG_FALSE = -1;
    private static final int DAWG_TRUE = -2;
    private static final int DAWG_UNKNOWN = -3;
    private final List<Literal> mDpllLiterals;
    private final EprTheory mEprTheory;
    private final DawgFactory<ApplicationTerm, TermVariable> mDawgFactory;
    private DawgState<ApplicationTerm, Integer> mDawg;
    private final List<ClauseLiteral> mLiterals;
    private final boolean mIsGround;
    private final SortedSet<TermVariable> mVariables;
    boolean mClauseStateIsDirty = true;
    private EprClauseState mEprClauseState;
    private DawgState<ApplicationTerm, Boolean> mConflictPoints;
    private UnitPropagationData mUnitPropagationData;
    private boolean mHasBeenDisposed = false;

    public EprClause(Set<Literal> lits, EprTheory eprTheory) {
        this.mDpllLiterals = new ArrayList<Literal>(lits);
        this.mEprTheory = eprTheory;
        this.mDawgFactory = eprTheory.getDawgFactory();
        TreeSet variables = new TreeSet(EprHelpers.getColumnNamesComparator());
        for (Literal lit : lits) {
            variables.addAll(Arrays.asList(lit.getAtom().getSMTFormula(this.mEprTheory.getTheory()).getFreeVars()));
        }
        this.mVariables = variables;
        this.mLiterals = Collections.unmodifiableList(this.createClauseLiterals(lits));
        this.mIsGround = this.mVariables.isEmpty();
    }

    private List<ClauseLiteral> createClauseLiterals(Set<Literal> lits) {
        ArrayList<ClauseLiteral> literals = new ArrayList<ClauseLiteral>(lits.size());
        for (Literal l : lits) {
            ClauseEprLiteral newL;
            boolean polarity = l.getSign() == 1;
            DPLLAtom atom = l.getAtom();
            if (atom instanceof EprQuantifiedPredicateAtom || atom instanceof EprQuantifiedEqualityAtom) {
                EprQuantifiedPredicateAtom eqpa = (EprQuantifiedPredicateAtom)atom;
                newL = new ClauseEprQuantifiedLiteral(polarity, eqpa, this, this.mEprTheory);
                literals.add(newL);
                eqpa.getEprPredicate().addQuantifiedOccurence((ClauseEprQuantifiedLiteral)newL, this);
                continue;
            }
            if (atom instanceof EprGroundPredicateAtom) {
                EprGroundPredicateAtom egpa = (EprGroundPredicateAtom)atom;
                newL = new ClauseEprGroundLiteral(polarity, egpa, this, this.mEprTheory);
                literals.add(newL);
                egpa.getEprPredicate().addGroundOccurence((ClauseEprGroundLiteral)newL, this);
                continue;
            }
            if (atom instanceof EprGroundEqualityAtom) {
                assert (false) : "do we really have this case?";
                continue;
            }
            literals.add(new ClauseDpllLiteral(polarity, atom, this, this.mEprTheory));
        }
        return literals;
    }

    public void disposeOfClause() {
        assert (!this.mHasBeenDisposed);
        for (ClauseLiteral cl : this.mLiterals) {
            if (!(cl instanceof ClauseEprLiteral)) continue;
            ClauseEprLiteral cel = (ClauseEprLiteral)cl;
            cel.getEprPredicate().notifyAboutClauseDisposal(this);
        }
        this.mHasBeenDisposed = true;
    }

    public void backtrackStateWrtDecideStackLiteral(DecideStackLiteral dsl) {
        this.mClauseStateIsDirty = true;
    }

    private EprClauseState determineClauseState() {
        DawgState<ApplicationTerm, Integer> myDawg = this.mDawgFactory.createConstantDawg(this.getVariables(), -1);
        boolean isDirty = this.mEprClauseState == null;
        for (ClauseLiteral cl : this.getLiterals()) {
            if (!cl.isDirty()) continue;
            isDirty = true;
        }
        if (!isDirty) {
            return this.mEprClauseState;
        }
        for (int i2 = 0; i2 < this.getLiterals().size(); ++i2) {
            int litNr = i2;
            BiFunction<Integer, EprTheory.TriBool, Integer> clauseMerger = (status, tri) -> tri == EprTheory.TriBool.TRUE ? -2 : (tri == EprTheory.TriBool.FALSE ? status : (status == -1 ? litNr : (status == -2 ? -2 : -3)));
            myDawg = this.mDawgFactory.createProduct(myDawg, this.getLiterals().get(i2).getDawg(), clauseMerger);
            assert (myDawg.isTotal());
            if (!DawgFactory.isConstantValue(myDawg, -2)) continue;
            this.mEprClauseState = EprClauseState.Fulfilled;
            return this.mEprClauseState;
        }
        this.mDawg = myDawg;
        this.mConflictPoints = this.mDawgFactory.createMapped(myDawg, i -> i == -1);
        if (!DawgFactory.isEmpty(this.mConflictPoints)) {
            this.mEprClauseState = EprClauseState.Conflict;
        } else if (!DawgFactory.isEmpty(this.mDawgFactory.createMapped(myDawg, i -> i >= 0))) {
            this.mUnitPropagationData = new UnitPropagationData(this, myDawg, this.mDawgFactory);
            this.mEprClauseState = EprClauseState.Unit;
        } else {
            this.mEprClauseState = EprClauseState.Normal;
        }
        return this.mEprClauseState;
    }

    public SortedSet<TermVariable> getVariables() {
        return this.mVariables;
    }

    public int getVariablePos(TermVariable variable) {
        int index = 0;
        for (TermVariable tv : this.mVariables) {
            if (tv == variable) {
                return index;
            }
            ++index;
        }
        throw new NoSuchElementException();
    }

    public UnitPropagationData getUnitPropagationData() {
        assert (this.mUnitPropagationData != null);
        UnitPropagationData result = this.mUnitPropagationData;
        return result;
    }

    public boolean isUnit() {
        assert (!this.mHasBeenDisposed);
        return this.determineClauseState() == EprClauseState.Unit;
    }

    public boolean isConflict() {
        assert (!this.mHasBeenDisposed);
        return this.determineClauseState() == EprClauseState.Conflict;
    }

    public DawgState<ApplicationTerm, Boolean> getConflictPoints() {
        assert (this.isConflict());
        assert (this.mConflictPoints != null) : "this should have been set somewhere..";
        return this.mConflictPoints;
    }

    public DawgState<ApplicationTerm, Boolean> getUndecidedPoints() {
        return this.mDawgFactory.createMapped(this.mDawg, i -> i == -3);
    }

    public List<ClauseLiteral> getLiterals() {
        assert (!this.mHasBeenDisposed);
        return this.mLiterals;
    }

    public List<Literal[]> computeAllGroundings(List<TTSubstitution> allInstantiations) {
        ArrayList<Literal[]> result = new ArrayList<Literal[]>();
        for (TTSubstitution sub : allInstantiations) {
            ArrayList<Literal> groundInstList = this.getSubstitutedLiterals(sub);
            result.add(groundInstList.toArray(new Literal[groundInstList.size()]));
        }
        return result;
    }

    public List<Literal[]> computeAllGroundings(HashSet<ApplicationTerm> constants) {
        ArrayList<TTSubstitution> allInstantiations = EprHelpers.getAllInstantiations(this.getVariables(), constants);
        return this.computeAllGroundings(allInstantiations);
    }

    protected ArrayList<Literal> getSubstitutedLiterals(TTSubstitution sub) {
        assert (false) : "TODO reimplement";
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String comma = "";
        for (ClauseLiteral cl : this.getLiterals()) {
            sb.append(comma);
            sb.append(cl.toString());
            comma = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    public Set<Clause> getGroundings(DawgState<ApplicationTerm, Boolean> groundingDawg) {
        if (this.mIsGround) {
            assert (groundingDawg.isFinal());
            return groundingDawg.getFinalValue() != false ? Collections.singleton(new Clause(this.mDpllLiterals.toArray(new Literal[this.mDpllLiterals.size()]))) : Collections.emptySet();
        }
        HashSet<Clause> result = new HashSet<Clause>();
        for (List<ApplicationTerm> point : DawgFactory.getSet(groundingDawg)) {
            Set<Literal> groundLits = this.getGroundingForPoint(point).getDomain();
            result.add(new Clause(groundLits.toArray(new Literal[groundLits.size()])));
        }
        return result;
    }

    private BinaryRelation<Literal, ClauseLiteral> getGroundingForPoint(List<ApplicationTerm> point) {
        TTSubstitution sub = new TTSubstitution(this.mVariables, point);
        HashSet<Literal> groundLits = new HashSet<Literal>();
        BinaryRelation<Literal, ClauseLiteral> instantiationToClauseLiteral = new BinaryRelation<Literal, ClauseLiteral>();
        for (ClauseLiteral cl : this.getLiterals()) {
            if (cl instanceof ClauseEprQuantifiedLiteral) {
                ClauseEprQuantifiedLiteral ceql = (ClauseEprQuantifiedLiteral)cl;
                Term[] ceqlArgs = ceql.mArgumentTerms.toArray(new Term[ceql.mArgumentTerms.size()]);
                TermTuple newTT = sub.apply(new TermTuple(ceqlArgs));
                assert (newTT.getFreeVars().size() == 0);
                EprPredicateAtom at = ceql.getEprPredicate().getAtomForTermTuple(newTT, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), ceql.getAtom().getSourceAnnotation());
                Literal newLit = cl.getPolarity() ? at : at.negate();
                instantiationToClauseLiteral.addPair(newLit, ceql);
                groundLits.add(newLit);
                continue;
            }
            instantiationToClauseLiteral.addPair(cl.getLiteral(), cl);
            groundLits.add(cl.getLiteral());
        }
        return instantiationToClauseLiteral;
    }

    public EprClause factorIfPossible() {
        for (List<ApplicationTerm> cp : DawgFactory.getSet(this.getConflictPoints())) {
            BinaryRelation<Literal, ClauseLiteral> cpg = this.getGroundingForPoint(cp);
            for (Literal groundLit : cpg.getDomain()) {
                Set<ClauseLiteral> preGroundingClauseLits = cpg.getImage(groundLit);
                if (preGroundingClauseLits.size() == 1) continue;
                assert (preGroundingClauseLits.size() > 1);
                assert (preGroundingClauseLits.size() == 2) : "TODO: deal with factoring for more than two literals";
                ClauseEprQuantifiedLiteral ceql = null;
                Object cel = null;
                for (ClauseLiteral cl : preGroundingClauseLits) {
                    assert (cl instanceof ClauseEprLiteral);
                    if (ceql == null && cl instanceof ClauseEprQuantifiedLiteral) {
                        ceql = (ClauseEprQuantifiedLiteral)cl;
                        continue;
                    }
                    if (cel != null || ceql == null && cl instanceof ClauseEprQuantifiedLiteral) continue;
                    cel = (ClauseEprLiteral)cl;
                }
                assert (cel != null && ceql != null && !cel.equals(ceql));
                this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClause): factoring " + this);
                EprClause factor = this.mEprTheory.getEprClauseFactory().getFactoredClause(ceql, (ClauseEprLiteral)cel);
                assert (factor.isConflict()) : "we only factor conflicts -- we should get a conflict out, too.";
                return factor;
            }
        }
        return this;
    }
}

