/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyConstructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EprClauseFactory {
    EprTheory mEprTheory;
    private final ScopedHashMap<Set<Literal>, EprClause> mLiteralsToClause = new ScopedHashMap();

    public EprClauseFactory(EprTheory eprTheory) {
        this.mEprTheory = eprTheory;
    }

    public EprClause createResolvent(ClauseEprLiteral pivot1, ClauseEprLiteral pivot2) {
        assert (pivot1.getPolarity() != pivot2.getPolarity());
        int arity = pivot1.getArguments().size();
        assert (arity == pivot2.getArguments().size());
        EprClause c1 = pivot1.getClause();
        EprClause c2 = pivot2.getClause();
        List<ClauseLiteral> c1Lits = c1.getLiterals();
        List<ClauseLiteral> c2Lits = c2.getLiterals();
        TermTuple p1tt = new TermTuple(pivot1.getArguments().toArray(new Term[arity]));
        TermTuple p2tt = new TermTuple(pivot2.getArguments().toArray(new Term[arity]));
        TTSubstitution unifier = p1tt.match(p2tt, this.mEprTheory.getEqualityManager());
        HashSet<ClauseLiteral> resCls = new HashSet<ClauseLiteral>();
        resCls.addAll(c1Lits);
        resCls.remove(pivot1);
        resCls.addAll(c2Lits);
        resCls.remove(pivot2);
        Set<Literal> resLits = this.computeUnifiedLiteralsFromClauseLiterals(unifier, resCls);
        EprClause resolvent = this.getEprClause(resLits);
        return resolvent;
    }

    public EprClause getFactoredClause(ClauseEprQuantifiedLiteral factorLit1, ClauseEprLiteral factorLit2) {
        assert (factorLit1.getPolarity() == factorLit2.getPolarity());
        EprPredicate flPred = factorLit1.getEprPredicate();
        assert (flPred == factorLit2.getEprPredicate());
        assert (factorLit1.getClause() == factorLit2.getClause());
        int arity = flPred.getArity();
        EprClause clause = factorLit1.getClause();
        List<ClauseLiteral> cLits = clause.getLiterals();
        TermTuple p1tt = new TermTuple(factorLit1.getArguments().toArray(new Term[arity]));
        TermTuple p2tt = new TermTuple(factorLit2.getArguments().toArray(new Term[arity]));
        TTSubstitution unifier = p1tt.match(p2tt, this.mEprTheory.getEqualityManager());
        HashSet<ClauseLiteral> resCls = new HashSet<ClauseLiteral>();
        resCls.addAll(cLits);
        resCls.remove(factorLit2);
        Set<Literal> resLits = this.computeUnifiedLiteralsFromClauseLiterals(unifier, resCls);
        Set<Literal> cerResLits = new ApplyConstructiveEqualityReasoning(this.mEprTheory, resLits).getResult();
        EprClause factor = this.getEprClause(cerResLits);
        boolean isConflict = factor.isConflict();
        assert (isConflict);
        return factor;
    }

    public EprClause getEprClause(Set<Literal> literals) {
        Set<Literal> alphaRenamedLiterals = this.alphaRenameLiterals(literals);
        EprClause result = this.mLiteralsToClause.get(alphaRenamedLiterals);
        if (result == null) {
            result = new EprClause(alphaRenamedLiterals, this.mEprTheory);
            this.mEprTheory.getLogger().debug("EPRDEBUG (EprClauseFactory): creating new clause " + result);
            this.mLiteralsToClause.put(alphaRenamedLiterals, result);
        } else {
            this.mEprTheory.getLogger().debug("EPRDEBUG (EprClauseFactory): clause has been added before " + result);
            result.mClauseStateIsDirty = true;
        }
        return result;
    }

    public void push() {
        this.mLiteralsToClause.beginScope();
    }

    public void pop() {
        this.mLiteralsToClause.endScope();
    }

    private Set<Literal> computeUnifiedLiteralsFromClauseLiterals(TTSubstitution unifier, Set<ClauseLiteral> resCls) {
        HashSet<Literal> resLits = new HashSet<Literal>();
        for (ClauseLiteral cl : resCls) {
            if (cl instanceof ClauseEprQuantifiedLiteral) {
                EprPredicateAtom atom;
                ClauseEprQuantifiedLiteral clQ = (ClauseEprQuantifiedLiteral)cl;
                EprPredicate pred = clQ.getEprPredicate();
                List<Term> clArgs = clQ.getArguments();
                TermTuple cltt = new TermTuple(clArgs.toArray(new Term[clArgs.size()]));
                TermTuple unifiedClTt = unifier.apply(cltt);
                Literal newCl = null;
                if (unifiedClTt.isGround()) {
                    atom = (EprGroundPredicateAtom)pred.getAtomForTermTuple(unifiedClTt, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), clQ.getAtom().getSourceAnnotation());
                    newCl = cl.getPolarity() ? atom : atom.negate();
                } else {
                    atom = (EprQuantifiedPredicateAtom)pred.getAtomForTermTuple(unifiedClTt, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), clQ.getAtom().getSourceAnnotation());
                    newCl = cl.getPolarity() ? atom : atom.negate();
                }
                resLits.add(newCl);
                continue;
            }
            resLits.add(cl.getLiteral());
        }
        return resLits;
    }

    private Set<Literal> alphaRenameLiterals(Set<Literal> literals) {
        HashSet<Literal> alphaRenamedLiterals = new HashSet<Literal>();
        HashMap<TermVariable, Term> substitution = new HashMap<TermVariable, Term>();
        for (Literal l : literals) {
            if (l.getAtom() instanceof EprQuantifiedEqualityAtom || l.getAtom() instanceof EprQuantifiedPredicateAtom) {
                EprAtom arAtom = this.applyAlphaRenamingToQuantifiedEprAtom((EprAtom)l.getAtom(), substitution);
                Literal arLiteral = l.getSign() == 1 ? arAtom : arAtom.negate();
                alphaRenamedLiterals.add(arLiteral);
                continue;
            }
            alphaRenamedLiterals.add(l);
        }
        return alphaRenamedLiterals;
    }

    private EprAtom applyAlphaRenamingToQuantifiedEprAtom(EprAtom atom, Map<TermVariable, Term> sub) {
        assert (atom instanceof EprQuantifiedPredicateAtom || atom instanceof EprQuantifiedEqualityAtom);
        for (Term t : atom.getArguments()) {
            if (t instanceof ApplicationTerm || sub.containsKey(t)) continue;
            TermVariable tv = (TermVariable)t;
            String newTvNamePrefix = tv.getName();
            newTvNamePrefix = newTvNamePrefix.replaceAll("\\.\\d+", "");
            newTvNamePrefix = newTvNamePrefix.replaceAll("\\.(\\.)+", "");
            sub.put(tv, this.mEprTheory.getTheory().createFreshTermVariable(newTvNamePrefix, tv.getSort()));
        }
        TermTuple tt = atom.getArgumentsAsTermTuple();
        TermTuple ttSub = tt.applySubstitution(sub);
        FunctionSymbol fs = ((ApplicationTerm)atom.getSMTFormula(this.mEprTheory.getTheory())).getFunction();
        ApplicationTerm subTerm = (ApplicationTerm)this.mEprTheory.getTheory().term(fs, ttSub.terms);
        EprAtom subAtom = this.mEprTheory.getEprAtom(subTerm, 0, this.mEprTheory.getClausifier().getStackLevel(), atom.getSourceAnnotation());
        return subAtom;
    }
}

