/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.HashSet;
import java.util.Set;

public class EprClauseManager {
    private final ScopedHashSet<EprClause> mEprClauses = new ScopedHashSet();
    ScopedHashMap<DPLLAtom, HashSet<EprClause>> mDPLLAtomToClauses = new ScopedHashMap();
    private final EprTheory mEprTheory;

    public EprClauseManager(EprTheory eprTheory) {
        this.mEprTheory = eprTheory;
    }

    public void push() {
        this.mEprClauses.beginScope();
        this.mDPLLAtomToClauses.beginScope();
    }

    public void pop() {
        for (EprClause ec : this.mEprClauses.currentScope()) {
            ec.disposeOfClause();
        }
        this.mEprClauses.endScope();
        this.mDPLLAtomToClauses.endScope();
    }

    public Iterable<EprClause> getAllClauses() {
        return this.mEprClauses;
    }

    public void updateAtomToClauses(DPLLAtom atom, EprClause c) {
        HashSet<EprClause> clauses = this.mDPLLAtomToClauses.get(atom);
        if (clauses == null) {
            clauses = new HashSet();
            this.mDPLLAtomToClauses.put(atom, clauses);
        }
        clauses.add(c);
    }

    public Clause createEprClause(Set<Literal> literals) {
        EprClause newClause = this.mEprTheory.getEprClauseFactory().getEprClause(literals);
        this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClauseManager) creating new EprClause: " + newClause);
        this.registerEprClause(newClause);
        return null;
    }

    public void registerEprClause(EprClause newClause) {
        this.mEprClauses.add(newClause);
        for (ClauseLiteral cl : newClause.getLiterals()) {
            this.updateAtomToClauses(cl.getLiteral().getAtom(), newClause);
        }
    }

    public String toString() {
        return "EprClauseManager, Clauses: " + this.mEprClauses;
    }
}

