/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseDpllLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackPropagatedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.GroundPropagationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnitPropagationData {
    private final List<GroundPropagationInfo> mGroundPropagations;
    private final List<DecideStackEntry> mQuantifiedPropagations;

    public UnitPropagationData(EprClause clause, DawgState<ApplicationTerm, Integer> clauseDawg, DawgFactory<ApplicationTerm, TermVariable> dawgFactory) {
        ArrayList<GroundPropagationInfo> groundPropagations = new ArrayList<GroundPropagationInfo>();
        ArrayList<DecideStackPropagatedLiteral> quantifiedPropagations = new ArrayList<DecideStackPropagatedLiteral>();
        for (int i = 0; i < clause.getLiterals().size(); ++i) {
            ClauseLiteral cl = clause.getLiterals().get(i);
            int litNr = i;
            DawgState<ApplicationTerm, Boolean> unitPoints = dawgFactory.createMapped(clauseDawg, status -> status == litNr);
            assert (unitPoints.isTotal());
            if (DawgFactory.isEmpty(unitPoints)) continue;
            if (cl instanceof ClauseEprLiteral) {
                ClauseEprLiteral cel = (ClauseEprLiteral)cl;
                DecideStackPropagatedLiteral dspl = new DecideStackPropagatedLiteral(cel, unitPoints);
                quantifiedPropagations.add(dspl);
                continue;
            }
            ClauseDpllLiteral cdl = (ClauseDpllLiteral)cl;
            groundPropagations.add(new GroundPropagationInfo(cdl, unitPoints));
        }
        this.mQuantifiedPropagations = Collections.unmodifiableList(quantifiedPropagations);
        this.mGroundPropagations = Collections.unmodifiableList(groundPropagations);
    }

    public List<DecideStackEntry> getQuantifiedPropagations() {
        return this.mQuantifiedPropagations;
    }

    public List<GroundPropagationInfo> getGroundPropagations() {
        return this.mGroundPropagations;
    }
}

