/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.MappedDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ProductDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ProjectDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ReorderDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetterFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.BinaryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DawgFactory<LETTER, COLNAMES> {
    private final DawgLetterFactory<LETTER> mDawgLetterFactory;
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final Map<Object, Set<LETTER>> mConstants = new HashMap<Object, Set<LETTER>>();

    public DawgFactory(EprTheory eprTheory) {
        this.mDawgLetterFactory = new DawgLetterFactory(this);
        this.mDawgStateFactory = new DawgStateFactory();
    }

    public void addConstant(Object sortId, LETTER ltr) {
        Set<LETTER> set = this.mConstants.get(sortId);
        if (set == null) {
            set = new HashSet<LETTER>();
            this.mConstants.put(sortId, set);
        }
        set.add(ltr);
    }

    public Set<LETTER> getAllConstants(Object sortId) {
        if (this.mConstants.containsKey(sortId)) {
            return this.mConstants.get(sortId);
        }
        return Collections.emptySet();
    }

    public <VALUE> DawgState<LETTER, VALUE> createConstantDawg(SortedSet<COLNAMES> termVariables, VALUE value) {
        DawgState<LETTER, VALUE> state = this.mDawgStateFactory.createFinalState(value);
        Object[] columns = termVariables.toArray(new Object[termVariables.size()]);
        for (int i = columns.length - 1; i >= 0; --i) {
            Object cn = columns[i];
            Object sort = EprHelpers.extractSortFromColname(cn);
            DawgLetter<LETTER> letter = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
            state = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(state, letter));
        }
        return state;
    }

    public DawgState<LETTER, Boolean> createSingletonSet(SortedSet<COLNAMES> termVariables, List<LETTER> word) {
        DawgState<LETTER, Boolean> success = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> sink = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] columns = termVariables.toArray(new Object[termVariables.size()]);
        for (int i = columns.length - 1; i >= 0; --i) {
            Object cn = columns[i];
            Object sort = EprHelpers.extractSortFromColname(cn);
            DawgLetter<LETTER> goodLetter = this.mDawgLetterFactory.getSingletonSetDawgLetter(word.get(i), sort);
            DawgLetter<LETTER> badLetter = goodLetter.complement();
            DawgLetter<LETTER> all = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
            success = this.mDawgStateFactory.createIntermediateState(new BinaryMap(success, goodLetter, sink, badLetter));
            sink = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(sink, all));
        }
        return success;
    }

    public DawgState<LETTER, Boolean> createSingletonPattern(SortedSet<COLNAMES> termVariables, List<DawgLetter<LETTER>> word) {
        DawgState<LETTER, Boolean> success = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> sink = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] columns = termVariables.toArray(new Object[termVariables.size()]);
        for (int i = columns.length - 1; i >= 0; --i) {
            Object cn = columns[i];
            Object sort = EprHelpers.extractSortFromColname(cn);
            DawgLetter<LETTER> goodLetter = word.get(i);
            DawgLetter<LETTER> badLetter = goodLetter.complement();
            DawgLetter<LETTER> all = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
            success = this.mDawgStateFactory.createIntermediateState(new BinaryMap(success, goodLetter, sink, badLetter));
            sink = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(sink, all));
        }
        return success;
    }

    public DawgState<LETTER, Boolean> createPatternMatchSet(SortedSet<COLNAMES> termVariables, List<LETTER> word) {
        DawgState<LETTER, Boolean> success = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> sink = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] columns = termVariables.toArray(new Object[termVariables.size()]);
        for (int i = columns.length - 1; i >= 0; --i) {
            Object cn = columns[i];
            Object sort = EprHelpers.extractSortFromColname(cn);
            DawgLetter<LETTER> all = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
            if (word.get(i) == null) {
                success = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(success, all));
            } else {
                DawgLetter<LETTER> goodLetter = this.mDawgLetterFactory.getSingletonSetDawgLetter(word.get(i), sort);
                DawgLetter<LETTER> badLetter = goodLetter.complement();
                success = this.mDawgStateFactory.createIntermediateState(new BinaryMap(success, goodLetter, sink, badLetter));
            }
            sink = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(sink, all));
        }
        return success;
    }

    public DawgState<LETTER, Boolean> createFromSelectMap(SortedSet<COLNAMES> termVariables, Map<COLNAMES, LETTER> selectMap) {
        DawgState<LETTER, Boolean> success = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> sink = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] columns = termVariables.toArray(new Object[termVariables.size()]);
        for (int i = columns.length - 1; i >= 0; --i) {
            Object cn = columns[i];
            Object sort = EprHelpers.extractSortFromColname(cn);
            DawgLetter<LETTER> all = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
            if (selectMap.containsKey(columns[i])) {
                DawgLetter<LETTER> goodLetter = this.mDawgLetterFactory.getSingletonSetDawgLetter(selectMap.get(columns[i]), sort);
                DawgLetter<LETTER> badLetter = goodLetter.complement();
                success = this.mDawgStateFactory.createIntermediateState(new BinaryMap(success, goodLetter, sink, badLetter));
            } else {
                success = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(success, all));
            }
            sink = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(sink, all));
        }
        return success;
    }

    public <V1, V2> DawgState<LETTER, V2> createMapped(DawgState<LETTER, V1> first, Function<V1, V2> map) {
        MappedDawgBuilder builder = new MappedDawgBuilder(this, map);
        return builder.map(first);
    }

    public <V1, V2, V3> DawgState<LETTER, V3> createProduct(DawgState<LETTER, V1> first, DawgState<LETTER, V2> second, BiFunction<V1, V2, V3> combinator) {
        ProductDawgBuilder builder = new ProductDawgBuilder(this, combinator);
        return builder.product(first, second);
    }

    public DawgState<LETTER, Boolean> createDifference(DawgState<LETTER, Boolean> first, DawgState<LETTER, Boolean> second) {
        return this.createProduct(first, second, (in1, in2) -> in1 != false && in2 == false);
    }

    public DawgState<LETTER, Boolean> createUnion(DawgState<LETTER, Boolean> first, DawgState<LETTER, Boolean> second) {
        return this.createProduct(first, second, (in1, in2) -> in1 != false || in2 != false);
    }

    public DawgState<LETTER, Boolean> createIntersection(DawgState<LETTER, Boolean> first, DawgState<LETTER, Boolean> second) {
        return this.createProduct(first, second, (in1, in2) -> in1 != false && in2 != false);
    }

    private <VALUE> DawgState<LETTER, VALUE> projectWithMapInternal(DawgState<LETTER, VALUE> dawg, LETTER[] selectMap, int level) {
        if (dawg.isFinal()) {
            return dawg;
        }
        if (selectMap[level] != null) {
            LETTER ltr = selectMap[level];
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> trans : dawg.getTransitions().entrySet()) {
                if (!trans.getValue().matches(ltr)) continue;
                return this.projectWithMapInternal(trans.getKey(), selectMap, level + 1);
            }
            throw new AssertionError();
        }
        HashMap newTransitions = new HashMap();
        for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> trans : dawg.getTransitions().entrySet()) {
            DawgState<LETTER, VALUE> newState = this.projectWithMapInternal(trans.getKey(), selectMap, level + 1);
            DawgBuilder.addLetterToMap(newTransitions, newState, trans.getValue());
        }
        return this.mDawgStateFactory.createIntermediateState(newTransitions);
    }

    public <VALUE> DawgState<LETTER, VALUE> projectWithMap(DawgState<LETTER, VALUE> dawg, LETTER[] selectMap) {
        return this.projectWithMapInternal(dawg, selectMap, 0);
    }

    public static <LETTER, VALUE> boolean isConstantValue(DawgState<LETTER, VALUE> state, VALUE value) {
        if (state.isFinal()) {
            return state.getFinalValue() == value;
        }
        return state.getTransitions().size() == 1 && DawgFactory.isConstantValue(state.getTransitions().keySet().iterator().next(), value);
    }

    public static <LETTER> boolean isUniversal(DawgState<LETTER, Boolean> state) {
        return DawgFactory.isConstantValue(state, Boolean.TRUE);
    }

    public static <LETTER> boolean isEmpty(DawgState<LETTER, Boolean> state) {
        return DawgFactory.isConstantValue(state, Boolean.FALSE);
    }

    public static <LETTER> Iterable<List<LETTER>> getSet(final DawgState<LETTER, Boolean> state) {
        if (state.isFinal()) {
            return state.getFinalValue() != false ? Collections.singleton(Collections.emptyList()) : Collections.emptySet();
        }
        return new Iterable<List<LETTER>>(){

            @Override
            public Iterator<List<LETTER>> iterator() {
                return new Iterator<List<LETTER>>(){
                    Iterator<DawgState<LETTER, Boolean>> transIterator;
                    DawgState<LETTER, Boolean> currentSubState;
                    Iterator<LETTER> letterIterator;
                    LETTER currentLetter;
                    Iterator<List<LETTER>> subIterator;
                    {
                        this.transIterator = state.getTransitions().keySet().iterator();
                        this.currentSubState = this.transIterator.next();
                        this.letterIterator = state.getTransitions().get(this.currentSubState).getLetters().iterator();
                        this.subIterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.subIterator == null || !this.subIterator.hasNext()) {
                            while (!this.letterIterator.hasNext()) {
                                if (!this.transIterator.hasNext()) {
                                    return false;
                                }
                                this.currentSubState = this.transIterator.next();
                                this.letterIterator = state.getTransitions().get(this.currentSubState).getLetters().iterator();
                            }
                            this.currentLetter = this.letterIterator.next();
                            this.subIterator = DawgFactory.getSet(this.currentSubState).iterator();
                        }
                        return true;
                    }

                    @Override
                    public List<LETTER> next() {
                        List currentSuffix = this.subIterator.next();
                        ArrayList result = new ArrayList(currentSuffix.size() + 1);
                        result.add(this.currentLetter);
                        result.addAll(currentSuffix);
                        return result;
                    }
                };
            }
        };
    }

    public DawgLetterFactory<LETTER> getDawgLetterFactory() {
        return this.mDawgLetterFactory;
    }

    public DawgStateFactory<LETTER> getDawgStateFactory() {
        return this.mDawgStateFactory;
    }

    /*
     * WARNING - void declaration
     */
    public DawgState<LETTER, Boolean> computeSymmetricTransitiveClosure(DawgState<LETTER, Boolean> binRelation) {
        Object sort = binRelation.getTransitions().values().iterator().next().getSortId();
        HashSet<Object> partitions = new HashSet<Object>();
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> trans1 : binRelation.getTransitions().entrySet()) {
            if (DawgFactory.isEmpty(trans1.getKey())) continue;
            partitions.add(trans1.getValue());
        }
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> trans1 : binRelation.getTransitions().entrySet()) {
            for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> trans2 : trans1.getKey().getTransitions().entrySet()) {
                void var10_10;
                DawgLetter<LETTER> newElems;
                if (trans2.getKey().getFinalValue() != Boolean.TRUE || (newElems = trans2.getValue().difference(trans1.getValue())).isEmpty()) continue;
                DawgLetter<LETTER> union = trans1.getValue().union(trans2.getValue());
                DawgLetter<LETTER> dawgLetter = trans2.getValue();
                Iterator it = partitions.iterator();
                while (it.hasNext()) {
                    DawgLetter otherPart = (DawgLetter)it.next();
                    if (otherPart.isDisjoint(union)) continue;
                    DawgLetter dawgLetter2 = var10_10.union(otherPart);
                    it.remove();
                }
                partitions.add(var10_10);
            }
        }
        HashMap firstTrans = new HashMap();
        DawgLetter<LETTER> all = this.mDawgLetterFactory.getUniversalDawgLetter(sort);
        DawgState<LETTER, Boolean> sink = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        DawgState<LETTER, Boolean> good = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgLetter<LETTER> remainder = all;
        for (DawgLetter dawgLetter : partitions) {
            assert (!dawgLetter.isEmpty());
            remainder = remainder.difference(dawgLetter);
            DawgState intermediate = this.mDawgStateFactory.createIntermediateState(new BinaryMap(good, dawgLetter, sink, dawgLetter.complement()));
            firstTrans.put(intermediate, dawgLetter);
        }
        firstTrans.put(this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(sink, all)), remainder);
        return this.mDawgStateFactory.createIntermediateState(firstTrans);
    }

    public static <LETTER> boolean isSingleton(DawgState<LETTER, Boolean> dawg) {
        if (dawg.isFinal()) {
            return dawg.getFinalValue();
        }
        boolean foundSingleton = false;
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : dawg.getTransitions().entrySet()) {
            if (DawgFactory.isEmpty(entry.getKey())) continue;
            if (foundSingleton || !entry.getValue().isSingleton() || !DawgFactory.isSingleton(entry.getKey())) {
                return false;
            }
            foundSingleton = true;
        }
        return foundSingleton;
    }

    public <VALUE> DawgState<LETTER, VALUE> remap(DawgState<LETTER, VALUE> dawg, int[] columnMap, SortedSet<COLNAMES> clauseVariables) {
        int numVars = 0;
        for (int i = 0; i < columnMap.length; ++i) {
            if (columnMap[i] < 0) continue;
            ++numVars;
        }
        ArrayList clauseWord = new ArrayList(clauseVariables.size());
        for (Object tv : clauseVariables) {
            Object sort = EprHelpers.extractSortFromColname(tv);
            clauseWord.add(this.mDawgLetterFactory.getUniversalDawgLetter(sort));
        }
        int[] columnIndexCompressed = new int[numVars];
        int compressedIdx = 0;
        for (int i = 0; i < columnMap.length; ++i) {
            if (columnMap[i] < 0) continue;
            columnIndexCompressed[compressedIdx++] = columnMap[i];
            clauseWord.set(columnMap[i], null);
        }
        dawg = new ReorderDawgBuilder(this).reorder(dawg, clauseWord, columnIndexCompressed);
        return dawg;
    }

    public DawgState<LETTER, Boolean> translateClauseSigToPredSig(DawgState<LETTER, Boolean> dawg, int[] clausePos2predPos, LETTER[] groundArguments, SortedSet<COLNAMES> predVariables) {
        ArrayList predWord = new ArrayList(groundArguments.length);
        int index = 0;
        for (Object tv : predVariables) {
            Object sort = EprHelpers.extractSortFromColname(tv);
            if (groundArguments[index] == null) {
                predWord.add(null);
            } else {
                predWord.add(this.mDawgLetterFactory.getUniversalDawgLetter(sort));
            }
            ++index;
        }
        int numOccuringVars = 0;
        for (int i = 0; i < clausePos2predPos.length; ++i) {
            if (clausePos2predPos[i] < 0) continue;
            ++numOccuringVars;
        }
        int[] columnIndexMap = new int[numOccuringVars];
        BitSet clauseVarInUse = new BitSet();
        int projectedIndex = 0;
        for (int i = 0; i < clausePos2predPos.length; ++i) {
            if (clausePos2predPos[i] < 0) continue;
            columnIndexMap[projectedIndex] = clausePos2predPos[i];
            assert (predWord.get(columnIndexMap[projectedIndex]) == null);
            clauseVarInUse.set(i);
            ++projectedIndex;
        }
        dawg = new ProjectDawgBuilder(this, clausePos2predPos.length, clauseVarInUse).project(dawg);
        dawg = new ReorderDawgBuilder(this).reorder(dawg, predWord, columnIndexMap);
        dawg = this.createIntersection(dawg, this.createPatternMatchSet(predVariables, Arrays.asList(groundArguments)));
        return dawg;
    }

    public static <LETTER> List<DawgLetter<LETTER>> getOneWord(DawgState<LETTER, Boolean> dawg) {
        assert (!DawgFactory.isEmpty(dawg));
        ArrayList<DawgLetter<LETTER>> word = new ArrayList<DawgLetter<LETTER>>();
        while (!dawg.isFinal()) {
            for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : dawg.getTransitions().entrySet()) {
                if (DawgFactory.isEmpty(entry.getKey())) continue;
                word.add(entry.getValue());
                dawg = entry.getKey();
                break;
            }
            assert (!DawgFactory.isEmpty(dawg));
        }
        return word;
    }
}

