/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MappedDawgBuilder<LETTER, COLNAMES, V1, V2>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Function<V1, V2> mOperation;
    private final Map<DawgState<LETTER, V1>, DawgState<LETTER, V2>> mCache;

    public MappedDawgBuilder(DawgFactory<LETTER, COLNAMES> factory, Function<V1, V2> operation) {
        this.mDawgFactory = factory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mOperation = operation;
        this.mCache = new HashMap<DawgState<LETTER, V1>, DawgState<LETTER, V2>>();
    }

    public DawgState<LETTER, V2> map(DawgState<LETTER, V1> input) {
        DawgState<LETTER, Object> result = this.mCache.get(input);
        if (result != null) {
            return result;
        }
        if (input.isFinal()) {
            result = this.mDawgStateFactory.createFinalState(this.mOperation.apply(input.getFinalValue()));
        } else {
            HashMap newTrans = new HashMap();
            for (Map.Entry<DawgState<LETTER, V1>, DawgLetter<LETTER>> trans : input.getTransitions().entrySet()) {
                MappedDawgBuilder.addLetterToMap(newTrans, this.map(trans.getKey()), trans.getValue());
            }
            result = this.mDawgStateFactory.createIntermediateState(newTrans);
        }
        this.mCache.put(input, result);
        return result;
    }
}

