/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ProductDawgBuilder<LETTER, COLNAMES, V1, V2, V3> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final BiFunction<V1, V2, V3> mOperation;
    private final Map<Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>, DawgState<LETTER, V3>> mCache;

    public ProductDawgBuilder(DawgFactory<LETTER, COLNAMES> factory, BiFunction<V1, V2, V3> operation) {
        this.mDawgFactory = factory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mOperation = operation;
        this.mCache = new HashMap<Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>, DawgState<LETTER, V3>>();
    }

    public DawgState<LETTER, V3> product(DawgState<LETTER, V1> state1, DawgState<LETTER, V2> state2) {
        Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>> input = new Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>(state1, state2);
        DawgState<LETTER, Object> result = this.mCache.get(input);
        if (result != null) {
            return result;
        }
        if (state1.isFinal()) {
            assert (state2.isFinal());
            result = this.mDawgStateFactory.createFinalState(this.mOperation.apply(state1.getFinalValue(), state2.getFinalValue()));
        } else {
            HashMap newTrans = new HashMap();
            for (Map.Entry<DawgState<LETTER, V1>, DawgLetter<LETTER>> trans1 : state1.getTransitions().entrySet()) {
                for (Map.Entry<DawgState<LETTER, V2>, DawgLetter<LETTER>> trans2 : state2.getTransitions().entrySet()) {
                    if (trans1.getValue().isDisjoint(trans2.getValue())) continue;
                    DawgLetter<LETTER> newLetter = trans1.getValue().intersect(trans2.getValue());
                    DawgState<LETTER, V3> newState = this.product(trans1.getKey(), trans2.getKey());
                    if (newTrans.containsKey(newState)) {
                        newTrans.put(newState, newTrans.get(newState).union(newLetter));
                        continue;
                    }
                    newTrans.put(newState, newLetter);
                }
            }
            result = this.mDawgStateFactory.createIntermediateState(newTrans);
        }
        this.mCache.put(input, result);
        return result;
    }
}

