/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectDawgBuilder<LETTER, COLNAMES>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Map<Set<DawgState<LETTER, Boolean>>, DawgState<LETTER, Boolean>> mCache;
    private final int mNumColumns;
    private final BitSet mProjectedColumns;

    public ProjectDawgBuilder(DawgFactory<LETTER, COLNAMES> factory, int numColumns, BitSet projected) {
        this.mDawgFactory = factory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mNumColumns = numColumns;
        this.mProjectedColumns = projected;
        this.mCache = new HashMap<Set<DawgState<LETTER, Boolean>>, DawgState<LETTER, Boolean>>();
    }

    private DawgState<LETTER, Boolean> projectAndJoin(Set<DawgState<LETTER, Boolean>> suffixes, int level) {
        DawgState<LETTER, Boolean> result = this.mCache.get(suffixes);
        if (result != null) {
            return result;
        }
        if (level == this.mNumColumns) {
            for (DawgState<LETTER, Boolean> component : suffixes) {
                assert (component.isFinal());
                if (!component.getFinalValue().booleanValue()) continue;
                return component;
            }
            assert (!suffixes.isEmpty());
            result = suffixes.iterator().next();
        } else if (this.mProjectedColumns.get(level)) {
            Map newSuccessors = new HashMap();
            Object sort = suffixes.iterator().next().getTransitions().values().iterator().next().getSortId();
            newSuccessors.put(new HashSet(), this.mDawgFactory.getDawgLetterFactory().getUniversalDawgLetter(sort));
            for (DawgState<LETTER, Boolean> component : suffixes) {
                for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : component.getTransitions().entrySet()) {
                    newSuccessors = this.merge(newSuccessors, entry.getKey(), entry.getValue());
                }
            }
            HashMap newTrans = new HashMap();
            for (Map.Entry entry : newSuccessors.entrySet()) {
                DawgState<LETTER, Boolean> newDest = this.projectAndJoin((Set)entry.getKey(), level + 1);
                ProjectDawgBuilder.addLetterToMap(newTrans, newDest, (DawgLetter)entry.getValue());
            }
            result = this.mDawgStateFactory.createIntermediateState(newTrans);
        } else {
            HashSet<DawgState<LETTER, Boolean>> newReachableStates = new HashSet<DawgState<LETTER, Boolean>>();
            for (DawgState<LETTER, Boolean> component : suffixes) {
                newReachableStates.addAll(component.getTransitions().keySet());
            }
            result = this.projectAndJoin(newReachableStates, level + 1);
        }
        this.mCache.put(suffixes, result);
        return result;
    }

    public final DawgState<LETTER, Boolean> project(DawgState<LETTER, Boolean> input) {
        return this.projectAndJoin(Collections.singleton(input), 0);
    }
}

