/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReorderDawgBuilder<LETTER, VALUE, COLNAMES>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Map<Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>> mCache;
    private final Map<Set<DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>> mUnionCache;

    public ReorderDawgBuilder(DawgFactory<LETTER, COLNAMES> factory) {
        this.mDawgFactory = factory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mCache = new HashMap<Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>>();
        this.mUnionCache = new HashMap<Set<DawgState<LETTER, VALUE>>, DawgState<LETTER, VALUE>>();
    }

    private DawgState<LETTER, VALUE> addLettersInFront(List<DawgLetter<LETTER>> partialWord, DawgState<LETTER, VALUE> state) {
        for (int i = partialWord.size() - 1; i >= 0; --i) {
            DawgLetter<LETTER> ltr = partialWord.get(i);
            assert (!ltr.isEmpty());
            state = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(state, ltr));
        }
        return state;
    }

    private DawgState<LETTER, VALUE> union(Set<DawgState<LETTER, VALUE>> states) {
        if (states.size() == 1) {
            return states.iterator().next();
        }
        DawgState<LETTER, VALUE> result = this.mUnionCache.get(states);
        if (result != null) {
            return result;
        }
        Map newSuccessors = new HashMap();
        Object sort = states.iterator().next().getTransitions().values().iterator().next().getSortId();
        newSuccessors.put(new HashSet(), this.mDawgFactory.getDawgLetterFactory().getUniversalDawgLetter(sort));
        for (DawgState<LETTER, VALUE> component : states) {
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : component.getTransitions().entrySet()) {
                newSuccessors = this.merge(newSuccessors, entry.getKey(), entry.getValue());
            }
        }
        HashMap newTrans = new HashMap();
        for (Map.Entry entry : newSuccessors.entrySet()) {
            if (((Set)entry.getKey()).isEmpty()) continue;
            DawgState<LETTER, VALUE> newDest = this.union((Set)entry.getKey());
            ReorderDawgBuilder.addLetterToMap(newTrans, newDest, (DawgLetter)entry.getValue());
        }
        result = this.mDawgStateFactory.createIntermediateState(newTrans);
        this.mUnionCache.put(states, result);
        return result;
    }

    private DawgState<LETTER, VALUE> internalReorder(List<DawgLetter<LETTER>> partialWord, int offset, int[] newPositionForColumns, DawgState<LETTER, VALUE> state, int level) {
        Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>> cacheKey = new Pair<List<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>(partialWord.subList(offset, partialWord.size()), state);
        DawgState<LETTER, VALUE> result = this.mCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        if (level == newPositionForColumns.length) {
            result = this.addLettersInFront(partialWord.subList(offset, partialWord.size()), state);
        } else {
            int newPosition = newPositionForColumns[level];
            assert (newPosition >= offset);
            assert (partialWord.get(newPosition) == null);
            int firstNull = offset;
            while (partialWord.get(firstNull) != null) {
                ++firstNull;
            }
            if (newPosition == firstNull) {
                HashMap newTransition = new HashMap();
                for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : state.getTransitions().entrySet()) {
                    DawgState<LETTER, VALUE> newDest = this.internalReorder(partialWord, newPosition + 1, newPositionForColumns, entry.getKey(), level + 1);
                    ReorderDawgBuilder.addLetterToMap(newTransition, newDest, entry.getValue());
                }
                result = this.mDawgStateFactory.createIntermediateState(newTransition);
                result = this.addLettersInFront(partialWord.subList(offset, newPosition), result);
            } else {
                HashSet<DawgState<LETTER, VALUE>> subsets = new HashSet<DawgState<LETTER, VALUE>>();
                for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : state.getTransitions().entrySet()) {
                    partialWord.set(newPosition, entry.getValue());
                    subsets.add(this.internalReorder(partialWord, offset, newPositionForColumns, entry.getKey(), level + 1));
                }
                partialWord.set(newPosition, null);
                result = this.union(subsets);
            }
        }
        cacheKey = new Pair<ArrayList<DawgLetter<LETTER>>, DawgState<LETTER, VALUE>>(new ArrayList<DawgLetter<LETTER>>(partialWord.subList(offset, partialWord.size())), state);
        this.mCache.put(cacheKey, result);
        return result;
    }

    public final DawgState<LETTER, VALUE> reorder(DawgState<LETTER, VALUE> input, List<DawgLetter<LETTER>> partialWord, int[] newPositions) {
        return this.internalReorder(new ArrayList<DawgLetter<LETTER>>(partialWord), 0, newPositions, input, 0);
    }
}

