/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetterFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DawgLetter<LETTER> {
    final DawgLetterFactory<LETTER> mDawgLetterFactory;
    DawgLetter<LETTER> mComplement;
    final Set<LETTER> mLetters;
    final Object mSortId;
    final boolean mIsComplemented;

    public DawgLetter(DawgLetterFactory<LETTER> dlf, Set<LETTER> letters, Object sortId) {
        this.mDawgLetterFactory = dlf;
        this.mLetters = letters;
        this.mSortId = sortId;
        this.mIsComplemented = false;
    }

    public DawgLetter(DawgLetter<LETTER> complement) {
        assert (!complement.mIsComplemented);
        this.mDawgLetterFactory = complement.mDawgLetterFactory;
        this.mLetters = complement.mLetters;
        this.mSortId = complement.mSortId;
        this.mIsComplemented = true;
        this.mComplement = complement;
        complement.mComplement = this;
    }

    public Object getSortId() {
        return this.mSortId;
    }

    public final DawgLetter<LETTER> difference(DawgLetter<LETTER> other) {
        return this.intersect(other.complement());
    }

    public DawgLetter<LETTER> complement() {
        if (this.mComplement == null) {
            this.mComplement = new DawgLetter<LETTER>(this);
        }
        return this.mComplement;
    }

    public DawgLetter<LETTER> intersect(DawgLetter<LETTER> other) {
        if (!this.mIsComplemented) {
            HashSet<LETTER> intersection = new HashSet<LETTER>();
            for (LETTER letter : this.mLetters) {
                if (!other.matches(letter)) continue;
                intersection.add(letter);
            }
            return this.mDawgLetterFactory.getSimpleDawgLetter(intersection, this.mSortId);
        }
        if (!other.mIsComplemented) {
            HashSet<LETTER> intersection = new HashSet<LETTER>();
            for (LETTER letter : other.mLetters) {
                if (!this.matches(letter)) continue;
                intersection.add(letter);
            }
            return this.mDawgLetterFactory.getSimpleDawgLetter(intersection, this.mSortId);
        }
        HashSet<LETTER> union = new HashSet<LETTER>();
        union.addAll(this.mLetters);
        union.addAll(other.mLetters);
        return this.mDawgLetterFactory.getSimpleComplementDawgLetter(union, this.mSortId);
    }

    public boolean matches(LETTER ltr) {
        return this.mLetters.contains(ltr) ^ this.mIsComplemented;
    }

    public Set<LETTER> getLetters() {
        if (this.mIsComplemented) {
            HashSet<LETTER> result = new HashSet<LETTER>(this.mDawgLetterFactory.getAllConstants(this.mSortId));
            result.removeAll(this.mLetters);
            return result;
        }
        return this.mLetters;
    }

    public DawgLetter<LETTER> restrictToLetter(LETTER selectLetter) {
        if (this.matches(selectLetter)) {
            return this.mDawgLetterFactory.getSimpleDawgLetter(Collections.singleton(selectLetter), this.mSortId);
        }
        return this.mDawgLetterFactory.getEmptyDawgLetter(this.mSortId);
    }

    public String toString() {
        return "DawgLetter: " + (this.mIsComplemented ? "not" : "") + this.mLetters;
    }

    public DawgLetter<LETTER> union(DawgLetter<LETTER> other) {
        return this.complement().intersect(other.complement()).complement();
    }

    public boolean isDisjoint(DawgLetter<LETTER> other) {
        if (!this.mIsComplemented) {
            for (LETTER letter : this.mLetters) {
                if (!other.matches(letter)) continue;
                return false;
            }
            return true;
        }
        if (!other.mIsComplemented) {
            for (LETTER letter : other.mLetters) {
                if (!this.matches(letter)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.mIsComplemented && this.mLetters.size() == 0;
    }

    public boolean isUniversal() {
        return this.mIsComplemented && this.mLetters.size() == 0;
    }

    public Collection<LETTER> getRawLetters() {
        return this.mLetters;
    }

    public boolean isComplemented() {
        return this.mIsComplemented;
    }

    public boolean isSingleton() {
        return !this.mIsComplemented && this.mLetters.size() == 1;
    }
}

