/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DawgState<LETTER, VALUE> {
    final VALUE mFinal;
    final Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> mTransitions;

    public DawgState(VALUE value) {
        this.mFinal = value;
        this.mTransitions = null;
    }

    public DawgState(Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> transitions) {
        this.mFinal = null;
        this.mTransitions = transitions;
    }

    public boolean isFinal() {
        return this.mTransitions == null;
    }

    public VALUE getFinalValue() {
        return this.mFinal;
    }

    public String toString() {
        if (this.isFinal()) {
            return "RET(" + this.mFinal + ")";
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<DawgState<LETTER, VALUE>> toPrint = new LinkedHashSet<DawgState<LETTER, VALUE>>();
        HashSet<DawgState> visited = new HashSet<DawgState>();
        toPrint.add(this);
        while (!toPrint.isEmpty()) {
            DawgState state = (DawgState)toPrint.iterator().next();
            toPrint.remove(state);
            if (!visited.add(state)) continue;
            sb.append(String.format("Dawg#%04d", state.hashCode() % 10000));
            String comma = "";
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : state.getTransitions().entrySet()) {
                sb.append(comma).append("->");
                if (entry.getKey().isFinal()) {
                    sb.append("(").append(entry.getKey().getFinalValue()).append(") ");
                } else {
                    sb.append(String.format("#%04d ", entry.getKey().hashCode() % 10000));
                    toPrint.add(entry.getKey());
                }
                sb.append(entry.getValue());
                sb.append("\n");
                comma = "         ";
            }
        }
        return sb.toString();
    }

    public Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> getTransitions() {
        return this.mTransitions;
    }

    public VALUE getValue(List<LETTER> word) {
        DawgState state = this;
        for (LETTER ltr : word) {
            DawgState<LETTER, VALUE> nextState = null;
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> trans : state.getTransitions().entrySet()) {
                if (!trans.getValue().matches(ltr)) continue;
                nextState = trans.getKey();
                break;
            }
            state = nextState;
        }
        assert (state.isFinal());
        return state.getFinalValue();
    }

    public boolean isTotal() {
        int depth = -1;
        boolean allTotal = true;
        HashSet<Pair> seen = new HashSet<Pair>();
        ArrayDeque<Pair<Integer, DawgState<LETTER, VALUE>>> todo = new ArrayDeque<Pair<Integer, DawgState<LETTER, VALUE>>>();
        todo.add(new Pair<Integer, DawgState>(0, this));
        while (!todo.isEmpty()) {
            Pair workItem = (Pair)todo.removeFirst();
            if (!seen.add(workItem)) continue;
            DawgState state = (DawgState)workItem.getSecond();
            if (state.isFinal()) {
                assert (depth == -1 || depth == (Integer)workItem.getFirst());
                depth = (Integer)workItem.getFirst();
                continue;
            }
            int newDepth = (Integer)workItem.getFirst() + 1;
            DawgLetter<LETTER> first = state.getTransitions().values().iterator().next();
            DawgLetter<LETTER> union = first.intersect(first.complement());
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : state.getTransitions().entrySet()) {
                todo.addLast(new Pair<Integer, DawgState<LETTER, VALUE>>(newDepth, entry.getKey()));
                assert (union.intersect(entry.getValue()).isEmpty());
                union = union.union(entry.getValue());
            }
            allTotal &= union.isUniversal();
        }
        return allTotal;
    }
}

