/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.BinaryMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class DawgStateFactory<LETTER> {
    final UnifyHash<DawgState<LETTER, ?>> mExistingStates = new UnifyHash();

    public <VALUE> DawgState<LETTER, VALUE> createFinalState(VALUE value) {
        int hash = value == null ? 0 : value.hashCode();
        for (DawgState<LETTER, ?> previous : this.mExistingStates.iterateHashCode(hash)) {
            if (!(previous.isFinal() && previous.getFinalValue() == null ? value == null : previous.getFinalValue().equals(value))) continue;
            return previous;
        }
        DawgState result = new DawgState(value);
        this.mExistingStates.put(hash, result);
        return result;
    }

    public <VALUE> DawgState<LETTER, VALUE> createIntermediateState(Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> transitions) {
        int hash = transitions.hashCode();
        for (DawgState<LETTER, ?> previous : this.mExistingStates.iterateHashCode(hash)) {
            if (!previous.mTransitions.equals(transitions)) continue;
            return previous;
        }
        if (transitions.size() == 0) {
            transitions = Collections.emptyMap();
        } else if (transitions.size() == 1) {
            Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<Object>> entry = transitions.entrySet().iterator().next();
            transitions = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else if (!(transitions instanceof BinaryMap) && !(transitions instanceof ArrayMap)) {
            if (transitions.size() == 2) {
                Iterator it = transitions.entrySet().iterator();
                Map.Entry entry1 = it.next();
                Map.Entry entry2 = it.next();
                transitions = new BinaryMap(entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
            } else {
                Map.Entry[] entries = transitions.entrySet().toArray(new Map.Entry[transitions.size()]);
                DawgState[] keys = new DawgState[entries.length];
                DawgLetter[] values = new DawgLetter[entries.length];
                for (int i = 0; i < entries.length; ++i) {
                    keys[i] = (DawgState)entries[i].getKey();
                    values[i] = (DawgLetter)entries[i].getValue();
                }
                transitions = new ArrayMap<DawgState, DawgLetter>(keys, values);
            }
        }
        DawgState result = new DawgState(transitions);
        this.mExistingStates.put(hash, result);
        return result;
    }
}

