/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.EprDecideStack;
import java.util.ArrayList;
import java.util.function.BiFunction;

public class DecideStackGroundLiteral
extends DecideStackEntry {
    private final Literal mLiteral;
    private boolean isEffective;

    public DecideStackGroundLiteral(Literal l) {
        this.mLiteral = l;
    }

    public String toString() {
        return "(literal: " + this.mLiteral + ")";
    }

    public Literal getLiteral() {
        return this.mLiteral;
    }

    @Override
    public EprPredicate getEprPredicate() {
        if (this.mLiteral.getAtom() instanceof EprGroundPredicateAtom) {
            EprGroundPredicateAtom eprAtom = (EprGroundPredicateAtom)this.mLiteral.getAtom();
            return eprAtom.getEprPredicate();
        }
        return null;
    }

    @Override
    public DawgState<ApplicationTerm, EprTheory.TriBool> getDawg() {
        if (this.mLiteral.getAtom() instanceof EprGroundPredicateAtom) {
            EprGroundPredicateAtom eprAtom = (EprGroundPredicateAtom)this.mLiteral.getAtom();
            EprPredicate eprPred = eprAtom.mEprPredicate;
            ArrayList<ApplicationTerm> word = new ArrayList<ApplicationTerm>();
            for (Term param : eprAtom.getArguments()) {
                word.add((ApplicationTerm)param);
            }
            DawgFactory<ApplicationTerm, TermVariable> factory = eprPred.getEprTheory().getDawgFactory();
            return factory.createMapped(factory.createSingletonSet(eprPred.getSignature(), word), b -> b.booleanValue() ? (this.mLiteral == eprAtom ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE) : EprTheory.TriBool.UNKNOWN);
        }
        return null;
    }

    @Override
    public void push(EprDecideStack stack) {
        if (this.mLiteral.getAtom() instanceof EprGroundPredicateAtom) {
            EprGroundPredicateAtom eprAtom = (EprGroundPredicateAtom)this.mLiteral.getAtom();
            DawgState<ApplicationTerm, EprTheory.TriBool> dawg = eprAtom.mEprPredicate.getDawg();
            ArrayList<ApplicationTerm> word = new ArrayList<ApplicationTerm>();
            for (Term param : eprAtom.getArguments()) {
                word.add((ApplicationTerm)param);
            }
            if (dawg.getValue(word) == EprTheory.TriBool.UNKNOWN) {
                BiFunction<EprTheory.TriBool, Boolean, EprTheory.TriBool> combinator = (old, setLit) -> {
                    assert (!setLit.booleanValue() || old == EprTheory.TriBool.UNKNOWN);
                    return setLit.booleanValue() ? (this.mLiteral == eprAtom ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE) : old;
                };
                this.isEffective = true;
                DawgFactory<ApplicationTerm, TermVariable> factory = eprAtom.mEprPredicate.getEprTheory().getDawgFactory();
                eprAtom.mEprPredicate.setDawg(factory.createProduct(dawg, factory.createSingletonSet(eprAtom.mEprPredicate.getSignature(), word), combinator));
            }
        }
    }

    @Override
    public void pop(EprDecideStack stack) {
        if (this.isEffective) {
            EprGroundPredicateAtom eprAtom = (EprGroundPredicateAtom)this.mLiteral.getAtom();
            DawgState<ApplicationTerm, EprTheory.TriBool> dawg = eprAtom.mEprPredicate.getDawg();
            ArrayList<ApplicationTerm> word = new ArrayList<ApplicationTerm>();
            for (Term param : eprAtom.getArguments()) {
                word.add((ApplicationTerm)param);
            }
            BiFunction<EprTheory.TriBool, Boolean, EprTheory.TriBool> combinator = (old, setLit) -> setLit != false ? EprTheory.TriBool.UNKNOWN : old;
            this.isEffective = false;
            DawgFactory<ApplicationTerm, TermVariable> factory = eprAtom.mEprPredicate.getEprTheory().getDawgFactory();
            eprAtom.mEprPredicate.setDawg(factory.createProduct(dawg, factory.createSingletonSet(eprAtom.mEprPredicate.getSignature(), word), combinator));
        }
    }
}

