/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseDpllLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.UnitPropagationData;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackDecisionLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackPropagatedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.GroundPropagationInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EprDecideStack {
    private final EprTheory mEprTheory;
    private final ArrayList<DecideStackEntry> mStack = new ArrayList();
    private final ScopedArrayList<EprClause> mClauses = new ScopedArrayList();
    private final ScopedHashSet<EprPredicate> mAllEprPredicates = new ScopedHashSet();
    private final ScopedArrayList<EprEqualityPredicate> mEprEqualities = new ScopedArrayList();

    public EprDecideStack(EprTheory theory) {
        this.mEprTheory = theory;
    }

    public void pushEntry(DecideStackEntry entry) {
        this.mStack.add(entry);
        entry.push(this);
    }

    public int findLiteralOnStack(Literal lit) {
        int stackTop = this.mStack.size();
        while (stackTop > 0) {
            DecideStackEntry entry;
            if (!((entry = this.mStack.get(--stackTop)) instanceof DecideStackGroundLiteral) || ((DecideStackGroundLiteral)entry).getLiteral() != lit) continue;
            return stackTop;
        }
        return this.mStack.size();
    }

    public void backtrackToLiteral(Literal lit) {
        int position = this.findLiteralOnStack(lit);
        for (int i = this.mStack.size() - 1; i >= position; --i) {
            this.mStack.remove(i).pop(this);
        }
    }

    void explainConflict(Map<EprPredicate, HashSet<DawgState<ApplicationTerm, EprTheory.TriBool>>> conflict, List<Literal> groundClause) {
    }

    void resolveConflictOrUnit(EprClause clause, ClauseLiteral unitLiteral, DawgState<ApplicationTerm, Boolean> conflicts, Set<Literal> groundLits, Map<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprLits) {
        List<DawgLetter<ApplicationTerm>> word = DawgFactory.getOneWord(conflicts);
        ApplicationTerm[] grounding = new ApplicationTerm[word.size()];
        for (int i = 0; i < word.size(); ++i) {
            grounding[i] = word.get(i).isComplemented() ? null : word.get(i).getLetters().iterator().next();
        }
        for (ClauseLiteral lit : clause.getLiterals()) {
            if (lit instanceof ClauseDpllLiteral) {
                groundLits.add(((ClauseDpllLiteral)lit).getLiteral());
                continue;
            }
            if (lit == unitLiteral) continue;
            ClauseEprLiteral eprLit = (ClauseEprLiteral)lit;
            ApplicationTerm[] instantiation = eprLit.getInstantiatedArguments(grounding);
            Pair<EprPredicate, Boolean> key = new Pair<EprPredicate, Boolean>(eprLit.getEprPredicate(), eprLit.getPolarity());
            Set<List<ApplicationTerm>> prevWords = eprLits.get(key);
            if (prevWords == null) {
                prevWords = new HashSet<List<ApplicationTerm>>();
                eprLits.put(key, prevWords);
            }
            prevWords.add(Arrays.asList(instantiation));
        }
    }

    Clause explain(Set<Literal> groundClause, Map<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprClause, int stackPosition) {
        while (!eprClause.isEmpty()) {
            Pair<EprPredicate, Boolean> key;
            Set<List<ApplicationTerm>> toExplainForLit;
            DecideStackEntry entry;
            if ((entry = this.mStack.get(--stackPosition)) instanceof DecideStackGroundLiteral) {
                EprGroundPredicateAtom setAtom;
                EprPredicate setPred;
                Literal setLiteral = ((DecideStackGroundLiteral)entry).getLiteral();
                if (!(setLiteral.getAtom() instanceof EprGroundPredicateAtom) || (toExplainForLit = eprClause.get(key = new Pair<EprPredicate, Boolean>(setPred = (setAtom = (EprGroundPredicateAtom)setLiteral.getAtom()).getEprPredicate(), setAtom != setLiteral))) == null || !toExplainForLit.remove(setAtom.getArgumentsAsWord())) continue;
                groundClause.add(setLiteral.negate());
                if (!toExplainForLit.isEmpty()) continue;
                eprClause.remove(key);
                continue;
            }
            if (entry instanceof DecideStackPropagatedLiteral) {
                DecideStackPropagatedLiteral dsl = (DecideStackPropagatedLiteral)entry;
                DawgState<ApplicationTerm, EprTheory.TriBool> oldDawg = dsl.getOldDawg();
                ClauseEprLiteral propReason = dsl.getReasonClauseLit();
                key = new Pair<EprPredicate, Boolean>(propReason.getEprPredicate(), !propReason.getPolarity());
                toExplainForLit = eprClause.remove(key);
                if (toExplainForLit == null) continue;
                Iterator<List<ApplicationTerm>> it = toExplainForLit.iterator();
                while (it.hasNext()) {
                    List<ApplicationTerm> word = it.next();
                    if (oldDawg.getValue(word) != EprTheory.TriBool.UNKNOWN) continue;
                    assert (dsl.getDawg().getValue(word) == (propReason.getPolarity() ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE));
                    it.remove();
                    DawgState<ApplicationTerm, Boolean> litDawg = this.mEprTheory.getDawgFactory().createSingletonSet(propReason.getEprPredicate().getTermVariablesForArguments(), word);
                    DawgState<ApplicationTerm, Boolean> clauseDawg = propReason.litDawg2clauseDawg(litDawg);
                    clauseDawg = this.mEprTheory.getDawgFactory().createIntersection(dsl.getClauseDawg(), clauseDawg);
                    this.resolveConflictOrUnit(propReason.getClause(), propReason, clauseDawg, groundClause, eprClause);
                }
                Set<List<ApplicationTerm>> insertedLits = eprClause.get(key);
                if (insertedLits != null) {
                    insertedLits.addAll(toExplainForLit);
                    continue;
                }
                if (toExplainForLit.isEmpty()) continue;
                eprClause.put(key, toExplainForLit);
                continue;
            }
            throw new AssertionError();
        }
        return new Clause(groundClause.toArray(new Literal[groundClause.size()]));
    }

    Clause explainUnitLiteralOrConflict(EprClause clause, ClauseEprLiteral unitLiteral, DawgState<ApplicationTerm, Boolean> point) {
        HashSet<Literal> groundClause = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprClause = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        this.resolveConflictOrUnit(clause, unitLiteral, point, groundClause, eprClause);
        return this.explain(groundClause, eprClause, this.mStack.size());
    }

    Clause explainIrreflexivity(EprEqualityPredicate equality, DawgState<ApplicationTerm, Boolean> point) {
        HashSet<Literal> groundClause = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprClause = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        List<DawgLetter<ApplicationTerm>> word = DawgFactory.getOneWord(point);
        ApplicationTerm[] grounding = new ApplicationTerm[word.size()];
        for (int i = 0; i < word.size(); ++i) {
            grounding[i] = word.get(i).isComplemented() ? null : word.get(i).getLetters().iterator().next();
        }
        HashSet<List<ApplicationTerm>> conflictSet = new HashSet<List<ApplicationTerm>>();
        conflictSet.add(Arrays.asList(grounding));
        eprClause.put(new Pair<EprEqualityPredicate, Boolean>(equality, Boolean.TRUE), conflictSet);
        return this.explain(groundClause, eprClause, this.mStack.size());
    }

    public Clause explainGroundUnit(Literal unit) {
        EprGroundPredicateAtom atom = (EprGroundPredicateAtom)unit.getAtom();
        HashSet<Literal> groundClause = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprClause = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        groundClause.add(unit);
        HashSet<List<ApplicationTerm>> wordSet = new HashSet<List<ApplicationTerm>>();
        wordSet.add(atom.getArgumentsAsWord());
        eprClause.put(new Pair<EprPredicate, Boolean>(atom.getEprPredicate(), unit != atom), wordSet);
        return this.explain(groundClause, eprClause, this.findLiteralOnStack(unit));
    }

    public Clause explainGroundUnit(Literal unit, GroundPropagationInfo reason) {
        if (reason == null) {
            return this.explainGroundUnit(unit);
        }
        HashSet<Literal> groundClause = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> eprClause = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        ClauseDpllLiteral unitLiteral = reason.getReasonClauseLit();
        this.resolveConflictOrUnit(unitLiteral.getClause(), unitLiteral, reason.getClauseDawg(), groundClause, eprClause);
        return this.explain(groundClause, eprClause, reason.getStackDepth());
    }

    public Clause setGroundEquality(CCEquality atom, boolean b) {
        return null;
    }

    public Clause setEprGroundLiteral(Literal literal) {
        EprGroundPredicateAtom atom = (EprGroundPredicateAtom)literal.getAtom();
        EprPredicate pred = atom.getEprPredicate();
        if (pred.getDawg().getValue(atom.getArgumentsAsWord()) == (literal == atom ? EprTheory.TriBool.FALSE : EprTheory.TriBool.TRUE)) {
            return this.explainGroundUnit(literal.negate());
        }
        DecideStackGroundLiteral dsgl = new DecideStackGroundLiteral(literal);
        this.pushEntry(dsgl);
        return null;
    }

    public Clause doPropagations() {
        boolean changed = true;
        boolean didSomeGroundPropagations = false;
        while (changed) {
            DawgState<ApplicationTerm, Boolean> conflicts;
            changed = false;
            for (EprEqualityPredicate equality : this.mEprEqualities) {
                conflicts = equality.getIrreflexivity();
                if (DawgFactory.isEmpty(conflicts)) continue;
                return this.explainIrreflexivity(equality, conflicts);
            }
            for (EprClause eprClause : this.mClauses) {
                if (eprClause.isConflict()) {
                    conflicts = eprClause.getConflictPoints();
                    return this.explainUnitLiteralOrConflict(eprClause, null, conflicts);
                }
                if (!eprClause.isUnit()) continue;
                UnitPropagationData upd = eprClause.getUnitPropagationData();
                for (DecideStackEntry dse : upd.getQuantifiedPropagations()) {
                    this.mEprTheory.getLogger().debug("EPR Propagating: %s", dse);
                    this.pushEntry(dse);
                    changed = true;
                }
                for (GroundPropagationInfo reason : upd.getGroundPropagations()) {
                    reason.setStackDepth(this.mStack.size());
                    this.mEprTheory.addGroundLiteralToPropagate(reason.getReasonClauseLit().getLiteral(), reason);
                    didSomeGroundPropagations = true;
                }
            }
            if (!didSomeGroundPropagations) continue;
            return null;
        }
        for (EprPredicate pred : this.mAllEprPredicates) {
            for (EprGroundPredicateAtom ground : pred.getDPLLAtoms()) {
                if (ground.getDecideStatus() != null || pred.getDawg().getValue(ground.getArgumentsAsWord()) == EprTheory.TriBool.UNKNOWN) continue;
                Literal lit = pred.getDawg().getValue(ground.getArgumentsAsWord()) == EprTheory.TriBool.TRUE ? ground : ground.negate();
                this.mEprTheory.addGroundLiteralToPropagate(lit, null);
            }
        }
        return null;
    }

    private DecideStackDecisionLiteral decide() {
        for (EprClause eprClause : this.mClauses) {
            DawgState<ApplicationTerm, Boolean> undecidedDawg = eprClause.getUndecidedPoints();
            if (DawgFactory.isEmpty(undecidedDawg)) continue;
            for (ClauseLiteral cl : eprClause.getLiterals()) {
                DawgState<ApplicationTerm, Boolean> cldawg;
                if (cl instanceof ClauseDpllLiteral) {
                    assert (cl.getLiteral().getAtom().getDecideStatus() == cl.getLiteral().negate());
                    continue;
                }
                ClauseEprLiteral cel = (ClauseEprLiteral)cl;
                if (cel.getEprPredicate() instanceof EprEqualityPredicate && !cel.getPolarity() || DawgFactory.isEmpty(cldawg = this.mEprTheory.getDawgFactory().createProduct(undecidedDawg, cel.getDawg(), (u, c) -> u != false && c == EprTheory.TriBool.UNKNOWN))) continue;
                DawgState<ApplicationTerm, Boolean> litDawg = cel.clauseDawg2litDawg(cldawg);
                EprTheory.TriBool status = cel.getPolarity() ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE;
                DawgState<ApplicationTerm, EprTheory.TriBool> mappedDawg = this.mEprTheory.getDawgFactory().createMapped(litDawg, b -> b != false ? status : EprTheory.TriBool.UNKNOWN);
                return new DecideStackDecisionLiteral(cel.getEprPredicate(), mappedDawg);
            }
        }
        return null;
    }

    public Clause eprDpllLoop() {
        DecideStackDecisionLiteral ddl;
        while ((ddl = this.decide()) != null) {
            this.pushEntry(ddl);
            this.doPropagations();
        }
        return null;
    }

    public Clause createEprClause(Set<Literal> clauseLiterals) {
        EprClause newClause = this.mEprTheory.getEprClauseFactory().getEprClause(clauseLiterals);
        this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClauseManager) creating new EprClause: " + newClause);
        this.mClauses.add(newClause);
        return null;
    }

    public void addNewEprPredicate(EprPredicate pred) {
        if (pred instanceof EprEqualityPredicate) {
            this.mEprEqualities.add((EprEqualityPredicate)pred);
        }
        this.mAllEprPredicates.add(pred);
    }

    public void push() {
        this.mClauses.beginScope();
        this.mAllEprPredicates.beginScope();
        this.mEprEqualities.beginScope();
    }

    public void pop() {
        this.mClauses.endScope();
        this.mAllEprPredicates.endScope();
        this.mEprEqualities.endScope();
    }
}

