/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AnnotationToProofTerm {
    private static final Annotation TRICHOTOMY = new Annotation(":trichotomy", null);

    private Rational computeGcd(LAAnnotation annot) {
        Rational gcd = null;
        Iterator<Rational> it = annot.getCoefficients().values().iterator();
        if (it.hasNext()) {
            gcd = it.next();
        }
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next());
        }
        it = annot.getAuxAnnotations().values().iterator();
        if (gcd == null && it.hasNext()) {
            gcd = it.next();
        }
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next());
        }
        assert (gcd != null);
        return gcd;
    }

    private void computeLiterals(LAAnnotation annot, Theory theory, AnnotationInfo info) {
        MutableAffineTerm at = new MutableAffineTerm();
        at.add(Rational.ONE, annot.getLinVar());
        at.add(annot.getBound().negate());
        if (!annot.isUpper()) {
            at.add(annot.getLinVar().getEpsilon());
        }
        Term posTerm = at.toSMTLibLeq0(theory);
        info.mLiteral = new ProofLiteral(posTerm, annot.isUpper());
    }

    public Term convert(LAAnnotation parent, ProofRules proofRules) {
        assert (parent.getLinVar() == null);
        Theory theory = proofRules.getTheory();
        HashMap<LAAnnotation, AnnotationInfo> infos = new HashMap<LAAnnotation, AnnotationInfo>();
        ArrayDeque<LAAnnotation> todo = new ArrayDeque<LAAnnotation>();
        todo.add(parent);
        while (!todo.isEmpty()) {
            LAAnnotation annot = (LAAnnotation)todo.removeFirst();
            AnnotationInfo info = (AnnotationInfo)infos.get(annot);
            if (info == null) {
                info = new AnnotationInfo();
                infos.put(annot, info);
                if (annot.getLinVar() != null) {
                    this.computeLiterals(annot, theory, info);
                }
                todo.addAll(annot.getAuxAnnotations().keySet());
            }
            ++info.mCount;
        }
        Term proof = null;
        todo.add(parent);
        while (!todo.isEmpty()) {
            LAAnnotation annot = (LAAnnotation)todo.removeFirst();
            AnnotationInfo info = (AnnotationInfo)infos.get(annot);
            ++info.mVisited;
            if (info.mVisited < info.mCount) continue;
            todo.addAll(annot.getAuxAnnotations().keySet());
            Rational gcd = this.computeGcd(annot);
            int numdisjs = annot.getCoefficients().size() + annot.getAuxAnnotations().size() + (info.mLiteral == null ? 0 : 1);
            int i = 0;
            ProofLiteral[] proofLits = new ProofLiteral[numdisjs];
            Term[] coeffs = new Term[numdisjs];
            if (info.mLiteral != null) {
                Rational sign = annot.isUpper() ? Rational.MONE : Rational.ONE;
                proofLits[i] = info.mLiteral;
                coeffs[i] = sign.div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            boolean trichotomy = false;
            for (Map.Entry<Literal, Rational> entry : annot.getCoefficients().entrySet()) {
                Literal lit = entry.getKey();
                if (lit instanceof LAEquality) {
                    trichotomy = true;
                }
                proofLits[i] = new ProofLiteral(lit.getAtom().getSMTFormula(theory), lit == lit.getAtom());
                coeffs[i] = entry.getValue().div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            for (Map.Entry<Object, Rational> entry : annot.getAuxAnnotations().entrySet()) {
                AnnotationInfo auxInfo = (AnnotationInfo)infos.get(entry.getKey());
                proofLits[i] = auxInfo.mLiteral.negate();
                coeffs[i] = entry.getValue().div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            if (proofLits.length == 2 && proofLits[0].equals(proofLits[1].negate())) continue;
            Annotation[] annots = new Annotation[]{trichotomy ? TRICHOTOMY : new Annotation(":LA", coeffs)};
            Term term = proofRules.oracle(proofLits, annots);
            if (proof == null) {
                proof = term;
                continue;
            }
            proof = proofRules.resolutionRule(info.mLiteral.getAtom(), info.mLiteral.getPolarity() ? term : proof, info.mLiteral.getPolarity() ? proof : term);
        }
        return proof;
    }

    private Sort getSort(Theory t) {
        Sort res = t.getSort("Int", new Sort[0]);
        return res == null ? t.getSort("Real", new Sort[0]) : res;
    }

    class AnnotationInfo {
        int mCount;
        int mVisited;
        ProofLiteral mLiteral;

        AnnotationInfo() {
        }
    }
}

