/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class BoundConstraint
extends DPLLAtom {
    final InfinitesimalNumber mBound;
    final InfinitesimalNumber mIBound;
    final LinVar mVar;

    public BoundConstraint(InfinitesimalNumber bound, LinVar var, int assertionstacklevel) {
        super(HashUtils.hashJenkins(var.hashCode(), (Object)bound), assertionstacklevel);
        assert (bound.mEps <= 0);
        assert (!var.mIsInt || bound.isIntegral());
        this.mBound = bound;
        this.mIBound = bound.add(var.getEpsilon());
        assert (!this.mBound.equals(this.mIBound));
        this.mVar = var;
        assert (!this.mVar.mConstraints.containsKey(bound));
        this.mVar.mConstraints.put(bound, this);
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public InfinitesimalNumber getBound() {
        return this.mBound;
    }

    public InfinitesimalNumber getInverseBound() {
        return this.mIBound;
    }

    @Override
    public String toStringNegated() {
        InfinitesimalNumber ibound = this.getInverseBound();
        if (ibound.mEps > 0) {
            return "[" + this.hashCode() + "]" + this.mVar + " > " + ibound.mReal;
        }
        return "[" + this.hashCode() + "]" + this.mVar + " >= " + ibound;
    }

    @Override
    public String toString() {
        if (this.mBound.mEps < 0) {
            return "[" + this.hashCode() + "]" + this.mVar + " < " + this.mBound.mReal;
        }
        return "[" + this.hashCode() + "]" + this.mVar + " <= " + this.mBound;
    }

    boolean impliedByUpperBound(InfinitesimalNumber ubound) {
        return ubound.lesseq(this.mBound);
    }

    boolean impliedByLowerBound(InfinitesimalNumber lbound) {
        return this.getInverseBound().lesseq(lbound);
    }

    @Override
    public Term getSMTFormula(Theory smtTheory) {
        MutableAffineTerm at = new MutableAffineTerm();
        at.add(Rational.ONE, this.mVar);
        at.add(this.mBound.negate());
        return at.toSMTLibLeq0(smtTheory);
    }

    public boolean equals(Object other) {
        if (other instanceof BoundConstraint) {
            BoundConstraint o = (BoundConstraint)other;
            return o.mVar == this.mVar && o.mBound.equals(this.mBound);
        }
        return false;
    }
}

