/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;

public class ExactInfinitesimalNumber
implements Comparable<ExactInfinitesimalNumber> {
    public static final ExactInfinitesimalNumber ZERO = new ExactInfinitesimalNumber(Rational.ZERO, Rational.ZERO);
    public static final ExactInfinitesimalNumber POSITIVE_INFINITY = new ExactInfinitesimalNumber(Rational.POSITIVE_INFINITY, Rational.ZERO);
    public static final ExactInfinitesimalNumber NEGATIVE_INFINITY = new ExactInfinitesimalNumber(Rational.NEGATIVE_INFINITY, Rational.ZERO);
    private final Rational mReal;
    private final Rational mEps;

    public ExactInfinitesimalNumber(Rational real) {
        this.mReal = real;
        this.mEps = Rational.ZERO;
    }

    public ExactInfinitesimalNumber(Rational real, Rational eps) {
        this.mReal = real;
        this.mEps = eps;
    }

    public ExactInfinitesimalNumber(InfinitesimalNumber approx) {
        this.mReal = approx.mReal;
        this.mEps = Rational.valueOf(approx.mEps, 1L);
    }

    public Rational getRealValue() {
        return this.mReal;
    }

    public Rational getEpsilon() {
        return this.mEps;
    }

    public String toString() {
        if (this.mEps.signum() == 0) {
            return this.mReal.toString();
        }
        if (this.mEps.signum() > 0) {
            return this.mReal.toString() + "+" + this.mEps.toString() + "eps";
        }
        return this.mReal.toString() + "-" + this.mEps.abs().toString() + "eps";
    }

    public boolean equals(Object o) {
        if (o instanceof InfinitesimalNumber) {
            InfinitesimalNumber n = (InfinitesimalNumber)o;
            return this.mReal.equals(n.mReal) && this.mEps.equals(Rational.valueOf(n.mEps, 1L));
        }
        if (o instanceof ExactInfinitesimalNumber) {
            ExactInfinitesimalNumber n = (ExactInfinitesimalNumber)o;
            return this.mReal.equals(n.mReal) && this.mEps.equals(n.mEps);
        }
        return false;
    }

    public int hashCode() {
        return this.mReal.hashCode() + 65537 * this.mEps.hashCode();
    }

    public ExactInfinitesimalNumber add(Rational real) {
        return new ExactInfinitesimalNumber(this.mReal.add(real), this.mEps);
    }

    public ExactInfinitesimalNumber add(InfinitesimalNumber other) {
        return new ExactInfinitesimalNumber(this.mReal.add(other.mReal), this.mEps.add(Rational.valueOf(other.mEps, 1L)));
    }

    public ExactInfinitesimalNumber add(ExactInfinitesimalNumber other) {
        return new ExactInfinitesimalNumber(this.mReal.add(other.mReal), this.mEps.add(other.mEps));
    }

    public ExactInfinitesimalNumber sub(ExactInfinitesimalNumber other) {
        return new ExactInfinitesimalNumber(this.mReal.sub(other.mReal), this.mEps.sub(other.mEps));
    }

    public ExactInfinitesimalNumber isub(InfinitesimalNumber first) {
        return new ExactInfinitesimalNumber(first.mReal.sub(this.mReal), Rational.valueOf(first.mEps, 1L).sub(this.mEps));
    }

    public ExactInfinitesimalNumber negate() {
        return new ExactInfinitesimalNumber(this.mReal.negate(), this.mEps.negate());
    }

    public ExactInfinitesimalNumber mul(Rational c) {
        return new ExactInfinitesimalNumber(this.mReal.mul(c), this.mEps.mul(c));
    }

    public ExactInfinitesimalNumber div(Rational d) {
        return new ExactInfinitesimalNumber(this.mReal.div(d), this.mEps.div(d));
    }

    public ExactInfinitesimalNumber abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public InfinitesimalNumber roundToInfinitesimal() {
        return new InfinitesimalNumber(this.mReal, this.mEps.signum());
    }

    @Override
    public int compareTo(InfinitesimalNumber other) {
        int cmp = this.mReal.compareTo(other.mReal);
        return cmp == 0 ? this.mEps.compareTo(Rational.valueOf(other.mEps, 1L)) : cmp;
    }

    @Override
    public int compareTo(ExactInfinitesimalNumber other) {
        int cmp = this.mReal.compareTo(other.mReal);
        return cmp == 0 ? this.mEps.compareTo(other.mEps) : cmp;
    }

    public int signum() {
        return this.mReal == Rational.ZERO ? this.mEps.signum() : this.mReal.signum();
    }
}

