/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;

public class InfinitesimalNumber
implements Comparable<InfinitesimalNumber> {
    public final Rational mReal;
    public final int mEps;
    public static final InfinitesimalNumber POSITIVE_INFINITY = new InfinitesimalNumber(Rational.POSITIVE_INFINITY, 0);
    public static final InfinitesimalNumber NEGATIVE_INFINITY = new InfinitesimalNumber(Rational.NEGATIVE_INFINITY, 0);
    public static final InfinitesimalNumber ZERO = new InfinitesimalNumber(Rational.ZERO, 0);
    public static final InfinitesimalNumber ONE = new InfinitesimalNumber(Rational.ONE, 0);
    public static final InfinitesimalNumber EPSILON = new InfinitesimalNumber(Rational.ZERO, 1);

    public InfinitesimalNumber() {
        this(Rational.ZERO, 0);
    }

    public InfinitesimalNumber(Rational a, int eps) {
        this.mReal = a;
        this.mEps = eps;
    }

    static int normEpsilon(int eps) {
        return Integer.signum(eps);
    }

    public InfinitesimalNumber add(InfinitesimalNumber other) {
        return new InfinitesimalNumber(this.mReal.add(other.mReal), InfinitesimalNumber.normEpsilon(this.mEps + other.mEps));
    }

    public InfinitesimalNumber sub(InfinitesimalNumber other) {
        return new InfinitesimalNumber(this.mReal.sub(other.mReal), InfinitesimalNumber.normEpsilon(this.mEps - other.mEps));
    }

    public ExactInfinitesimalNumber sub(ExactInfinitesimalNumber other) {
        return new ExactInfinitesimalNumber(this.mReal.sub(other.getRealValue()), Rational.valueOf(this.mEps, 1L).sub(other.getEpsilon()));
    }

    public InfinitesimalNumber mul(Rational c) {
        return new InfinitesimalNumber(this.mReal.mul(c), this.mEps * c.signum());
    }

    public InfinitesimalNumber div(Rational c) {
        return new InfinitesimalNumber(this.mReal.div(c), this.mEps * c.signum());
    }

    public InfinitesimalNumber abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public InfinitesimalNumber negate() {
        return new InfinitesimalNumber(this.mReal.negate(), -this.mEps);
    }

    public InfinitesimalNumber addmul(InfinitesimalNumber fac1, Rational fac2) {
        return new InfinitesimalNumber(this.mReal.addmul(fac1.mReal, fac2), InfinitesimalNumber.normEpsilon(this.mEps + fac1.mEps * fac2.signum()));
    }

    public InfinitesimalNumber subdiv(InfinitesimalNumber s, Rational d) {
        return new InfinitesimalNumber(this.mReal.subdiv(s.mReal, d), InfinitesimalNumber.normEpsilon(this.mEps - s.mEps) * d.signum());
    }

    @Override
    public int compareTo(InfinitesimalNumber arg0) {
        int ac = this.mReal.compareTo(arg0.mReal);
        if (ac == 0) {
            return this.mEps - arg0.mEps;
        }
        return ac;
    }

    public boolean equals(Object o) {
        if (o instanceof InfinitesimalNumber) {
            InfinitesimalNumber n = (InfinitesimalNumber)o;
            return this.mReal.equals(n.mReal) && this.mEps == n.mEps;
        }
        return false;
    }

    public int hashCode() {
        return this.mReal.hashCode() + 65537 * this.mEps;
    }

    public boolean less(InfinitesimalNumber other) {
        int ac = this.mReal.compareTo(other.mReal);
        return ac < 0 || ac == 0 && this.mEps < other.mEps;
    }

    public boolean lesseq(InfinitesimalNumber other) {
        int ac = this.mReal.compareTo(other.mReal);
        return ac < 0 || ac == 0 && this.mEps <= other.mEps;
    }

    public boolean isInfinity() {
        return this.mReal == Rational.POSITIVE_INFINITY || this.mReal == Rational.NEGATIVE_INFINITY;
    }

    public String toString() {
        if (this.mEps == 0) {
            return this.mReal.toString();
        }
        return this.mReal + (this.mEps > 0 ? "+" : "-") + "eps";
    }

    public boolean isIntegral() {
        return this.mReal.isIntegral() && this.mEps == 0;
    }

    public InfinitesimalNumber floor() {
        if (!this.mReal.isIntegral()) {
            return new InfinitesimalNumber(this.mReal.floor(), 0);
        }
        if (this.mEps >= 0) {
            return new InfinitesimalNumber(this.mReal, 0);
        }
        return new InfinitesimalNumber(this.mReal.sub(Rational.ONE), 0);
    }

    public InfinitesimalNumber ceil() {
        if (!this.mReal.isIntegral()) {
            return new InfinitesimalNumber(this.mReal.ceil(), 0);
        }
        if (this.mEps <= 0) {
            return new InfinitesimalNumber(this.mReal, 0);
        }
        return new InfinitesimalNumber(this.mReal.add(Rational.ONE), 0);
    }

    public int signum() {
        return this.mReal == Rational.ZERO ? this.mEps : this.mReal.signum();
    }

    public InfinitesimalNumber inverse() {
        return new InfinitesimalNumber(this.mReal.inverse(), -this.mEps);
    }
}

