/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayList;

public class LAEquality
extends DPLLAtom {
    private final LinVar mVar;
    private final Rational mBound;
    private final ArrayList<CCEquality> mDependentEqualities;

    public LAEquality(int stackLevel, LinVar var, Rational bound) {
        super(HashUtils.hashJenkins(~var.hashCode(), (Object)bound), stackLevel);
        this.mVar = var;
        this.mBound = bound;
        this.mDependentEqualities = new ArrayList();
    }

    public Rational getBound() {
        return this.mBound;
    }

    public LinVar getVar() {
        return this.mVar;
    }

    @Override
    public String toStringNegated() {
        return "[" + this.hashCode() + "]" + this.mVar + " != " + this.mBound;
    }

    @Override
    public String toString() {
        return "[" + this.hashCode() + "]" + this.mVar + " == " + this.mBound;
    }

    @Override
    public Term getSMTFormula(Theory smtTheory) {
        MutableAffineTerm at = new MutableAffineTerm();
        at.add(Rational.ONE, this.mVar);
        at.add(this.mBound.negate());
        boolean isInt = this.mVar.mIsInt && this.mBound.isIntegral();
        Sort s = smtTheory.getSort(isInt ? "Int" : "Real", new Sort[0]);
        Sort[] binfunc = new Sort[]{s, s};
        FunctionSymbol comp = smtTheory.getFunction("=", binfunc);
        return smtTheory.term(comp, at.toSMTLib(smtTheory, isInt), Rational.ZERO.toTerm(s));
    }

    public void addDependentAtom(CCEquality eq) {
        this.mDependentEqualities.add(eq);
    }

    public void removeDependentAtom(CCEquality eq) {
        this.mDependentEqualities.remove(eq);
    }

    public Iterable<CCEquality> getDependentEqualities() {
        return this.mDependentEqualities;
    }

    public boolean equals(Object other) {
        if (other instanceof LAEquality) {
            LAEquality o = (LAEquality)other;
            return o.mVar == this.mVar && o.mBound.equals(this.mBound);
        }
        return false;
    }
}

