/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public abstract class LAReason {
    private final LinVar mVar;
    protected InfinitesimalNumber mBound;
    private LAReason mOldReason;
    private final boolean mIsUpper;
    private final LiteralReason mLastlit;

    public LAReason(LinVar var, InfinitesimalNumber bound, boolean isUpper, LiteralReason lastLit) {
        this.mVar = var;
        this.mBound = bound;
        this.mIsUpper = isUpper;
        this.mLastlit = lastLit == null ? (LiteralReason)this : lastLit;
    }

    public InfinitesimalNumber getBound() {
        return this.mBound;
    }

    public InfinitesimalNumber getExactBound() {
        return this.mBound;
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public boolean isUpper() {
        return this.mIsUpper;
    }

    public LAReason getOldReason() {
        return this.mOldReason;
    }

    public void setOldReason(LAReason old) {
        this.mOldReason = old;
    }

    public LiteralReason getLastLiteral() {
        return this.mLastlit;
    }

    abstract InfinitesimalNumber explain(Explainer var1, InfinitesimalNumber var2, Rational var3);

    public String toString() {
        return this.mVar + (this.mIsUpper ? "<=" : ">=") + this.mBound;
    }

    public int hashCode() {
        return HashUtils.hashJenkins(this.mBound.hashCode(), (Object)this.mVar);
    }

    public Term toSMTLIB(Theory smtTheory, boolean useAuxVars) {
        MutableAffineTerm at = new MutableAffineTerm();
        at.add(Rational.ONE, this.mVar);
        at.add(this.mBound.negate());
        if (!this.mIsUpper) {
            at.add(this.mVar.getEpsilon());
        }
        Term posTerm = at.toSMTLibLeq0(smtTheory);
        return this.mIsUpper ? posTerm : smtTheory.term("not", posTerm);
    }
}

