/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CompositeReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CutCreator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LASharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.SOIPivoter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.TableauxRow;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LinArSolve
implements ITheory {
    final Clausifier mClausifier;
    final ScopedArrayList<LinVar> mLinvars;
    final ArrayList<TableauxRow> mTableaux;
    final ArrayList<BitSet> mDependentRows;
    final Set<LinVar> mIntVars;
    final Queue<Literal> mProplist;
    final ScopedHashMap<Map<LinVar, Rational>, LinVar> mBasics;
    final Set<LinVar> mOob;
    int mNumPivots;
    int mNumPivotsBland;
    long mPivotTime;
    long mFixTime;
    int mCompositeCreateLit;
    int mCountGetUpperBound;
    long mTimeGetUpperBound;
    int mNumCuts;
    int mNumBranches;
    long mCutGenTime;
    final ScopedArrayList<LASharedTerm> mSharedVars = new ScopedArrayList();
    final ArrayDeque<Literal> mSuggestions;
    private long mPropBoundTime;
    private long mPropBoundSetTime;
    private long mBacktrackPropTime;
    private final BitSet mDirty;
    private LinVar mConflictVar;
    private Rational mEps;
    private boolean mInCheck = false;

    public LinArSolve(Clausifier clausifier) {
        this.mClausifier = clausifier;
        this.mLinvars = new ScopedArrayList();
        this.mTableaux = new ArrayList();
        this.mDependentRows = new ArrayList();
        this.mIntVars = new LinkedHashSet<LinVar>();
        this.mDirty = new BitSet();
        this.mProplist = new ArrayDeque<Literal>();
        this.mSuggestions = new ArrayDeque();
        this.mBasics = new ScopedHashMap();
        this.mOob = new HashSet<LinVar>();
        this.mNumPivots = 0;
        this.mPivotTime = 0L;
        this.mFixTime = 0L;
        this.mCompositeCreateLit = 0;
        this.mNumCuts = 0;
        this.mNumBranches = 0;
        this.mCutGenTime = 0L;
    }

    public DPLLEngine getEngine() {
        return this.mClausifier.getEngine();
    }

    public LogProxy getLogger() {
        return this.mClausifier.getLogger();
    }

    private boolean checkClean() {
        return true;
    }

    private boolean checkoobcontent() {
        for (LinVar v : this.mLinvars) {
            assert (!v.outOfBounds() || this.mOob.contains(v)) : "Variable " + v + " is out of bounds: " + v.getLowerBound() + "<=" + v.getValue() + "<=" + v.getUpperBound();
        }
        return true;
    }

    public LinVar addVar(Term name, boolean isint, int level) {
        this.mClausifier.getLogger().debug("Creating var %s", name);
        LinVar var = new LinVar(name, isint, level, this.mLinvars.size());
        this.mLinvars.add(var);
        this.mDependentRows.add(new BitSet());
        this.mTableaux.add(null);
        if (isint) {
            this.mIntVars.add(var);
        }
        return var;
    }

    private LinVar generateLinVar(TreeMap<LinVar, Rational> factors) {
        if (factors.size() == 1) {
            Map.Entry<LinVar, Rational> me = factors.entrySet().iterator().next();
            assert (me.getValue().equals(Rational.ONE));
            LinVar var = me.getKey();
            return var;
        }
        LinVar var = this.mBasics.get(factors);
        if (var == null) {
            LinVar[] vars = new LinVar[factors.size()];
            BigInteger[] coeffs = new BigInteger[factors.size()];
            int i = 0;
            TreeMap<LinVar, Rational> curcoeffs = new TreeMap<LinVar, Rational>();
            boolean isInt = true;
            for (Map.Entry<LinVar, Rational> entry : factors.entrySet()) {
                vars[i] = entry.getKey();
                assert (entry.getValue().denominator().equals(BigInteger.ONE));
                coeffs[i] = entry.getValue().numerator();
                this.unsimplifyAndAdd(entry.getKey(), entry.getValue(), curcoeffs);
                isInt &= vars[i].mIsInt;
                ++i;
            }
            int index = this.mLinvars.size();
            var = new LinVar(new LinTerm(vars, coeffs), isInt, this.mClausifier.getStackLevel(), index);
            this.mBasics.put(factors, var);
            this.mLinvars.add(var);
            this.mDependentRows.add(null);
            this.mTableaux.add(new TableauxRow(var, curcoeffs));
            this.mDirty.set(index);
            this.mClausifier.getLogger().debug("Generated LinVar %1$s", var);
            var.mBasic = true;
            ExactInfinitesimalNumber curValue = ExactInfinitesimalNumber.ZERO;
            for (MatrixEntry entry : var.getTableauxRow(this)) {
                LinVar colVar = entry.getColumn();
                Rational coeff = Rational.valueOf(entry.getCoeff(), entry.getHeadCoeff().negate());
                curValue = curValue.add(colVar.getValue().mul(coeff));
                this.mDependentRows.get(colVar.mMatrixpos).set(var.mMatrixpos);
            }
            var.setValue(curValue);
            assert (var.checkCoeffChain(this));
        }
        return var;
    }

    public Literal generateConstraint(MutableAffineTerm at, boolean strict) {
        Rational normFactor = at.getGCD().inverse();
        at.mul(normFactor);
        LinVar var = this.generateLinVar(this.getSummandMap(at));
        return this.generateConstraint(var, at.mConstant.mReal.negate(), normFactor.isNegative(), strict);
    }

    private final TreeMap<LinVar, Rational> getSummandMap(MutableAffineTerm at) {
        return at.getSummands();
    }

    void updateVariableValue(LinVar updateVar, ExactInfinitesimalNumber newValue) {
        assert (!updateVar.mBasic);
        ExactInfinitesimalNumber diff = newValue.sub(updateVar.getValue());
        updateVar.addValue(diff);
        for (MatrixEntry entry : updateVar.getTableauxColumn(this)) {
            LinVar var = entry.getRow();
            assert (var.mBasic);
            Rational coeff = Rational.valueOf(entry.getCoeff(), entry.getHeadCoeff().negate());
            var.addValue(diff.mul(coeff));
            assert (!var.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
            if (!var.outOfBounds()) continue;
            this.mOob.add(var);
        }
    }

    private void updateVariable(LinVar updateVar, boolean isUpper, InfinitesimalNumber oldBound, InfinitesimalNumber newBound) {
        boolean changeVar;
        assert (!updateVar.mBasic);
        ExactInfinitesimalNumber diff = updateVar.getValue().isub(newBound);
        boolean bl = isUpper ? diff.signum() < 0 : (changeVar = diff.signum() > 0);
        if (changeVar) {
            updateVar.addValue(diff);
        }
        assert (!updateVar.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
        BitSet dependencies = this.mDependentRows.get(updateVar.mMatrixpos);
        this.mDirty.or(dependencies);
        for (MatrixEntry entry : updateVar.getTableauxColumn(this)) {
            LinVar var = entry.getRow();
            assert (var.mBasic);
            Rational coeff = Rational.valueOf(entry.getCoeff(), entry.getHeadCoeff().negate());
            if (changeVar) {
                var.addValue(diff.mul(coeff));
            }
            assert (!var.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
            if (!var.outOfBounds()) continue;
            this.mOob.add(var);
        }
    }

    public void removeReason(LAReason reason) {
        LAReason chain;
        LinVar var = reason.getVar();
        if (reason.isUpper()) {
            if (var.mUpper == reason) {
                var.mUpper = reason.getOldReason();
                if (var.mUpperLiteral == reason) {
                    var.mUpperLiteral = ((LiteralReason)reason).getOldLiteralReason();
                } else assert (reason instanceof CompositeReason);
                if (!var.mBasic) {
                    if (var.getValue().compareTo(var.getLowerBound()) < 0) {
                        this.updateVariableValue(var, new ExactInfinitesimalNumber(var.getLowerBound()));
                    }
                } else if (var.outOfBounds()) {
                    this.mOob.add(var);
                }
                return;
            }
            chain = var.mUpper;
            if (var.mUpperLiteral == reason) {
                var.mUpperLiteral = ((LiteralReason)reason).getOldLiteralReason();
            }
        } else {
            if (var.mLower == reason) {
                var.mLower = reason.getOldReason();
                if (var.mLowerLiteral == reason) {
                    var.mLowerLiteral = ((LiteralReason)reason).getOldLiteralReason();
                } else assert (reason instanceof CompositeReason);
                if (!var.mBasic) {
                    if (var.getValue().compareTo(var.getUpperBound()) > 0) {
                        this.updateVariableValue(var, new ExactInfinitesimalNumber(var.getUpperBound()));
                    }
                } else if (var.outOfBounds()) {
                    this.mOob.add(var);
                }
                return;
            }
            chain = var.mLower;
            if (var.mLowerLiteral == reason) {
                var.mLowerLiteral = ((LiteralReason)reason).getOldLiteralReason();
            }
        }
        while (true) {
            if (chain instanceof LiteralReason && ((LiteralReason)chain).getOldLiteralReason() == reason) {
                ((LiteralReason)chain).setOldLiteralReason(((LiteralReason)reason).getOldLiteralReason());
            }
            if (chain.getOldReason() == reason) break;
            chain = chain.getOldReason();
        }
        chain.setOldReason(reason.getOldReason());
    }

    public void removeLiteralReason(LiteralReason reason) {
        assert (this.checkClean());
        for (LAReason depReason : reason.getDependents()) {
            this.removeReason(depReason);
        }
        this.removeReason(reason);
        assert (this.checkClean());
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        LAReason reason;
        InfinitesimalNumber bound;
        LinVar var;
        assert (this.checkClean());
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAEquality laeq = (LAEquality)atom;
            var = laeq.getVar();
            bound = new InfinitesimalNumber(laeq.getBound(), 0);
            if (laeq == literal.negate()) {
                var.removeDiseq(laeq);
            }
        } else if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            var = bc.getVar();
            bound = bc.getBound();
        } else {
            return;
        }
        for (reason = var.mUpper; reason != null && reason.getBound().lesseq(bound); reason = reason.getOldReason()) {
            if (!(reason instanceof LiteralReason) || ((LiteralReason)reason).getLiteral() != literal || reason.getLastLiteral() != reason) continue;
            this.removeLiteralReason((LiteralReason)reason);
            break;
        }
        for (reason = var.mLower; reason != null && bound.lesseq(reason.getBound()); reason = reason.getOldReason()) {
            if (!(reason instanceof LiteralReason) || ((LiteralReason)reason).getLiteral() != literal || reason.getLastLiteral() != reason) continue;
            this.removeLiteralReason((LiteralReason)reason);
            break;
        }
    }

    public Clause checkPendingConflict() {
        LinVar var = this.mConflictVar;
        if (var != null && var.getTightUpperBound().less(var.getTightLowerBound())) {
            Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), null);
            InfinitesimalNumber slack = var.getTightLowerBound().sub(var.getTightUpperBound());
            slack = var.mUpper.explain(explainer, slack, Rational.ONE);
            slack = var.mLower.explain(explainer, slack, Rational.MONE);
            return explainer.createClause(this.getEngine());
        }
        this.mConflictVar = null;
        return null;
    }

    @Override
    public void backtrackAll() {
        this.mProplist.clear();
        this.mSuggestions.clear();
    }

    @Override
    public void backtrackStart() {
        this.mProplist.clear();
        this.mSuggestions.clear();
    }

    @Override
    public Clause backtrackComplete() {
        Clause conflict = this.checkPendingConflict();
        if (conflict != null) {
            return conflict;
        }
        conflict = this.checkPendingBoundPropagations();
        if (conflict != null) {
            return conflict;
        }
        for (LinVar lv : this.mLinvars) {
            if (lv.hasTightUpperBound()) {
                for (BoundConstraint bc : lv.mConstraints.tailMap(lv.getTightUpperBound(), true).values()) {
                    assert (lv.getTightUpperBound().lesseq(bc.getBound()));
                    if (bc.getDecideStatus() != null) continue;
                    this.mProplist.add(bc);
                }
                for (LAEquality laeq : lv.mEqualities.tailMap(lv.getTightUpperBound(), false).values()) {
                    if (laeq.getDecideStatus() != null) continue;
                    this.mProplist.add(laeq.negate());
                }
            }
            if (!lv.hasTightLowerBound()) continue;
            for (BoundConstraint bc : lv.mConstraints.headMap(lv.getTightLowerBound(), false).values()) {
                if (bc.getDecideStatus() != null) continue;
                this.mProplist.add(bc.negate());
            }
            for (LAEquality laeq : lv.mEqualities.headMap(lv.getTightLowerBound(), false).values()) {
                if (laeq.getDecideStatus() != null) continue;
                this.mProplist.add(laeq.negate());
            }
        }
        assert (this.checkClean());
        return this.fixOobs();
    }

    Clause checkPendingBoundPropagations() {
        while (!this.mDirty.isEmpty()) {
            int matrixPos = this.mDirty.nextSetBit(0);
            LinVar var = (LinVar)this.mLinvars.get(matrixPos);
            this.mDirty.clear(matrixPos);
            if (!var.mBasic) continue;
            long time = System.nanoTime();
            boolean hasUpper = true;
            boolean hasLower = true;
            TableauxRow row = this.mTableaux.get(var.mMatrixpos);
            int sign = -row.getRawCoeff(0).signum();
            for (int i = 1; i < row.size(); ++i) {
                InfinitesimalNumber colBound;
                int coeffSign = row.getRawCoeff(i).signum();
                LinVar colvar = (LinVar)this.mLinvars.get(row.getRawIndex(i));
                if (hasUpper) {
                    InfinitesimalNumber infinitesimalNumber = colBound = coeffSign == sign ? colvar.getUpperBound() : colvar.getLowerBound();
                    if (colBound.isInfinity()) {
                        hasUpper = false;
                    }
                }
                if (!hasLower) continue;
                InfinitesimalNumber infinitesimalNumber = colBound = coeffSign == sign ? colvar.getLowerBound() : colvar.getUpperBound();
                if (!colBound.isInfinity()) continue;
                hasLower = false;
            }
            this.mBacktrackPropTime += System.nanoTime() - time;
            time = System.nanoTime();
            if (hasUpper || hasLower) {
                InfinitesimalNumber upperBound = InfinitesimalNumber.ZERO;
                InfinitesimalNumber lowerBound = InfinitesimalNumber.ZERO;
                for (MatrixEntry entry : var.getTableauxRow(this)) {
                    InfinitesimalNumber colBound;
                    Rational coeff = Rational.valueOf(entry.getCoeff(), entry.getHeadCoeff().negate());
                    LinVar colvar = entry.getColumn();
                    if (hasUpper) {
                        colBound = coeff.signum() > 0 ? colvar.getUpperBound() : colvar.getLowerBound();
                        upperBound = upperBound.add(colBound.mul(coeff));
                    }
                    if (!hasLower) continue;
                    colBound = coeff.signum() > 0 ? colvar.getLowerBound() : colvar.getUpperBound();
                    lowerBound = lowerBound.add(colBound.mul(coeff));
                }
                Clause conflict = null;
                if (hasUpper) {
                    conflict = this.propagateBound(var, upperBound, true);
                }
                if (hasLower) {
                    if (conflict == null) {
                        conflict = this.propagateBound(var, lowerBound, false);
                    } else {
                        this.mDirty.set(var.mMatrixpos);
                    }
                }
                if (conflict != null) {
                    this.mPropBoundTime += System.nanoTime() - time;
                    return conflict;
                }
            }
            this.mPropBoundTime += System.nanoTime() - time;
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        this.mSuggestions.clear();
        this.mClausifier.getLogger().debug("Final Check LA");
        assert (this.mOob.isEmpty());
        Clause c = this.ensureIntegrals();
        if (c != null || !this.mSuggestions.isEmpty() || !this.mProplist.isEmpty()) {
            return c;
        }
        assert (this.mOob.isEmpty());
        this.mutate();
        assert (this.mOob.isEmpty());
        Map<ExactInfinitesimalNumber, List<LASharedTerm>> cong = this.getSharedCongruences();
        assert (this.checkClean());
        this.mClausifier.getLogger().debug("cong: %s", cong);
        for (LinVar v : this.mLinvars) {
            Literal lit;
            LAEquality ea = v.getDiseq(v.getValue().getRealValue());
            if (ea == null || (lit = this.ensureDisequality(ea)) == null) continue;
            assert (lit.getAtom().getDecideStatus() == null);
            this.mSuggestions.add(lit);
            this.mClausifier.getLogger().debug("Using %s to ensure disequality %s", lit, ea.negate());
        }
        if (this.mSuggestions.isEmpty() && this.mProplist.isEmpty()) {
            return this.mbtc(cong);
        }
        assert (this.compositesSatisfied());
        return null;
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    private boolean compositesSatisfied() {
        for (LinVar v : this.mLinvars) {
            assert (v.getValue().roundToInfinitesimal().compareTo(v.getTightUpperBound()) <= 0);
            assert (v.getValue().roundToInfinitesimal().compareTo(v.getTightLowerBound()) >= 0);
        }
        return true;
    }

    @Override
    public Literal getPropagatedLiteral() {
        while (!this.mProplist.isEmpty()) {
            Literal lit = this.mProplist.remove();
            if (lit.getAtom().getDecideStatus() != null) continue;
            return lit;
        }
        return null;
    }

    private Clause createUnitClause(Literal literal, boolean isUpper, InfinitesimalNumber bound, LinVar var) {
        Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), literal);
        if (isUpper) {
            assert (var.getTightUpperBound().less(bound));
            explainer.addLiteral(literal, Rational.MONE);
            LAReason reason = var.mUpper;
            while (reason.getOldReason() != null && reason.getOldReason().getBound().less(bound)) {
                reason = reason.getOldReason();
            }
            reason.explain(explainer, bound.sub(reason.getBound()), Rational.ONE);
        } else {
            assert (bound.less(var.getTightLowerBound()));
            explainer.addLiteral(literal, Rational.ONE);
            LAReason reason = var.mLower;
            while (reason.getOldReason() != null && bound.less(reason.getOldReason().getBound())) {
                reason = reason.getOldReason();
            }
            reason.explain(explainer, reason.getBound().sub(bound), Rational.MONE);
        }
        return explainer.createClause(this.getEngine());
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAReason upper;
            LAEquality laeq = (LAEquality)atom;
            LinVar var = laeq.getVar();
            if (literal == laeq) {
                InfinitesimalNumber bound = new InfinitesimalNumber(laeq.getBound(), 0);
                LAReason upperReason = var.mUpper;
                while (upperReason.getBound().less(bound)) {
                    upperReason = upperReason.getOldReason();
                }
                LAReason lowerReason = var.mLower;
                while (bound.less(lowerReason.getBound())) {
                    lowerReason = lowerReason.getOldReason();
                }
                assert (upperReason.getBound().equals(bound) && lowerReason.getBound().equals(bound)) : "Bounds on variable do not match propagated equality bound";
                Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), literal);
                LiteralReason uppereq = new LiteralReason(var, var.mUpperLiteral, var.getTightUpperBound().sub(var.getEpsilon()), true, laeq.negate());
                uppereq.setOldReason(upperReason);
                lowerReason.explain(explainer, var.getEpsilon(), Rational.MONE);
                explainer.addEQAnnotation(uppereq, Rational.ONE);
                return explainer.createClause(this.getEngine());
            }
            InfinitesimalNumber bound = new InfinitesimalNumber(laeq.getBound(), 0);
            for (upper = var.mUpper; laeq.getStackPosition() >= 0 && upper != null && upper.getLastLiteral().getStackPosition() >= laeq.getStackPosition(); upper = upper.getOldReason()) {
            }
            return this.createUnitClause(literal, upper != null && upper.getBound().less(bound), bound, var);
        }
        if (atom instanceof CCEquality) {
            return this.generateEqualityClause(literal);
        }
        BoundConstraint bc = (BoundConstraint)atom;
        LinVar var = bc.getVar();
        boolean isUpper = literal.getSign() > 0;
        return this.createUnitClause(literal, isUpper, isUpper ? bc.getInverseBound() : bc.getBound(), var);
    }

    private Clause generateEqualityClause(Literal cclit) {
        CCEquality cceq = (CCEquality)cclit.getAtom();
        Literal ea = cceq.getLASharedData();
        if (cceq == cclit) {
            ea = ea.negate();
        }
        return new Clause(new Literal[]{cclit, ea}, new LeafNode(-6, EQAnnotation.EQ));
    }

    private void insertReasonOfNewComposite(LinVar var, Literal lit) {
        boolean isUpper;
        BoundConstraint bc = (BoundConstraint)lit.getAtom();
        boolean bl = isUpper = lit == bc;
        if (isUpper) {
            LiteralReason nextReason;
            InfinitesimalNumber bound = bc.getBound();
            LiteralReason prevReason = null;
            for (nextReason = var.mUpperLiteral; nextReason != null && nextReason.getBound().less(bound); nextReason = nextReason.getOldLiteralReason()) {
                prevReason = nextReason;
            }
            LiteralReason reason = new LiteralReason(var, nextReason, bound, true, lit);
            if (prevReason != null) {
                prevReason.setOldLiteralReason(reason);
            } else {
                var.mUpperLiteral = reason;
            }
            if (bound.less(var.getExactUpperBound())) {
                reason.setOldReason(var.mUpper);
                var.mUpper = reason;
            } else {
                LAReason thereason = var.mUpper;
                while (thereason.getOldReason().getExactBound().less(bound)) {
                    thereason = thereason.getOldReason();
                }
                assert (thereason.getExactBound().less(bound) && bound.less(thereason.getOldReason().getExactBound()));
                reason.setOldReason(thereason.getOldReason());
                thereason.setOldReason(reason);
            }
            if (var.outOfBounds()) {
                if (var.mBasic) {
                    this.mOob.add(var);
                } else {
                    this.updateVariableValue(var, new ExactInfinitesimalNumber(bound));
                }
            }
        } else {
            LiteralReason nextReason;
            InfinitesimalNumber bound = bc.getInverseBound();
            LiteralReason prevReason = null;
            for (nextReason = var.mLowerLiteral; nextReason != null && bound.less(nextReason.getBound()); nextReason = nextReason.getOldLiteralReason()) {
                prevReason = nextReason;
            }
            LiteralReason reason = new LiteralReason(var, nextReason, bound, false, lit);
            if (prevReason != null) {
                prevReason.setOldLiteralReason(reason);
            } else {
                var.mLowerLiteral = reason;
            }
            if (var.getExactLowerBound().less(bound)) {
                reason.setOldReason(var.mLower);
                var.mLower = reason;
            } else {
                LAReason thereason = var.mLower;
                while (bound.less(thereason.getOldReason().getExactBound())) {
                    thereason = thereason.getOldReason();
                }
                assert (thereason.getOldReason().getExactBound().less(bound) && bound.less(thereason.getExactBound()));
                reason.setOldReason(thereason.getOldReason());
                thereason.setOldReason(reason);
            }
            if (var.outOfBounds()) {
                if (var.mBasic) {
                    this.mOob.add(var);
                } else {
                    this.updateVariableValue(var, new ExactInfinitesimalNumber(bound));
                }
            }
        }
    }

    private Clause setBound(LAReason reason) {
        LAEquality ea;
        InfinitesimalNumber oldBound;
        LinVar var = reason.getVar();
        InfinitesimalNumber bound = reason.getBound();
        InfinitesimalNumber epsilon = var.getEpsilon();
        LiteralReason lastLiteral = reason.getLastLiteral();
        if (reason instanceof LiteralReason) {
            if (reason.isUpper()) {
                reason.getVar().mUpperLiteral = (LiteralReason)reason;
            } else {
                reason.getVar().mLowerLiteral = (LiteralReason)reason;
            }
        }
        if (reason.isUpper()) {
            oldBound = var.getTightUpperBound();
            assert (reason.getExactBound().less(var.getExactUpperBound()));
            reason.setOldReason(var.mUpper);
            var.mUpper = reason;
            while (bound.mEps == 0 && (ea = var.getDiseq(bound.mReal)) != null) {
                bound = bound.sub(epsilon);
                if (ea.getStackPosition() > lastLiteral.getStackPosition()) {
                    var.mUpperLiteral = lastLiteral = new LiteralReason(var, var.mUpperLiteral, bound, true, ea.negate());
                    var.mUpper = var.mUpperLiteral;
                } else {
                    var.mUpperLiteral = new LiteralReason(var, var.mUpperLiteral, bound, true, ea.negate(), lastLiteral);
                    var.mUpper = var.mUpperLiteral;
                    lastLiteral.addDependent(var.mUpper);
                }
                var.mUpper.setOldReason(reason);
                reason = var.mUpper;
            }
            if (!var.mBasic) {
                this.updateVariable(var, true, oldBound, bound);
            } else if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            for (BoundConstraint bc : var.mConstraints.subMap(bound, oldBound).values()) {
                assert (var.getTightUpperBound().lesseq(bc.getBound()));
                this.mProplist.add(bc);
            }
            for (LAEquality laeq : var.mEqualities.subMap(bound.add(var.getEpsilon()), oldBound.add(var.getEpsilon())).values()) {
                this.mProplist.add(laeq.negate());
            }
        } else {
            oldBound = var.getTightLowerBound();
            assert (var.getExactLowerBound().less(reason.getExactBound()));
            reason.setOldReason(var.mLower);
            var.mLower = reason;
            while (bound.mEps == 0 && (ea = var.getDiseq(bound.mReal)) != null) {
                bound = bound.add(epsilon);
                if (ea.getStackPosition() > lastLiteral.getStackPosition()) {
                    var.mLowerLiteral = lastLiteral = new LiteralReason(var, var.mLowerLiteral, bound, false, ea.negate());
                    var.mLower = var.mLowerLiteral;
                } else {
                    var.mLowerLiteral = new LiteralReason(var, var.mLowerLiteral, bound, false, ea.negate(), lastLiteral);
                    var.mLower = var.mLowerLiteral;
                    lastLiteral.addDependent(var.mLower);
                }
                var.mLower.setOldReason(reason);
                reason = var.mLower;
            }
            if (!var.mBasic) {
                this.updateVariable(var, false, oldBound, bound);
            } else if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            for (BoundConstraint bc : var.mConstraints.subMap(oldBound, bound).values()) {
                assert (bc.getInverseBound().lesseq(var.getTightLowerBound()));
                this.mProplist.add(bc.negate());
            }
            for (LAEquality laeq : var.mEqualities.subMap(oldBound, bound).values()) {
                this.mProplist.add(laeq.negate());
            }
        }
        InfinitesimalNumber ubound = var.getTightUpperBound();
        InfinitesimalNumber lbound = var.getTightLowerBound();
        if (lbound.equals(ubound)) {
            LAEquality lasd = (LAEquality)var.mEqualities.get(lbound);
            if (lasd != null && lasd.getDecideStatus() == null) {
                this.mProplist.add(lasd);
            }
        } else if (ubound.less(lbound)) {
            this.mConflictVar = var;
            return this.checkPendingConflict();
        }
        assert (var.mBasic || !var.outOfBounds());
        return null;
    }

    @Override
    public Clause setLiteral(Literal literal) {
        Clause conflict = this.checkPendingBoundPropagations();
        if (conflict != null) {
            return conflict;
        }
        assert (this.checkClean());
        if (this.mProplist.contains(literal.negate())) {
            return this.getUnitClause(literal.negate());
        }
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAEquality lasd = (LAEquality)atom;
            for (CCEquality eq : lasd.getDependentEqualities()) {
                if (eq.getDecideStatus() == null) {
                    this.mProplist.add(literal == atom ? eq : eq.negate());
                    continue;
                }
                if (eq.getDecideStatus().getSign() == literal.getSign()) continue;
                return this.generateEqualityClause(eq.getDecideStatus().negate());
            }
            LinVar var = lasd.getVar();
            InfinitesimalNumber bound = new InfinitesimalNumber(lasd.getBound(), 0);
            if (literal.getSign() == 1) {
                if (this.mClausifier.getLogger().isDebugEnabled()) {
                    this.mClausifier.getLogger().debug("Setting " + lasd.getVar() + " to " + lasd.getBound());
                }
                if (bound.less(var.getTightUpperBound())) {
                    conflict = this.setBound(new LiteralReason(var, var.mUpperLiteral, bound, true, literal));
                }
                if (conflict != null) {
                    return conflict;
                }
                if (var.getTightLowerBound().less(bound)) {
                    conflict = this.setBound(new LiteralReason(var, var.mLowerLiteral, bound, false, literal));
                }
            } else {
                var.addDiseq(lasd);
                if (var.getTightUpperBound().equals(bound)) {
                    conflict = this.setBound(new LiteralReason(var, var.mUpperLiteral, bound.sub(var.getEpsilon()), true, literal));
                } else if (var.getTightLowerBound().equals(bound)) {
                    conflict = this.setBound(new LiteralReason(var, var.mLowerLiteral, bound.add(var.getEpsilon()), false, literal));
                }
            }
        } else if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            LinVar var = bc.getVar();
            if (literal == bc) {
                if (bc.getBound().less(var.getExactUpperBound())) {
                    conflict = this.setBound(new LiteralReason(var, var.mUpperLiteral, bc.getBound(), true, literal));
                }
            } else if (var.getExactLowerBound().less(bc.getInverseBound())) {
                conflict = this.setBound(new LiteralReason(var, var.mLowerLiteral, bc.getInverseBound(), false, literal));
            }
        }
        assert (conflict != null || this.checkClean());
        return conflict;
    }

    public boolean checkPendingPropagation() {
        Iterator it = this.mProplist.iterator();
        while (it.hasNext()) {
            Literal propLit = (Literal)it.next();
            if (propLit.getAtom().getDecideStatus() == propLit) {
                it.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Clause checkpoint() {
        do {
            Clause conflict;
            if ((conflict = this.checkPendingBoundPropagations()) != null) {
                return conflict;
            }
            if (this.checkPendingPropagation()) {
                return null;
            }
            if (!this.mInCheck) {
                return null;
            }
            conflict = this.fixOobs();
            if (conflict == null) continue;
            return conflict;
        } while (!this.mDirty.isEmpty());
        return null;
    }

    public Rational realValue(LinVar var) {
        if (this.mEps == null) {
            this.prepareModel();
        }
        ExactInfinitesimalNumber value = var.getValue();
        return value.getRealValue().addmul(value.getEpsilon(), this.mEps);
    }

    public void dumpTableaux(LogProxy logger) {
        for (TableauxRow row : this.mTableaux) {
            if (row == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(row.getRawCoeff(0)).append('*').append(this.mLinvars.get(row.getRawIndex(0)));
            String comma = "";
            for (int i = 0; i < row.size(); ++i) {
                sb.append(comma).append(row.getRawCoeff(i)).append('*').append(this.mLinvars.get(row.getRawIndex(i)));
                comma = " ; ";
            }
            logger.debug(sb.toString());
        }
    }

    public void dumpConstraints(LogProxy logger) {
        for (LinVar var : this.mLinvars) {
            StringBuilder sb = new StringBuilder();
            sb.append(var).append(var.mIsInt ? "[int]" : "[real]").append(": ");
            InfinitesimalNumber lower = var.getLowerBound();
            if (lower != InfinitesimalNumber.NEGATIVE_INFINITY) {
                sb.append("lower: ").append(var.getLowerBound()).append(" <= ");
            }
            sb.append(var.getValue());
            InfinitesimalNumber upper = var.getUpperBound();
            if (upper != InfinitesimalNumber.POSITIVE_INFINITY) {
                sb.append(" <= ").append(upper).append(" : upper");
            }
            logger.debug(sb);
        }
    }

    private void prepareModel() {
        if (this.mEps != null) {
            return;
        }
        TreeSet<Rational> prohibitions = new TreeSet<Rational>();
        InfinitesimalNumber maxeps = this.computeMaxEpsilon(prohibitions);
        this.mEps = maxeps == InfinitesimalNumber.POSITIVE_INFINITY ? Rational.ONE : maxeps.inverse().ceil().mReal.inverse();
        TreeMap<Rational, Set<ExactInfinitesimalNumber>> sharedPoints = new TreeMap<Rational, Set<ExactInfinitesimalNumber>>();
        Map<ExactInfinitesimalNumber, List<LASharedTerm>> cong = this.getSharedCongruences();
        for (ExactInfinitesimalNumber value : cong.keySet()) {
            Rational eps = value.getEpsilon();
            TreeSet<ExactInfinitesimalNumber> confl = (TreeSet<ExactInfinitesimalNumber>)sharedPoints.get(eps);
            if (confl == null) {
                confl = new TreeSet<ExactInfinitesimalNumber>();
                sharedPoints.put(eps, confl);
            }
            confl.add(new ExactInfinitesimalNumber(value.getRealValue()));
        }
        while (prohibitions.contains(this.mEps) || this.hasSharing(sharedPoints, new ExactInfinitesimalNumber(this.mEps))) {
            this.mEps = this.mEps.inverse().add(Rational.ONE).inverse();
        }
    }

    @Override
    public void dumpModel(LogProxy logger) {
        if (logger.isInfoEnabled()) {
            this.prepareModel();
            logger.info("Assignments:");
            for (LinVar var : this.mLinvars) {
                if (var.isInitiallyBasic()) continue;
                logger.info(var + " = " + this.realValue(var));
            }
        }
    }

    @Override
    public void printStatistics(LogProxy logger) {
        if (logger.isInfoEnabled()) {
            logger.info("Number of Bland pivoting-Operations: " + this.mNumPivotsBland + "/" + this.mNumPivots);
            int basicVars = 0;
            for (LinVar var : this.mLinvars) {
                if (var.isInitiallyBasic()) continue;
                ++basicVars;
            }
            logger.info("Number of variables: " + this.mLinvars.size() + " nonbasic: " + basicVars + " shared: " + this.mSharedVars.size());
            logger.info("Time for fix Oob          : " + this.mFixTime / 1000000L);
            logger.info("Time for pivoting         : " + this.mPivotTime / 1000000L);
            logger.info("Time for bound computation: " + this.mPropBoundTime / 1000000L);
            logger.info("Time for bound setting    : " + this.mPropBoundSetTime / 1000000L);
            logger.info("Time for bound comp(back) : " + this.mBacktrackPropTime / 1000000L);
            logger.info("Composite::createLit: " + this.mCompositeCreateLit);
            logger.info("Number of cuts: " + this.mNumCuts);
            logger.info("Time for cut-generation: " + this.mCutGenTime / 1000000L);
            logger.info("Count/Time for getUpperBound: %d / %d.%03d", this.mCountGetUpperBound, this.mTimeGetUpperBound / 1000000000L, this.mTimeGetUpperBound / 1000000L % 1000L);
            logger.info("Number of branchings: " + this.mNumBranches);
        }
    }

    final void pivot(int rowMatrixPos, int colMatrixPos) {
        ++this.mNumPivots;
        long starttime = System.nanoTime();
        LinVar basic = (LinVar)this.mLinvars.get(rowMatrixPos);
        LinVar nonbasic = (LinVar)this.mLinvars.get(colMatrixPos);
        TableauxRow row = this.mTableaux.get(rowMatrixPos);
        if (this.mClausifier.getLogger().isDebugEnabled()) {
            this.mClausifier.getLogger().debug("pivot " + basic + " / " + nonbasic);
        }
        assert (basic.mBasic);
        assert (!nonbasic.mBasic);
        basic.mBasic = false;
        nonbasic.mBasic = true;
        assert (basic.checkCoeffChain(this));
        this.mTableaux.set(rowMatrixPos, null);
        row.swapRowCol(colMatrixPos);
        this.mTableaux.set(colMatrixPos, row);
        BitSet todo = this.mDependentRows.set(colMatrixPos, null);
        this.mDependentRows.set(rowMatrixPos, new BitSet());
        for (int i = 1; i < row.size(); ++i) {
            BitSet dependencies = this.mDependentRows.get(row.getRawIndex(i));
            assert (row.getRawIndex(i) == rowMatrixPos || dependencies.get(rowMatrixPos));
            dependencies.clear(rowMatrixPos);
            dependencies.set(colMatrixPos);
        }
        basic.mCachedRowVars = null;
        basic.mCachedRowCoeffs = null;
        this.mDirty.set(colMatrixPos);
        assert (nonbasic.mCachedRowCoeffs == null);
        assert (nonbasic.checkCoeffChain(this));
        todo.clear(rowMatrixPos);
        while (!todo.isEmpty()) {
            int rowIdx = todo.nextSetBit(0);
            LinVar rowVar = (LinVar)this.mLinvars.get(rowIdx);
            todo.clear(rowIdx);
            this.mTableaux.get(rowIdx).addRow(this, row);
            rowVar.mCachedRowVars = null;
            rowVar.mCachedRowCoeffs = null;
            this.mDirty.set(rowVar.mMatrixpos);
            assert (rowVar.checkCoeffChain(this));
        }
        this.mPivotTime += System.nanoTime() - starttime;
    }

    private Clause ensureIntegrals() {
        boolean isIntegral = true;
        for (LinVar lv : this.mIntVars) {
            ExactInfinitesimalNumber value = lv.getValue();
            if (value.getRealValue().isIntegral() && value.getEpsilon().equals(Rational.ZERO)) continue;
            isIntegral = false;
        }
        if (isIntegral) {
            return null;
        }
        LogProxy logger = this.mClausifier.getLogger();
        if (logger.isDebugEnabled()) {
            this.dumpTableaux(logger);
            this.dumpConstraints(logger);
        }
        assert (this.mOob.isEmpty());
        long start = System.nanoTime();
        CutCreator cutter = new CutCreator(this);
        cutter.generateCuts();
        this.mCutGenTime += System.nanoTime() - start;
        Clause c = this.checkPendingConflict();
        if (c != null) {
            return c;
        }
        c = this.checkpoint();
        if (c != null) {
            return c;
        }
        return null;
    }

    private Clause fixOobs() {
        long starttime = System.nanoTime();
        boolean hasOob = false;
        Iterator<LinVar> it = this.mOob.iterator();
        while (it.hasNext()) {
            LinVar var = it.next();
            if (var.outOfBounds()) {
                hasOob = true;
                continue;
            }
            it.remove();
        }
        if (!hasOob) {
            return null;
        }
        Clause conflict = new SOIPivoter(this).fixOobs();
        if (conflict == null) {
            this.mOob.clear();
        }
        assert (this.checkClean());
        this.mFixTime += System.nanoTime() - starttime;
        return conflict;
    }

    private Clause propagateBound(LinVar basic, InfinitesimalNumber bound, boolean isUpper) {
        long start = System.nanoTime();
        if (isUpper ? bound.less(basic.getTightUpperBound()) : basic.getTightLowerBound().less(bound)) {
            Rational[] coeffs;
            LAReason[] reasons;
            TableauxRow row = this.mTableaux.get(basic.mMatrixpos);
            BigInteger denom = row.getRawCoeff(0).negate();
            LiteralReason lastLiteral = null;
            if (basic.mCachedRowCoeffs == null) {
                int rowLength = row.size() - 1;
                LinVar[] rowVars = new LinVar[rowLength];
                reasons = new LAReason[rowLength];
                coeffs = new Rational[rowLength];
                for (int i = 0; i < rowLength; ++i) {
                    LinVar nb = (LinVar)this.mLinvars.get(row.getRawIndex(i + 1));
                    Rational coeff = Rational.valueOf(row.getRawCoeff(i + 1), denom);
                    rowVars[i] = nb;
                    reasons[i] = coeff.isNegative() == isUpper ? nb.mLowerLiteral : nb.mUpperLiteral;
                    coeffs[i] = coeff;
                    LiteralReason lastOfThis = reasons[i].getLastLiteral();
                    if (lastLiteral != null && lastOfThis.getStackPosition() <= lastLiteral.getStackPosition()) continue;
                    lastLiteral = lastOfThis;
                }
                basic.mCachedRowCoeffs = coeffs;
                basic.mCachedRowVars = rowVars;
            } else {
                LinVar[] rowVars = basic.mCachedRowVars;
                coeffs = basic.mCachedRowCoeffs;
                reasons = new LAReason[rowVars.length];
                for (int i = 0; i < rowVars.length; ++i) {
                    reasons[i] = coeffs[i].isNegative() == isUpper ? rowVars[i].mLowerLiteral : rowVars[i].mUpperLiteral;
                    LiteralReason lastOfThis = reasons[i].getLastLiteral();
                    if (lastLiteral != null && lastOfThis.getStackPosition() <= lastLiteral.getStackPosition()) continue;
                    lastLiteral = lastOfThis;
                }
            }
            CompositeReason newComposite = new CompositeReason(basic, bound, isUpper, reasons, coeffs, lastLiteral);
            lastLiteral.addDependent(newComposite);
            long mid = System.nanoTime();
            this.mPropBoundTime += mid - start;
            Clause conflict = this.setBound(newComposite);
            this.mPropBoundSetTime += System.nanoTime() - mid;
            return conflict;
        }
        this.mPropBoundTime += System.nanoTime() - start;
        return null;
    }

    private Literal generateConstraint(LinVar var, Rational bound, boolean isLowerBound, boolean strict) {
        InfinitesimalNumber rbound = new InfinitesimalNumber(bound, strict ^ isLowerBound ? -1 : 0);
        if (var.isInt()) {
            rbound = rbound.floor();
        }
        return this.generateConstraint(var, rbound, isLowerBound);
    }

    private Literal generateConstraint(LinVar var, InfinitesimalNumber rbound, boolean isLowerBound) {
        BoundConstraint bc = (BoundConstraint)var.mConstraints.get(rbound);
        if (bc == null) {
            bc = new BoundConstraint(rbound, var, this.getEngine().getAssertionStackLevel());
            assert (bc.mVar.checkCoeffChain(this));
            this.getEngine().addAtom(bc);
            if (var.getTightUpperBound().lesseq(rbound)) {
                this.mProplist.add(bc);
            }
            if (rbound.less(var.getTightLowerBound())) {
                this.mProplist.add(bc.negate());
            }
        }
        return isLowerBound ? bc.negate() : bc;
    }

    private void removeLinVar(LinVar v) {
        BitSet dependencies;
        if (!v.mBasic && !(dependencies = this.mDependentRows.get(v.mMatrixpos)).isEmpty()) {
            int row = dependencies.nextSetBit(0);
            this.pivot(row, v.mMatrixpos);
        }
        assert (v.mBasic || this.mDependentRows.get(v.mMatrixpos).isEmpty());
        assert (v.mMatrixpos == this.mLinvars.size() - 1);
        this.mLinvars.remove(v.mMatrixpos);
        if (v.mBasic) {
            TableauxRow row = this.mTableaux.get(v.mMatrixpos);
            for (int i = 1; i < row.size(); ++i) {
                LinVar col = (LinVar)this.mLinvars.get(row.getRawIndex(i));
                assert (!col.mBasic);
                this.mDependentRows.get(col.mMatrixpos).clear(v.mMatrixpos);
            }
        }
        this.mTableaux.remove(v.mMatrixpos);
        this.mDependentRows.remove(v.mMatrixpos);
    }

    private void unsimplifyAndAdd(LinVar lv, Rational fac, Map<LinVar, Rational> facs) {
        if (lv.mBasic) {
            TableauxRow row = this.mTableaux.get(lv.mMatrixpos);
            BigInteger denom = row.getRawCoeff(0).negate();
            for (int i = 1; i < row.size(); ++i) {
                Rational coeff = Rational.valueOf(row.getRawCoeff(i), denom);
                this.unsimplifyAndAdd((LinVar)this.mLinvars.get(row.getRawIndex(i)), fac.mul(coeff), facs);
            }
        } else {
            Rational oldval = facs.get(lv);
            if (oldval == null) {
                facs.put(lv, fac);
            } else {
                Rational newval = oldval.add(fac);
                if (newval.equals(Rational.ZERO)) {
                    facs.remove(lv);
                } else {
                    facs.put(lv, newval);
                }
            }
        }
    }

    private ExactInfinitesimalNumber[] freedom(LinVar var) {
        ExactInfinitesimalNumber value = var.getValue();
        ExactInfinitesimalNumber min = value.isub(var.getLowerBound());
        ExactInfinitesimalNumber max = value.isub(var.getUpperBound());
        for (MatrixEntry me : var.getTableauxColumn(this)) {
            assert (min.signum() <= 0 && max.signum() >= 0);
            LinVar rowVar = me.getRow();
            Rational coeff = Rational.valueOf(me.getHeadCoeff().negate(), me.getCoeff());
            ExactInfinitesimalNumber rowvalue = rowVar.getValue();
            ExactInfinitesimalNumber below = rowvalue.isub(rowVar.getLowerBound()).mul(coeff);
            ExactInfinitesimalNumber above = rowvalue.isub(rowVar.getUpperBound()).mul(coeff);
            if (coeff.isNegative()) {
                assert (below.signum() >= 0 && above.signum() <= 0);
                if (below.compareTo(max) < 0) {
                    max = below;
                }
                if (above.compareTo(min) <= 0) continue;
                min = above;
                continue;
            }
            assert (below.signum() <= 0 && above.signum() >= 0);
            if (above.compareTo(max) < 0) {
                max = above;
            }
            if (below.compareTo(min) <= 0) continue;
            min = below;
        }
        assert (min.signum() <= 0 && max.signum() >= 0);
        return new ExactInfinitesimalNumber[]{min, max};
    }

    private void mutate() {
        TreeMap<Rational, Set<ExactInfinitesimalNumber>> sharedPoints = new TreeMap<Rational, Set<ExactInfinitesimalNumber>>();
        TreeSet<ExactInfinitesimalNumber> prohib = new TreeSet<ExactInfinitesimalNumber>();
        for (LinVar mutatingLV : this.mLinvars) {
            ExactInfinitesimalNumber[] lowerupper;
            if (mutatingLV.mBasic || mutatingLV.getTightUpperBound().equals(mutatingLV.getTightLowerBound()) || (lowerupper = this.freedom(mutatingLV))[0].equals(lowerupper[1])) continue;
            Rational gcd = mutatingLV.isInt() ? Rational.ONE : Rational.ZERO;
            ExactInfinitesimalNumber exactval = mutatingLV.getValue();
            sharedPoints.clear();
            prohib.clear();
            if (mutatingLV.mDisequalities != null) {
                for (Rational rational : mutatingLV.mDisequalities.keySet()) {
                    prohib.add(new ExactInfinitesimalNumber(rational).sub(exactval));
                }
            }
            HashMap<LinVar, Rational> basicFactors = new HashMap<LinVar, Rational>();
            if (!mutatingLV.isInitiallyBasic()) {
                basicFactors.put(mutatingLV, Rational.ONE);
            }
            for (MatrixEntry it1 : mutatingLV.getTableauxColumn(this)) {
                LinVar basic = it1.getRow();
                Rational coeff = Rational.valueOf(it1.getCoeff().negate(), it1.getHeadCoeff());
                if (!basic.isInitiallyBasic()) {
                    basicFactors.put(basic, coeff);
                }
                if (basic.isInt()) {
                    gcd = gcd.gcd(coeff.abs());
                }
                if (basic.mDisequalities == null) continue;
                for (Rational rational : basic.mDisequalities.keySet()) {
                    ExactInfinitesimalNumber basicval = basic.getValue();
                    prohib.add(new ExactInfinitesimalNumber(rational).sub(basicval).div(coeff));
                }
            }
            for (LASharedTerm sharedVar : this.mSharedVars) {
                Rational sharedCoeff = Rational.ZERO;
                ExactInfinitesimalNumber sharedCurVal = new ExactInfinitesimalNumber(sharedVar.getOffset(), Rational.ZERO);
                for (Map.Entry entry : sharedVar.getSummands().entrySet()) {
                    LinVar lv = (LinVar)entry.getKey();
                    Rational factor = (Rational)entry.getValue();
                    if (basicFactors.containsKey(lv)) {
                        sharedCoeff = sharedCoeff.addmul((Rational)basicFactors.get(lv), factor);
                    }
                    sharedCurVal = sharedCurVal.add(lv.getValue().mul(factor));
                }
                TreeSet<ExactInfinitesimalNumber> set = (TreeSet<ExactInfinitesimalNumber>)sharedPoints.get(sharedCoeff);
                if (set == null) {
                    set = new TreeSet<ExactInfinitesimalNumber>();
                    sharedPoints.put(sharedCoeff, set);
                }
                set.add(sharedCurVal);
            }
            Rational rational = gcd.inverse();
            ExactInfinitesimalNumber chosen = this.choose(lowerupper[0], lowerupper[1], prohib, sharedPoints, rational);
            assert (chosen.compareTo(lowerupper[0]) >= 0 && chosen.compareTo(lowerupper[1]) <= 0);
            if (chosen.signum() == 0) continue;
            this.updateVariableValue(mutatingLV, mutatingLV.getValue().add(chosen));
        }
    }

    Map<ExactInfinitesimalNumber, List<LASharedTerm>> getSharedCongruences() {
        this.mClausifier.getLogger().debug("Shared Vars:");
        HashMap<ExactInfinitesimalNumber, List<LASharedTerm>> result = new HashMap<ExactInfinitesimalNumber, List<LASharedTerm>>();
        for (LASharedTerm shared : this.mSharedVars) {
            ExactInfinitesimalNumber value = new ExactInfinitesimalNumber(shared.getOffset());
            for (Map.Entry<LinVar, Rational> entry : shared.getSummands().entrySet()) {
                LinVar lv = entry.getKey();
                Rational factor = entry.getValue();
                value = value.add(lv.getValue().mul(factor));
            }
            this.mClausifier.getLogger().debug("%s = %s", shared, value);
            LinkedList<LASharedTerm> slot = (LinkedList<LASharedTerm>)result.get(value);
            if (slot == null) {
                slot = new LinkedList<LASharedTerm>();
                result.put(value, slot);
            }
            slot.add(shared);
        }
        return result;
    }

    private Literal ensureDisequality(LAEquality eq) {
        boolean usegt;
        LinVar v = eq.getVar();
        assert (eq.getDecideStatus().getSign() == -1);
        ExactInfinitesimalNumber value = v.getValue();
        if (!value.getRealValue().equals(eq.getBound()) || value.getEpsilon().signum() != 0) {
            return null;
        }
        InfinitesimalNumber bound = new InfinitesimalNumber(eq.getBound(), 0);
        BoundConstraint gbc = (BoundConstraint)eq.getVar().mConstraints.get(bound);
        boolean bl = usegt = gbc == null;
        if (!usegt && gbc.getDecideStatus() == null) {
            return gbc.negate();
        }
        InfinitesimalNumber strictbound = bound.sub(eq.getVar().getEpsilon());
        BoundConstraint lbc = (BoundConstraint)eq.getVar().mConstraints.get(strictbound);
        if (lbc != null && lbc.getDecideStatus() == null) {
            return lbc;
        }
        return usegt ? this.generateConstraint(eq.getVar(), eq.getBound(), false, false).negate() : this.generateConstraint(eq.getVar(), eq.getBound(), false, true);
    }

    private ExactInfinitesimalNumber choose(ExactInfinitesimalNumber lower, ExactInfinitesimalNumber upper, Set<ExactInfinitesimalNumber> prohibitions, Map<Rational, Set<ExactInfinitesimalNumber>> sharedPoints, Rational lcm) {
        ExactInfinitesimalNumber zero = ExactInfinitesimalNumber.ZERO;
        if (upper.equals(lower) || !prohibitions.contains(zero) && !this.hasSharing(sharedPoints, zero)) {
            return zero;
        }
        if (lcm == Rational.POSITIVE_INFINITY) {
            if (lower.getRealValue().equals(upper.getRealValue())) {
                ExactInfinitesimalNumber curDiff = (upper.signum() > 0 ? upper : lower).div(Rational.TWO);
                assert (curDiff.signum() != 0 && lower.compareTo(curDiff) < 0 && curDiff.compareTo(upper) < 0);
                while (prohibitions.contains(curDiff) || this.hasSharing(sharedPoints, curDiff)) {
                    curDiff = curDiff.div(Rational.TWO);
                }
                return curDiff;
            }
            ExactInfinitesimalNumber step = upper.getRealValue().signum() > 0 ? new ExactInfinitesimalNumber(Rational.ZERO, Rational.ONE) : new ExactInfinitesimalNumber(Rational.ZERO, Rational.MONE);
            ExactInfinitesimalNumber curDiff = step;
            while (prohibitions.contains(curDiff) || this.hasSharing(sharedPoints, curDiff)) {
                curDiff = curDiff.add(step);
            }
            return curDiff;
        }
        ExactInfinitesimalNumber up = new ExactInfinitesimalNumber(lcm);
        ExactInfinitesimalNumber down = up.negate();
        boolean searchUp = true;
        boolean searchDown = true;
        while (searchUp || searchDown) {
            if (searchUp) {
                if (up.compareTo(upper) > 0) {
                    searchUp = false;
                } else if (!prohibitions.contains(up) && !this.hasSharing(sharedPoints, up)) {
                    return up;
                }
                up = up.add(lcm);
            }
            if (!searchDown) continue;
            if (down.compareTo(lower) < 0) {
                searchDown = false;
            } else if (!prohibitions.contains(down) && !this.hasSharing(sharedPoints, down)) {
                return down;
            }
            down = down.add(lcm.negate());
        }
        return ExactInfinitesimalNumber.ZERO;
    }

    private boolean hasSharing(Map<Rational, Set<ExactInfinitesimalNumber>> sharedPoints, ExactInfinitesimalNumber diff) {
        TreeSet<ExactInfinitesimalNumber> used = new TreeSet<ExactInfinitesimalNumber>();
        for (Map.Entry<Rational, Set<ExactInfinitesimalNumber>> entry : sharedPoints.entrySet()) {
            ExactInfinitesimalNumber sharedDiff = diff.mul(entry.getKey());
            for (ExactInfinitesimalNumber r : entry.getValue()) {
                if (used.add(r.add(sharedDiff))) continue;
                return true;
            }
        }
        return false;
    }

    private Clause mbtc(Map<ExactInfinitesimalNumber, List<LASharedTerm>> cong) {
        for (Map.Entry<ExactInfinitesimalNumber, List<LASharedTerm>> congclass : cong.entrySet()) {
            List<LASharedTerm> lcongclass = congclass.getValue();
            if (lcongclass.size() <= 1) continue;
            this.mClausifier.getLogger().debug("propagating MBTC: %s", lcongclass);
            Iterator<LASharedTerm> it = lcongclass.iterator();
            LASharedTerm shared1 = it.next();
            LASharedTerm shared1OtherSort = null;
            while (it.hasNext()) {
                LASharedTerm shared2 = it.next();
                Term lhs = shared1.getTerm();
                Term rhs = shared2.getTerm();
                if (lhs.getSort() != rhs.getSort()) {
                    if (shared1OtherSort == null) {
                        shared1OtherSort = shared2;
                        continue;
                    }
                    lhs = shared1OtherSort.getTerm();
                }
                assert (lhs.getSort() == rhs.getSort());
                EqualityProxy eq = this.mClausifier.createEqualityProxy(lhs, rhs, null);
                assert (eq != EqualityProxy.getTrueProxy());
                assert (eq != EqualityProxy.getFalseProxy());
                CCEquality cceq = eq.createCCEquality(lhs, rhs);
                if (cceq.getLASharedData().getDecideStatus() != null) {
                    if (cceq.getDecideStatus() == cceq.negate()) {
                        return this.generateEqualityClause(cceq);
                    }
                    if (cceq.getDecideStatus() == null) {
                        this.mProplist.add(cceq);
                        continue;
                    }
                    this.mClausifier.getLogger().debug("already set: %s", cceq.getAtom().getDecideStatus());
                    continue;
                }
                this.mClausifier.getLogger().debug("MBTC: Suggesting literal %s", cceq);
                this.mSuggestions.add(cceq.getLASharedData());
            }
        }
        return null;
    }

    @Override
    public Literal getSuggestion() {
        Literal res;
        do {
            if (!this.mSuggestions.isEmpty()) continue;
            return null;
        } while ((res = this.mSuggestions.removeFirst()).getAtom().getDecideStatus() != null);
        return res;
    }

    private InfinitesimalNumber computeMaxEpsilon(Set<Rational> prohibitions) {
        InfinitesimalNumber maxeps = InfinitesimalNumber.POSITIVE_INFINITY;
        for (LinVar v : this.mLinvars) {
            InfinitesimalNumber diff;
            ExactInfinitesimalNumber value = v.getValue();
            if (value.getEpsilon().signum() > 0) {
                diff = v.getUpperBound().sub(new InfinitesimalNumber(value.getRealValue(), 0)).div(value.getEpsilon());
                if (diff.compareTo(maxeps) < 0) {
                    maxeps = diff;
                }
            } else if (value.getEpsilon().signum() < 0 && (diff = v.getLowerBound().sub(new InfinitesimalNumber(value.getRealValue(), 0)).div(value.getEpsilon())).compareTo(maxeps) < 0) {
                maxeps = diff;
            }
            if (value.getEpsilon().signum() == 0 || v.mDisequalities == null) continue;
            for (Rational prohib : v.mDisequalities.keySet()) {
                prohibitions.add(prohib.sub(value.getRealValue()).div(value.getEpsilon()));
            }
        }
        return maxeps;
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void restart(int iteration) {
    }

    public LAEquality createEquality(MutableAffineTerm at) {
        InfinitesimalNumber bound;
        Rational normFactor = at.getGCD().inverse();
        at.mul(normFactor);
        LinVar var = this.generateLinVar(this.getSummandMap(at));
        if (at.mSummands.size() == 1) {
            Rational fac = at.mSummands.values().iterator().next();
            bound = at.mConstant.negate().div(fac);
        } else {
            bound = at.mConstant.negate();
        }
        assert (bound.mEps == 0);
        LAEquality sharedData = var.getEquality(bound);
        if (sharedData == null) {
            sharedData = new LAEquality(this.mClausifier.getStackLevel(), var, bound.mReal);
            this.getEngine().addAtom(sharedData);
            var.addEquality(sharedData);
        }
        return sharedData;
    }

    @Override
    public Clause startCheck() {
        this.mEps = null;
        this.mInCheck = true;
        return null;
    }

    @Override
    public void endCheck() {
        this.mInCheck = false;
    }

    public Literal createCompositeLiteral(LAReason comp, Literal beforeLit) {
        InfinitesimalNumber litBound;
        ++this.mCompositeCreateLit;
        int depth = comp.getLastLiteral().getDecideLevel();
        if (this.mClausifier.getLogger().isDebugEnabled()) {
            this.mClausifier.getLogger().debug("Create Propagated Literal for " + comp + " @ level " + depth);
        }
        LinVar var = comp.getVar();
        InfinitesimalNumber bound = comp.getBound();
        if (!comp.isUpper()) {
            bound = bound.sub(var.getEpsilon());
        }
        BoundConstraint bc = new BoundConstraint(bound, var, this.mClausifier.getStackLevel());
        Literal lit = comp.isUpper() ? bc : bc.negate();
        int decideLevel = comp.getLastLiteral().getDecideLevel();
        if (beforeLit != null && beforeLit.getAtom().getDecideLevel() == decideLevel) {
            this.getEngine().insertPropagatedLiteralBefore(this, lit, beforeLit);
        } else {
            this.getEngine().insertPropagatedLiteral(this, lit, decideLevel);
        }
        InfinitesimalNumber infinitesimalNumber = litBound = comp.isUpper() ? bc.getBound() : bc.getInverseBound();
        if (!comp.getExactBound().equals(litBound)) {
            this.insertReasonOfNewComposite(var, lit);
        }
        return lit;
    }

    public void addSharedTerm(LASharedTerm sharedTerm) {
        assert (!this.mSharedVars.contains(sharedTerm));
        this.mSharedVars.add(sharedTerm);
        this.getLogger().info("LAShare %s", sharedTerm.getTerm());
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
        if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            LinVar v = bc.getVar();
            v.mConstraints.remove(bc.getBound());
        } else if (atom instanceof LAEquality) {
            LAEquality laeq = (LAEquality)atom;
            InfinitesimalNumber num = new InfinitesimalNumber(laeq.getBound(), 0);
            laeq.getVar().mEqualities.remove(num);
            for (CCEquality eq : laeq.getDependentEqualities()) {
                eq.removeLASharedData();
            }
        }
    }

    @Override
    public void pop() {
        int prevVarNum = this.mLinvars.getLastScopeSize();
        for (int i = this.mLinvars.size() - 1; i >= prevVarNum; --i) {
            LinVar var = (LinVar)this.mLinvars.get(i);
            if (var == this.mConflictVar) {
                this.mConflictVar = null;
            }
            this.removeLinVar(var);
            this.mDirty.clear(i);
            this.mOob.remove(var);
            var.mAssertionstacklevel = -1;
            if (!var.isInt()) continue;
            this.mIntVars.remove(var);
        }
        this.mLinvars.endScope();
        this.mSharedVars.endScope();
        this.mBasics.endScope();
        this.mSuggestions.clear();
        this.mProplist.clear();
        assert (this.popPost());
    }

    private final boolean popPost() {
        return true;
    }

    @Override
    public void push() {
        this.mBasics.beginScope();
        this.mSharedVars.beginScope();
        this.mLinvars.beginScope();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":LA", new Object[][]{{"Pivot", this.mNumPivots}, {"PivotBland", this.mNumPivotsBland}, {"Vars", this.mLinvars.size()}, {"CompLits", this.mCompositeCreateLit}, {"Cuts", this.mNumCuts}, {"Branches", this.mNumBranches}, {"GetUpperBound", this.mCountGetUpperBound}, {"Times", new Object[][]{{"Pivot", this.mPivotTime / 1000000L}, {"Fix", this.mFixTime / 1000000L}, {"BoundComp", this.mPropBoundTime / 1000000L}, {"BoundSet", this.mPropBoundSetTime / 1000000L}, {"BoundBack", this.mBacktrackPropTime / 1000000L}, {"CutGen", this.mCutGenTime / 1000000L}, {"GetUpperBound", this.mTimeGetUpperBound / 1000000L}}}}};
    }

    private FunctionSymbol getsValueFromLA(Term term) {
        ApplicationTerm at;
        if (term instanceof ApplicationTerm && (at = (ApplicationTerm)term).getParameters().length == 0) {
            return at.getFunction();
        }
        return null;
    }

    public void fillInModel(Model model, Theory t, SharedTermEvaluator ste) {
        this.prepareModel();
        for (LinVar var : this.mLinvars) {
            Term term;
            FunctionSymbol fsym;
            if (var.isInitiallyBasic() || (fsym = this.getsValueFromLA(term = var.getTerm())) == null) continue;
            Term value = this.realValue(var).toTerm(term.getSort());
            NumericSortInterpretation si = (NumericSortInterpretation)model.provideSortInterpretation(term.getSort());
            si.register(value);
            model.map(fsym, value);
        }
    }

    public InfinitesimalNumber getUpperBound(Clausifier clausifier, SMTAffineTerm smtTerm) {
        if (smtTerm.isConstant()) {
            return new InfinitesimalNumber(smtTerm.getConstant(), 0);
        }
        MutableAffineTerm at = new MutableAffineTerm();
        for (Map.Entry<Term, Rational> entry : smtTerm.getSummands().entrySet()) {
            LASharedTerm laShared = clausifier.getLATerm(entry.getKey());
            Rational coeff = entry.getValue();
            if (laShared != null) {
                assert (laShared.getSummands().size() == 1 && laShared.getOffset() == Rational.ZERO && laShared.getSummands().values().iterator().next() == Rational.ONE);
                at.add(coeff, laShared.getSummands().keySet().iterator().next());
                continue;
            }
            return InfinitesimalNumber.POSITIVE_INFINITY;
        }
        at.add(smtTerm.getConstant());
        return this.getUpperBound(at);
    }

    public InfinitesimalNumber getUpperBound(MutableAffineTerm at) {
        long start = System.nanoTime();
        ++this.mCountGetUpperBound;
        if (at.isConstant()) {
            this.mTimeGetUpperBound += System.nanoTime() - start;
            return at.getConstant();
        }
        InfinitesimalNumber offset = at.getConstant();
        Rational normFactor = at.getGCD();
        MutableAffineTerm atNormalized = new MutableAffineTerm();
        atNormalized.add(normFactor.inverse(), at);
        LinVar var = this.generateLinVar(atNormalized.getSummands());
        InfinitesimalNumber bound = normFactor.signum() > 0 ? var.getTightUpperBound() : var.getTightLowerBound();
        this.mTimeGetUpperBound += System.nanoTime() - start;
        return bound.mul(normFactor).add(offset);
    }
}

