/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayMap;
import java.math.BigInteger;
import java.util.Map;

public class LinTerm
extends ArrayMap<LinVar, BigInteger> {
    LinTerm(LinVar[] vars, BigInteger[] coeffs) {
        super(vars, coeffs);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : this.entrySet()) {
            LinVar var = (LinVar)entry.getKey();
            BigInteger fact = (BigInteger)entry.getValue();
            if (fact.signum() == -1) {
                sb.append(isFirst ? "-" : " - ");
            } else {
                sb.append(isFirst ? "" : " + ");
            }
            fact = fact.abs();
            if (!fact.equals(BigInteger.ONE)) {
                sb.append(fact).append('*');
            }
            sb.append(var);
            isFirst = false;
        }
        return sb.toString();
    }
}

