/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.TableauxRow;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LinVar
implements Comparable<LinVar> {
    Object mName;
    LiteralReason mUpperLiteral;
    LiteralReason mLowerLiteral;
    LAReason mUpper;
    LAReason mLower;
    private ExactInfinitesimalNumber mCurval;
    boolean mIsInt;
    NavigableMap<InfinitesimalNumber, BoundConstraint> mConstraints = new TreeMap<InfinitesimalNumber, BoundConstraint>();
    NavigableMap<InfinitesimalNumber, LAEquality> mEqualities = new TreeMap<InfinitesimalNumber, LAEquality>();
    Map<Rational, LAEquality> mDisequalities;
    boolean mBasic;
    final int mMatrixpos;
    LinVar[] mCachedRowVars;
    Rational[] mCachedRowCoeffs;
    int mAssertionstacklevel;
    ExactInfinitesimalNumber mExactVal = null;
    static final LinVar DUMMY_LINVAR = new LinVar();

    private LinVar() {
        this.mName = "Dummy";
        this.mMatrixpos = Integer.MAX_VALUE;
    }

    public LinVar(Object name, boolean isint, int assertionstacklevel, int num) {
        this.mName = name;
        this.mCurval = ExactInfinitesimalNumber.ZERO;
        this.mIsInt = isint;
        this.mBasic = false;
        this.mMatrixpos = num;
        this.mAssertionstacklevel = assertionstacklevel;
    }

    public final InfinitesimalNumber getUpperBound() {
        return this.mUpperLiteral == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpperLiteral.getBound();
    }

    public final InfinitesimalNumber getLowerBound() {
        return this.mLowerLiteral == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLowerLiteral.getBound();
    }

    public final InfinitesimalNumber getTightUpperBound() {
        return this.mUpper == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpper.getBound();
    }

    public final InfinitesimalNumber getTightLowerBound() {
        return this.mLower == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLower.getBound();
    }

    public InfinitesimalNumber getExactUpperBound() {
        return this.mUpper == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpper.getExactBound();
    }

    public InfinitesimalNumber getExactLowerBound() {
        return this.mLower == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLower.getExactBound();
    }

    public final boolean hasTightUpperBound() {
        return this.mUpper != null;
    }

    public final boolean hasTightLowerBound() {
        return this.mLower != null;
    }

    public String toString() {
        return this.mName.toString();
    }

    public boolean isInitiallyBasic() {
        return this.mName instanceof LinTerm;
    }

    public int hashCode() {
        return this.mMatrixpos;
    }

    @Override
    public final int compareTo(LinVar o) {
        return this.mMatrixpos - o.mMatrixpos;
    }

    public boolean outOfBounds() {
        if (this.mUpperLiteral != null && this.mCurval.compareTo(this.mUpperLiteral.getBound()) > 0) {
            return true;
        }
        return this.mLowerLiteral != null && this.mCurval.compareTo(this.mLowerLiteral.getExactBound()) < 0;
    }

    void addDiseq(LAEquality ea) {
        if (this.mDisequalities == null) {
            this.mDisequalities = new HashMap<Rational, LAEquality>();
        }
        this.mDisequalities.put(ea.getBound(), ea);
    }

    void removeDiseq(LAEquality ea) {
        if (this.mDisequalities != null) {
            this.mDisequalities.remove(ea.getBound());
        }
    }

    LAEquality getDiseq(Rational bound) {
        if (this.mDisequalities != null) {
            return this.mDisequalities.get(bound);
        }
        return null;
    }

    public void addEquality(LAEquality ea) {
        this.mEqualities.put(new InfinitesimalNumber(ea.getBound(), 0), ea);
    }

    boolean unconstrained() {
        return this.mConstraints.isEmpty() && this.mEqualities.isEmpty();
    }

    boolean isCurrentlyUnconstrained() {
        return this.mLower == null && this.mUpper == null;
    }

    public boolean isInt() {
        return this.mIsInt;
    }

    public InfinitesimalNumber getEpsilon() {
        return this.mIsInt ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
    }

    public Map<LinVar, BigInteger> getLinTerm() {
        return (LinTerm)this.mName;
    }

    public Term getTerm() {
        return (Term)this.mName;
    }

    public boolean checkCoeffChain(LinArSolve solver) {
        if (!this.mBasic) {
            return true;
        }
        MutableAffineTerm mat = new MutableAffineTerm();
        BigInteger headCoeff = solver.mTableaux.get(this.mMatrixpos).getRawCoeff(0);
        mat.add(Rational.valueOf(headCoeff, BigInteger.ONE), this);
        for (MatrixEntry entry : this.getTableauxRow(solver)) {
            assert (entry.getRow() == this);
            assert (!entry.getColumn().mBasic);
            assert (solver.mDependentRows.get(entry.getColumn().mMatrixpos).get(this.mMatrixpos));
            mat.add(Rational.valueOf(entry.getCoeff(), BigInteger.ONE), entry.getColumn());
        }
        assert (mat.isConstant() && mat.getConstant().equals(InfinitesimalNumber.ZERO));
        return true;
    }

    public boolean isFixed() {
        return this.mUpper != null && this.mLower != null && this.mUpper.getBound().equals(this.mLower.getBound());
    }

    public LAEquality getEquality(InfinitesimalNumber bound) {
        return (LAEquality)this.mEqualities.get(bound);
    }

    public final ExactInfinitesimalNumber getValue() {
        return this.mCurval;
    }

    public final void setValue(ExactInfinitesimalNumber value) {
        this.mCurval = value;
    }

    public final void addValue(ExactInfinitesimalNumber value) {
        this.mCurval = this.mCurval.add(value);
    }

    private boolean checkReasonChain(LAReason reason, LiteralReason litreason) {
        while (reason != null) {
            if (reason instanceof LiteralReason) {
                assert (reason == litreason);
                litreason = litreason.getOldLiteralReason();
            }
            reason = reason.getOldReason();
        }
        assert (litreason == null);
        return true;
    }

    public boolean checkReasonChains() {
        return this.checkReasonChain(this.mUpper, this.mUpperLiteral) && this.checkReasonChain(this.mLower, this.mLowerLiteral);
    }

    public Iterable<MatrixEntry> getTableauxRow(final LinArSolve solver) {
        assert (this.mBasic);
        final TableauxRow row = solver.mTableaux.get(this.mMatrixpos);
        assert (row != null);
        return new Iterable<MatrixEntry>(){

            @Override
            public Iterator<MatrixEntry> iterator() {
                return new Iterator<MatrixEntry>(){
                    private int pos = 1;

                    @Override
                    public boolean hasNext() {
                        return this.pos < row.size();
                    }

                    @Override
                    public MatrixEntry next() {
                        return new MatrixEntry(solver, row, this.pos++);
                    }
                };
            }
        };
    }

    public Iterable<MatrixEntry> getTableauxColumn(final LinArSolve solver) {
        assert (!this.mBasic);
        final BitSet dependentRows = solver.mDependentRows.get(this.mMatrixpos);
        return new Iterable<MatrixEntry>(){

            @Override
            public Iterator<MatrixEntry> iterator() {
                return new Iterator<MatrixEntry>(){
                    private int mRowIdx;
                    {
                        this.mRowIdx = dependentRows.nextSetBit(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mRowIdx != -1;
                    }

                    @Override
                    public MatrixEntry next() {
                        TableauxRow row = solver.mTableaux.get(this.mRowIdx);
                        MatrixEntry result = new MatrixEntry(solver, row, row.findRawIndex(LinVar.this.mMatrixpos));
                        assert (result.getColumn() == LinVar.this);
                        this.mRowIdx = dependentRows.nextSetBit(this.mRowIdx + 1);
                        return result;
                    }
                };
            }
        };
    }
}

