/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.util.ArrayDeque;
import java.util.Collections;

public class LiteralReason
extends LAReason {
    private final Literal mLiteral;
    ArrayDeque<LAReason> mDependents;
    private LiteralReason mOldLiteralReason;

    public LiteralReason(LinVar var, LiteralReason oldLiteralReason, InfinitesimalNumber bound, boolean isUpper, Literal lit, LiteralReason lastLit) {
        super(var, bound, isUpper, lastLit);
        this.mOldLiteralReason = oldLiteralReason;
        this.mLiteral = lit;
    }

    public LiteralReason(LinVar var, LiteralReason oldLiteralReason, InfinitesimalNumber bound, boolean isUpper, Literal lit) {
        this(var, oldLiteralReason, bound, isUpper, lit, null);
    }

    public Literal getLiteral() {
        return this.mLiteral;
    }

    public void addDependent(LAReason reason) {
        assert (this.getLastLiteral() == this);
        if (this.mDependents == null) {
            this.mDependents = new ArrayDeque();
        }
        this.mDependents.addFirst(reason);
    }

    public Iterable<LAReason> getDependents() {
        if (this.mDependents == null) {
            return Collections.emptySet();
        }
        return this.mDependents;
    }

    @Override
    InfinitesimalNumber explain(Explainer explainer, InfinitesimalNumber slack, Rational factor) {
        if (!explainer.canExplainWith(this.mLiteral)) {
            assert (this.getBound().equals(this.getOldReason().getBound()));
            return this.getOldReason().explain(explainer, slack, factor);
        }
        assert (this.mLiteral.getAtom().getDecideStatus() == this.mLiteral);
        if (this.mLiteral.negate() instanceof LAEquality) {
            InfinitesimalNumber newSlack = slack.sub(this.getVar().getEpsilon());
            if (newSlack.compareTo(InfinitesimalNumber.ZERO) > 0) {
                return this.getOldReason().explain(explainer, newSlack, factor);
            }
            explainer.addEQAnnotation(this, factor);
            return slack;
        }
        explainer.addLiteral(this.mLiteral.negate(), factor);
        return slack;
    }

    public int getDecideLevel() {
        return this.getLiteral().getAtom().getDecideLevel();
    }

    public int getStackPosition() {
        return this.getLiteral().getAtom().getStackPosition();
    }

    public LiteralReason getOldLiteralReason() {
        return this.mOldLiteralReason;
    }

    public void setOldLiteralReason(LiteralReason reason) {
        this.mOldLiteralReason = reason;
    }
}

