/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MutableAffineTerm {
    TreeMap<LinVar, Rational> mSummands = new TreeMap();
    InfinitesimalNumber mConstant = InfinitesimalNumber.ZERO;

    public MutableAffineTerm add(Rational c) {
        this.mConstant = this.mConstant.add(new InfinitesimalNumber(c, 0));
        return this;
    }

    public MutableAffineTerm add(InfinitesimalNumber c) {
        this.mConstant = this.mConstant.add(c);
        return this;
    }

    public MutableAffineTerm add(Rational c, LinVar var) {
        if (c.equals(Rational.ZERO)) {
            return this;
        }
        if (var.isInitiallyBasic()) {
            for (Map.Entry<LinVar, BigInteger> me : var.getLinTerm().entrySet()) {
                this.add(c.mul(me.getValue()), me.getKey());
            }
        } else {
            this.addSimple(c, var);
        }
        return this;
    }

    private void addMap(Rational c, Map<LinVar, Rational> linterm) {
        for (Map.Entry<LinVar, Rational> summand : linterm.entrySet()) {
            this.addSimple(c.mul(summand.getValue()), summand.getKey());
        }
    }

    private void addSimple(Rational c, LinVar term) {
        assert (!c.equals(Rational.ZERO));
        Rational oldc = this.mSummands.remove(term);
        if (oldc != null && (c = oldc.add(c)).equals(Rational.ZERO)) {
            return;
        }
        this.mSummands.put(term, c);
    }

    public MutableAffineTerm add(Rational c, MutableAffineTerm a) {
        if (c != Rational.ZERO) {
            this.addMap(c, a.mSummands);
            this.mConstant = this.mConstant.add(a.mConstant.mul(c));
        }
        return this;
    }

    public MutableAffineTerm mul(Rational c) {
        if (c.equals(Rational.ZERO)) {
            this.mSummands.clear();
        } else if (!c.equals(Rational.ONE)) {
            for (Map.Entry<LinVar, Rational> summand : this.mSummands.entrySet()) {
                summand.setValue(c.mul(summand.getValue()));
            }
            this.mConstant = this.mConstant.mul(c);
        }
        return this;
    }

    public MutableAffineTerm div(Rational c) {
        return this.mul(c.inverse());
    }

    public MutableAffineTerm negate() {
        return this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public InfinitesimalNumber getConstant() {
        return this.mConstant;
    }

    public TreeMap<LinVar, Rational> getSummands() {
        return this.mSummands;
    }

    public Rational getGCD() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> it = this.mSummands.values().iterator();
        Rational gcd = it.next();
        boolean firstSign = gcd.isNegative();
        gcd = gcd.abs();
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next().abs());
        }
        if (firstSign) {
            gcd = gcd.negate();
        }
        return gcd;
    }

    void normalize() {
        this.mul(this.getGCD().inverse());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<LinVar, Rational> entry : this.mSummands.entrySet()) {
            LinVar var = entry.getKey();
            Rational fact = entry.getValue();
            if (fact.isNegative()) {
                sb.append(isFirst ? "-" : " - ");
            } else {
                sb.append(isFirst ? "" : " + ");
            }
            fact = fact.abs();
            if (!fact.equals(Rational.ONE)) {
                sb.append(fact).append('*');
            }
            sb.append(var);
            isFirst = false;
        }
        if (isFirst) {
            sb.append(this.mConstant);
        } else {
            int signum = this.mConstant.compareTo(InfinitesimalNumber.ZERO);
            if (signum < 0) {
                sb.append(" - ");
                sb.append(this.mConstant.mul(Rational.MONE));
            } else if (signum > 0) {
                sb.append(" + ");
                sb.append(this.mConstant);
            }
        }
        return sb.toString();
    }

    public Sort getSort(Theory t) {
        return this.isInt() ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
    }

    public Term toSMTLib(Theory t, boolean isInt) {
        Sort numSort;
        Sort sort = numSort = isInt ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        assert (numSort != null);
        Sort[] binfunc = new Sort[]{numSort, numSort};
        FunctionSymbol times = t.getFunction("*", binfunc);
        FunctionSymbol plus = t.getFunction("+", binfunc);
        FunctionSymbol negate = t.getFunction("-", numSort);
        if (negate == null) {
            negate = t.getFunction("-", numSort);
        }
        assert (!isInt || this.mConstant.mReal.isIntegral());
        Term constTerm = this.mConstant.mReal.equals(Rational.ZERO) ? null : this.mConstant.mReal.toTerm(numSort);
        Term[] terms = new Term[this.mSummands.size() + (constTerm == null ? 0 : 1)];
        if (constTerm != null) {
            terms[this.mSummands.size()] = constTerm;
        }
        int offset = 0;
        for (Map.Entry<LinVar, Rational> me : this.mSummands.entrySet()) {
            LinVar lv = me.getKey();
            Term convme = lv.getTerm();
            assert (!isInt || lv.isInt());
            assert (!isInt || me.getValue().isIntegral());
            if (!isInt && lv.isInt()) {
                Sort intSort = t.getSort("Int", new Sort[0]);
                FunctionSymbol toReal = t.getFunction("to_real", intSort);
                convme = t.term(toReal, convme);
            }
            if (!me.getValue().equals(Rational.ONE)) {
                Term convfac = me.getValue().toTerm(numSort);
                convme = t.term(times, convfac, convme);
            }
            terms[offset++] = convme;
        }
        if (terms.length == 0) {
            return Rational.ZERO.toTerm(numSort);
        }
        if (terms.length == 1) {
            return terms[0];
        }
        return t.term(plus, terms);
    }

    public boolean isInt() {
        for (LinVar v : this.mSummands.keySet()) {
            if (v.isInt()) continue;
            return false;
        }
        return true;
    }

    public Term toSMTLibLeq0(Theory smtTheory) {
        assert (this.mConstant.mEps >= 0);
        if (this.isConstant()) {
            return this.mConstant.compareTo(InfinitesimalNumber.ZERO) <= 0 ? smtTheory.mTrue : smtTheory.mFalse;
        }
        boolean isInt = this.isInt();
        Sort sort = smtTheory.getSort(isInt ? "Int" : "Real", new Sort[0]);
        String comp = this.mConstant.mEps == 0 ? "<=" : "<";
        Term zero = Rational.ZERO.toTerm(sort);
        return smtTheory.term(comp, this.toSMTLib(smtTheory, isInt), zero);
    }
}

