/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SOIPivoter {
    LinArSolve mSolver;
    ArrayList<LiteralReason> mOOBs;
    SortedMap<LinVar, Rational> mSOIVar;
    ExactInfinitesimalNumber mSOIValue;
    FreedomLimiter mBestLimiter;

    public SOIPivoter(LinArSolve solver) {
        this.mSolver = solver;
    }

    public boolean computeSOI() {
        boolean isOOB = false;
        this.mSOIValue = ExactInfinitesimalNumber.ZERO;
        this.mSOIVar = new TreeMap<LinVar, Rational>();
        this.mOOBs = new ArrayList();
        for (LinVar var : this.mSolver.mLinvars) {
            Rational coeff;
            LinVar colVar;
            boolean isUpper;
            ExactInfinitesimalNumber diff = var.getValue().isub(var.getLowerBound());
            if (diff.signum() > 0) {
                isUpper = false;
            } else {
                diff = var.getValue().isub(var.getUpperBound()).negate();
                if (diff.signum() <= 0) continue;
                isUpper = true;
            }
            assert (var.mBasic);
            isOOB = true;
            this.mOOBs.add(isUpper ? var.mUpperLiteral : var.mLowerLiteral);
            this.mSOIValue = this.mSOIValue.add(diff);
            BigInteger divisor = this.mSolver.mTableaux.get(var.mMatrixpos).getRawCoeff(0);
            if (isUpper) {
                divisor = divisor.negate();
            }
            boolean isConflicting = true;
            for (MatrixEntry entry : var.getTableauxRow(this.mSolver)) {
                Rational oldValue;
                LiteralReason reason;
                colVar = entry.getColumn();
                coeff = Rational.valueOf(entry.getCoeff(), divisor);
                LiteralReason literalReason = reason = coeff.signum() < 0 ? colVar.mUpperLiteral : colVar.mLowerLiteral;
                if (reason == null || !colVar.getValue().equals(reason.getBound())) {
                    isConflicting = false;
                }
                if ((oldValue = (Rational)this.mSOIVar.get(colVar)) != null) {
                    coeff = coeff.add(oldValue);
                }
                this.mSOIVar.put(colVar, coeff);
            }
            if (!isConflicting) continue;
            this.mOOBs.clear();
            this.mOOBs.add(isUpper ? var.mUpperLiteral : var.mLowerLiteral);
            this.mSOIValue = diff;
            this.mSOIVar.clear();
            for (MatrixEntry entry : var.getTableauxRow(this.mSolver)) {
                colVar = entry.getColumn();
                coeff = Rational.valueOf(entry.getCoeff(), divisor);
                this.mSOIVar.put(colVar, coeff);
            }
            return true;
        }
        return isOOB;
    }

    public boolean checkZeroFreedom() {
        boolean firstColumn = true;
        this.mBestLimiter = null;
        block0: for (Map.Entry<LinVar, Rational> entry : this.mSOIVar.entrySet()) {
            LinVar colVar = entry.getKey();
            Rational coeff = entry.getValue();
            if (coeff.signum() == 0 || colVar.getValue().equals(coeff.signum() < 0 ? colVar.getUpperBound() : colVar.getLowerBound())) continue;
            for (MatrixEntry me : colVar.getTableauxColumn(this.mSolver)) {
                LinVar rowVar = me.getRow();
                Rational weight = Rational.valueOf(me.getCoeff(), me.getHeadCoeff().negate());
                LiteralReason bound = weight.signum() == coeff.signum() ? rowVar.mLowerLiteral : rowVar.mUpperLiteral;
                if (bound == null || !rowVar.getValue().equals(new ExactInfinitesimalNumber(bound.getBound()))) continue;
                if (firstColumn && (this.mBestLimiter == null || this.mBestLimiter.getRowVar().compareTo(rowVar) > 0)) {
                    this.mBestLimiter = new FreedomLimiter(ExactInfinitesimalNumber.ZERO, weight, bound.getBound(), rowVar, colVar);
                }
                if (weight.signum() == coeff.signum()) {
                    weight.negate();
                }
                if ((coeff = coeff.add(weight)).signum() == -weight.signum()) continue;
                firstColumn = false;
                continue block0;
            }
            this.mBestLimiter = null;
            return false;
        }
        assert (firstColumn || this.mBestLimiter != null);
        return true;
    }

    public boolean findPivot() {
        ExactInfinitesimalNumber bestDiff = new ExactInfinitesimalNumber(Rational.MONE);
        this.mBestLimiter = null;
        for (Map.Entry<LinVar, Rational> entry : this.mSOIVar.entrySet()) {
            InfinitesimalNumber colBound;
            LinVar colVar = entry.getKey();
            Rational coeff = entry.getValue();
            if (coeff.signum() == 0) continue;
            InfinitesimalNumber infinitesimalNumber = colBound = coeff.signum() < 0 ? colVar.getUpperBound() : colVar.getLowerBound();
            if (colVar.getValue().equals(colBound)) continue;
            TreeMap<Object, FreedomLimiter> bounds = new TreeMap<Object, FreedomLimiter>();
            if (!colBound.isInfinity()) {
                ExactInfinitesimalNumber colFreedom = colVar.getValue().isub(colBound).abs();
                bounds.put(colFreedom, new FreedomLimiter(colFreedom, Rational.ONE, colBound, colVar, colVar));
            }
            for (MatrixEntry me : colVar.getTableauxColumn(this.mSolver)) {
                FreedomLimiter prev;
                ExactInfinitesimalNumber freedom;
                ExactInfinitesimalNumber diff;
                InfinitesimalNumber bound;
                LinVar rowVar = me.getRow();
                Rational weight = Rational.valueOf(me.getCoeff(), me.getHeadCoeff());
                if (coeff.signum() < 0) {
                    weight = weight.negate();
                }
                if (rowVar.mLowerLiteral != null) {
                    bound = rowVar.mLowerLiteral.getBound();
                    diff = rowVar.getValue().isub(bound);
                    if (weight.signum() * (2 * diff.signum() - 1) > 0) {
                        freedom = diff.div(weight);
                        assert (freedom.signum() >= 0);
                        prev = (FreedomLimiter)bounds.get(freedom);
                        if (prev != null) {
                            prev.merge(weight, bound, rowVar);
                        } else {
                            bounds.put(freedom, new FreedomLimiter(freedom, weight, bound, rowVar, colVar));
                        }
                    }
                }
                if (rowVar.mUpperLiteral == null) continue;
                bound = rowVar.mUpperLiteral.getBound();
                diff = rowVar.getValue().isub(bound);
                if (weight.signum() * (2 * diff.signum() + 1) <= 0) continue;
                freedom = diff.div(weight);
                assert (freedom.signum() >= 0);
                prev = (FreedomLimiter)bounds.get(freedom);
                if (prev != null) {
                    prev.merge(weight, bound, rowVar);
                    continue;
                }
                bounds.put(freedom, new FreedomLimiter(freedom, weight, bound, rowVar, colVar));
            }
            Rational weight = coeff.abs();
            ExactInfinitesimalNumber lastFreedom = new ExactInfinitesimalNumber(Rational.ZERO);
            ExactInfinitesimalNumber soidiff = new ExactInfinitesimalNumber(Rational.ZERO);
            for (FreedomLimiter limiter : bounds.values()) {
                soidiff = soidiff.add(limiter.mFreedom.sub(lastFreedom).mul(weight));
                lastFreedom = limiter.mFreedom;
                if ((weight = weight.sub(limiter.getWeight())).signum() > 0) continue;
                if (bestDiff.compareTo(soidiff) >= 0) break;
                bestDiff = soidiff;
                this.mBestLimiter = limiter;
                if (!bestDiff.equals(this.mSOIValue)) break;
                this.mSolver.getLogger().debug("Solved it!", bestDiff);
                return true;
            }
            assert (weight.signum() <= 0);
        }
        this.mSolver.getLogger().debug("Best Candidate: (%s)", bestDiff);
        return this.mBestLimiter != null;
    }

    private boolean isRedundant(LiteralReason bound) {
        LinVar var = bound.getVar();
        BigInteger divisor = this.mSolver.mTableaux.get(var.mMatrixpos).getRawCoeff(0);
        if (!bound.isUpper()) {
            divisor = divisor.negate();
        }
        for (MatrixEntry entry : var.getTableauxRow(this.mSolver)) {
            InfinitesimalNumber colBound;
            LinVar colVar = entry.getColumn();
            Rational coeff = Rational.valueOf(entry.getCoeff(), divisor);
            Rational oldValue = (Rational)this.mSOIVar.get(colVar);
            if (oldValue != null) {
                coeff = coeff.add(oldValue);
            }
            InfinitesimalNumber infinitesimalNumber = colBound = coeff.signum() < 0 ? colVar.getUpperBound() : colVar.getLowerBound();
            if (colVar.getValue().equals(colBound)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Clause computeConflict() {
        assert (this.mSOIValue.signum() > 0);
        Iterator<LiteralReason> it = this.mOOBs.iterator();
        while (it.hasNext()) {
            LiteralReason bound = it.next();
            if (this.mOOBs.size() <= 1 || !this.isRedundant(bound)) continue;
            LinVar var = bound.getVar();
            this.mSOIValue = this.mSOIValue.sub(bound.getBound().sub(var.getValue()).abs());
            assert (this.mSOIValue.signum() > 0);
            BigInteger bigInteger = this.mSolver.mTableaux.get(var.mMatrixpos).getRawCoeff(0);
            if (!bound.isUpper()) {
                BigInteger bigInteger2 = bigInteger.negate();
            }
            for (MatrixEntry entry : var.getTableauxRow(this.mSolver)) {
                void var4_4;
                LinVar colVar = entry.getColumn();
                Rational coeff = Rational.valueOf(entry.getCoeff(), (BigInteger)var4_4);
                Rational oldValue = (Rational)this.mSOIVar.get(colVar);
                if (oldValue != null) {
                    coeff = coeff.add(oldValue);
                }
                this.mSOIVar.put(colVar, coeff);
            }
            it.remove();
        }
        Explainer explainer = new Explainer(this.mSolver, this.mSolver.getEngine().isProofGenerationEnabled(), null);
        InfinitesimalNumber slack = this.mSOIValue.roundToInfinitesimal();
        for (LiteralReason literalReason : this.mOOBs) {
            Rational factor;
            Rational rational = factor = literalReason.isUpper() ? Rational.ONE : Rational.MONE;
            assert (slack.signum() > 0);
            slack = literalReason.explain(explainer, slack, factor);
            assert (slack.signum() > 0);
        }
        for (Map.Entry entry : this.mSOIVar.entrySet()) {
            LiteralReason reason;
            LinVar colVar = (LinVar)entry.getKey();
            Rational coeff = (Rational)entry.getValue();
            if (coeff.signum() == 0) continue;
            LiteralReason literalReason = reason = coeff.signum() < 0 ? colVar.mUpperLiteral : colVar.mLowerLiteral;
            assert (colVar.getValue().equals(reason.getBound()));
            slack = slack.div(coeff.abs());
            assert (slack.signum() > 0);
            slack = reason.explain(explainer, slack, coeff.negate());
            assert (slack.signum() > 0);
            slack = slack.mul(coeff.abs());
        }
        assert (explainer.checkSlack(slack));
        return explainer.createClause(this.mSolver.getEngine());
    }

    public Clause fixOobs() {
        this.mSolver.getLogger().debug("=== fixoobs ===");
        while (this.computeSOI()) {
            if (this.mSolver.getLogger().isDebugEnabled()) {
                this.mSolver.getLogger().debug("SOI: %s.%04d", this.mSOIValue.getRealValue().floor(), this.mSOIValue.getRealValue().frac().mul(BigInteger.valueOf(10000L)).floor().numerator().intValue());
            }
            if (!this.findPivot()) {
                return this.computeConflict();
            }
            int blandPivotStep = 0;
            while (this.mBestLimiter.mFreedom.signum() == 0) {
                this.mSolver.pivot(this.mBestLimiter.getRowVar().mMatrixpos, this.mBestLimiter.getColumnVar().mMatrixpos);
                ++this.mSolver.mNumPivotsBland;
                ++blandPivotStep;
                this.computeSOI();
                if (this.checkZeroFreedom()) {
                    if (this.mBestLimiter != null) continue;
                    this.mSolver.getLogger().debug("Conflict after %d Bland pivot steps", blandPivotStep);
                    return this.computeConflict();
                }
                this.mSolver.getLogger().debug("Finished %d Bland pivot steps", blandPivotStep);
                this.findPivot();
                assert (this.mBestLimiter.mFreedom.signum() > 0);
            }
            if (this.mBestLimiter.getRowVar() != this.mBestLimiter.getColumnVar()) {
                this.mSolver.pivot(this.mBestLimiter.getRowVar().mMatrixpos, this.mBestLimiter.getColumnVar().mMatrixpos);
            }
            this.mSolver.updateVariableValue(this.mBestLimiter.getRowVar(), new ExactInfinitesimalNumber(this.mBestLimiter.mBound));
        }
        return null;
    }

    private static class FreedomLimiter {
        ExactInfinitesimalNumber mFreedom;
        Rational mWeight;
        InfinitesimalNumber mBound;
        LinVar mRow;
        LinVar mColumn;

        public FreedomLimiter(ExactInfinitesimalNumber freedom, Rational weight, InfinitesimalNumber bound, LinVar row, LinVar column) {
            assert (freedom.signum() >= 0);
            this.mFreedom = freedom;
            this.mWeight = weight.abs();
            this.mBound = bound;
            this.mRow = row;
            this.mColumn = column;
        }

        public void merge(Rational weight, InfinitesimalNumber bound, LinVar newRow) {
            this.mWeight = this.mWeight.add(weight.abs());
            if (this.mRow.compareTo(newRow) > 0) {
                this.mRow = newRow;
                this.mBound = bound;
            }
        }

        public Rational getWeight() {
            return this.mWeight;
        }

        public LinVar getRowVar() {
            return this.mRow;
        }

        public LinVar getColumnVar() {
            return this.mColumn;
        }

        public String toString() {
            return "Freedom[" + this.mFreedom + ",(" + this.getRowVar() + ")," + this.mWeight + "]";
        }
    }
}

