/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;

public class TableauxRow {
    static final int LIMIT_BITS = 30;
    static final int LIMIT = 0x40000000;
    static final int MARKER = 0x40000001;
    private int[] mEntries;
    private BigInteger[] mBigEntries;

    public TableauxRow(LinVar rowVar, SortedMap<LinVar, Rational> coeffs) {
        assert (!coeffs.containsKey(rowVar));
        assert (coeffs.size() >= 2);
        this.mEntries = new int[coeffs.size() * 2 + 2];
        Rational gcd = Rational.ONE;
        for (Rational c : coeffs.values()) {
            gcd = gcd.gcd(c);
        }
        ArrayList<BigInteger> bigInts = new ArrayList<BigInteger>();
        this.mEntries[0] = rowVar.mMatrixpos;
        this.mEntries[1] = TableauxRow.addBigInteger(bigInts, gcd.inverse().negate().numerator());
        int i = 2;
        for (Map.Entry<LinVar, Rational> entry : coeffs.entrySet()) {
            assert (entry.getValue().div(gcd).isIntegral());
            BigInteger coeff = entry.getValue().div(gcd).numerator();
            this.mEntries[i] = entry.getKey().mMatrixpos;
            this.mEntries[i + 1] = TableauxRow.addBigInteger(bigInts, coeff);
            i += 2;
        }
        if (bigInts.size() > 0) {
            this.mBigEntries = bigInts.toArray(new BigInteger[bigInts.size()]);
        }
    }

    private static int addBigInteger(ArrayList<BigInteger> bigInts, long coeff) {
        if (coeff >= -1073741824L && coeff < 0x40000000L) {
            return (int)coeff;
        }
        bigInts.add(BigInteger.valueOf(coeff));
        return 0x40000001 + bigInts.size() - 1;
    }

    private static int addBigInteger(ArrayList<BigInteger> bigInts, BigInteger coeff) {
        if (coeff.bitLength() <= 30) {
            return coeff.intValue();
        }
        bigInts.add(coeff);
        return 0x40000001 + bigInts.size() - 1;
    }

    public int findRawIndex(int matrixPos) {
        int low = 1;
        int high = this.size();
        while (low < high) {
            int mid = (low + high) / 2;
            if (this.mEntries[2 * mid] < matrixPos) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    private int findEntry(int matrixPos) {
        int idx = this.findRawIndex(matrixPos);
        return this.mEntries[2 * idx] == matrixPos ? this.mEntries[2 * idx + 1] : 0;
    }

    private BigInteger bigEntry(int entry) {
        return entry < 0x40000001 ? BigInteger.valueOf(entry) : this.mBigEntries[entry - 0x40000001];
    }

    private void addRowInt(LinArSolve solver, TableauxRow other) {
        int matrixPos = other.mEntries[0];
        assert (this.mBigEntries == null && other.mBigEntries == null);
        int myFactor = -other.mEntries[1];
        int otherFactor = this.findEntry(matrixPos);
        assert (otherFactor != 0);
        int gcdFactor = Rational.gcd(myFactor, otherFactor);
        myFactor /= gcdFactor;
        otherFactor /= gcdFactor;
        int[] newVars = new int[this.mEntries.length / 2 + other.mEntries.length / 2];
        long[] newCoeffs = new long[this.mEntries.length / 2 + other.mEntries.length / 2];
        int myIndex = 2;
        int otherIndex = 2;
        int newIndex = 1;
        newVars[0] = this.mEntries[0];
        newCoeffs[0] = (long)this.mEntries[1] * (long)myFactor;
        long gcd = newCoeffs[0];
        while (myIndex < this.mEntries.length || otherIndex < other.mEntries.length) {
            long newCoeff;
            if (otherIndex == other.mEntries.length || myIndex < this.mEntries.length && this.mEntries[myIndex] < other.mEntries[otherIndex]) {
                if (this.mEntries[myIndex] != matrixPos) {
                    newVars[newIndex] = this.mEntries[myIndex];
                    newCoeff = (long)this.mEntries[myIndex + 1] * (long)myFactor;
                    gcd = Rational.gcd(gcd, newCoeff);
                    newCoeffs[newIndex] = newCoeff;
                    ++newIndex;
                }
                myIndex += 2;
                continue;
            }
            if (myIndex == this.mEntries.length || this.mEntries[myIndex] > other.mEntries[otherIndex]) {
                solver.mDependentRows.get(other.mEntries[otherIndex]).set(this.mEntries[0]);
                newVars[newIndex] = other.mEntries[otherIndex];
                newCoeff = (long)other.mEntries[otherIndex + 1] * (long)otherFactor;
                gcd = Rational.gcd(gcd, newCoeff);
                newCoeffs[newIndex] = newCoeff;
                otherIndex += 2;
                ++newIndex;
                continue;
            }
            assert (this.mEntries[myIndex] == other.mEntries[otherIndex]);
            newCoeff = (long)this.mEntries[myIndex + 1] * (long)myFactor + (long)other.mEntries[otherIndex + 1] * (long)otherFactor;
            if (newCoeff != 0L) {
                newVars[newIndex] = this.mEntries[myIndex];
                gcd = Rational.gcd(gcd, newCoeff);
                newCoeffs[newIndex] = newCoeff;
                ++newIndex;
            } else {
                solver.mDependentRows.get(this.mEntries[myIndex]).clear(this.mEntries[0]);
            }
            myIndex += 2;
            otherIndex += 2;
        }
        int[] result = new int[2 * newIndex];
        ArrayList<BigInteger> bigInts = new ArrayList<BigInteger>();
        for (int i = 0; i < newIndex; ++i) {
            result[2 * i] = newVars[i];
            result[2 * i + 1] = TableauxRow.addBigInteger(bigInts, newCoeffs[i] / gcd);
            assert (result[2 * i + 1] >= -1073741824 && result[2 * i + 1] < 0x40000001 + bigInts.size());
        }
        this.mEntries = result;
        if (bigInts.size() > 0) {
            this.mBigEntries = bigInts.toArray(new BigInteger[bigInts.size()]);
        }
    }

    private void addRowBigInt(LinArSolve solver, TableauxRow other) {
        int matrixPos = other.mEntries[0];
        BigInteger myFactor = other.bigEntry(other.mEntries[1]).negate();
        BigInteger otherFactor = this.bigEntry(this.findEntry(matrixPos));
        assert (otherFactor.signum() != 0);
        BigInteger gcdFactor = Rational.gcd(myFactor, otherFactor);
        myFactor = myFactor.divide(gcdFactor);
        otherFactor = otherFactor.divide(gcdFactor);
        int[] newVars = new int[this.mEntries.length / 2 + other.mEntries.length / 2];
        BigInteger[] newCoeffs = new BigInteger[this.mEntries.length / 2 + other.mEntries.length / 2];
        int myIndex = 2;
        int otherIndex = 2;
        int newIndex = 1;
        newVars[0] = this.mEntries[0];
        newCoeffs[0] = this.bigEntry(this.mEntries[1]).multiply(myFactor);
        BigInteger gcd = newCoeffs[0];
        while (myIndex < this.mEntries.length || otherIndex < other.mEntries.length) {
            BigInteger newCoeff;
            if (otherIndex == other.mEntries.length || myIndex < this.mEntries.length && this.mEntries[myIndex] < other.mEntries[otherIndex]) {
                if (this.mEntries[myIndex] != matrixPos) {
                    newVars[newIndex] = this.mEntries[myIndex];
                    newCoeff = this.bigEntry(this.mEntries[myIndex + 1]).multiply(myFactor);
                    gcd = Rational.gcd(gcd, newCoeff);
                    newCoeffs[newIndex] = newCoeff;
                    ++newIndex;
                }
                myIndex += 2;
                continue;
            }
            if (myIndex == this.mEntries.length || this.mEntries[myIndex] > other.mEntries[otherIndex]) {
                solver.mDependentRows.get(other.mEntries[otherIndex]).set(this.mEntries[0]);
                newVars[newIndex] = other.mEntries[otherIndex];
                newCoeff = other.bigEntry(other.mEntries[otherIndex + 1]).multiply(otherFactor);
                gcd = Rational.gcd(gcd, newCoeff);
                newCoeffs[newIndex] = newCoeff;
                otherIndex += 2;
                ++newIndex;
                continue;
            }
            assert (this.mEntries[myIndex] == other.mEntries[otherIndex]);
            newCoeff = this.bigEntry(this.mEntries[myIndex + 1]).multiply(myFactor).add(other.bigEntry(other.mEntries[otherIndex + 1]).multiply(otherFactor));
            if (newCoeff.signum() != 0) {
                newVars[newIndex] = this.mEntries[myIndex];
                gcd = Rational.gcd(gcd, newCoeff);
                newCoeffs[newIndex] = newCoeff;
                ++newIndex;
            } else {
                solver.mDependentRows.get(this.mEntries[myIndex]).clear(this.mEntries[0]);
            }
            myIndex += 2;
            otherIndex += 2;
        }
        int[] result = new int[2 * newIndex];
        ArrayList<BigInteger> bigInts = new ArrayList<BigInteger>();
        for (int i = 0; i < newIndex; ++i) {
            result[2 * i] = newVars[i];
            BigInteger newCoeff = newCoeffs[i].divide(gcd);
            result[2 * i + 1] = TableauxRow.addBigInteger(bigInts, newCoeff);
            assert (result[2 * i + 1] >= -1073741824 && result[2 * i + 1] < 0x40000001 + bigInts.size());
        }
        this.mEntries = result;
        this.mBigEntries = bigInts.size() > 0 ? bigInts.toArray(new BigInteger[bigInts.size()]) : null;
    }

    public void addRow(LinArSolve solver, TableauxRow other) {
        if (this.mBigEntries == null && other.mBigEntries == null) {
            this.addRowInt(solver, other);
        } else {
            this.addRowBigInt(solver, other);
        }
    }

    public void swapRowCol(int oldColMatrixPos) {
        int oldRowMatrixPos = this.mEntries[0];
        int oldIdx = this.findRawIndex(oldColMatrixPos);
        int newIdx = this.findRawIndex(oldRowMatrixPos);
        assert (oldIdx >= 1);
        assert (this.mEntries[2 * oldIdx] == oldColMatrixPos);
        assert (2 * newIdx == this.mEntries.length || this.mEntries[2 * newIdx] > oldRowMatrixPos);
        assert (newIdx == 1 || this.mEntries[2 * (newIdx - 1)] < oldRowMatrixPos);
        int newHeadCoeff = this.mEntries[2 * oldIdx + 1];
        if (oldIdx < newIdx) {
            System.arraycopy(this.mEntries, 2 * oldIdx + 2, this.mEntries, 2 * oldIdx, 2 * (--newIdx - oldIdx));
        } else {
            System.arraycopy(this.mEntries, 2 * newIdx, this.mEntries, 2 * newIdx + 2, 2 * (oldIdx - newIdx));
        }
        this.mEntries[2 * newIdx] = oldRowMatrixPos;
        this.mEntries[2 * newIdx + 1] = this.mEntries[1];
        this.mEntries[0] = oldColMatrixPos;
        this.mEntries[1] = newHeadCoeff;
    }

    public BigInteger getCoeffForPos(int matrixPos) {
        return this.bigEntry(this.findEntry(matrixPos));
    }

    int getRawIndex(int idx) {
        return this.mEntries[2 * idx];
    }

    BigInteger getRawCoeff(int idx) {
        return this.bigEntry(this.mEntries[2 * idx + 1]);
    }

    int size() {
        return this.mEntries.length / 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRawCoeff(0)).append(" * y").append(this.getRawIndex(0));
        for (int i = 1; i < this.size(); ++i) {
            sb.append(" + ");
            sb.append(this.getRawCoeff(i)).append(" * x").append(this.getRawIndex(i));
        }
        return sb.toString();
    }
}

