/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.SubstitutionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DestructiveEqualityReasoning {
    private final QuantifierTheory mQuantTheory;
    private final Clausifier mClausifier;
    private final TermVariable[] mVars;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final Map<TermVariable, Term> mSigma;
    private boolean mIsChanged;
    private DERResult mResult;

    DestructiveEqualityReasoning(QuantifierTheory quantTheory, TermVariable[] vars, Literal[] groundLits, QuantLiteral[] quantLits, SourceAnnotation source) {
        this.mQuantTheory = quantTheory;
        this.mClausifier = quantTheory.getClausifier();
        this.mVars = vars;
        this.mGroundLits = groundLits;
        this.mQuantLits = quantLits;
        this.mSource = source;
        this.mSigma = new LinkedHashMap<TermVariable, Term>();
        this.mIsChanged = false;
        this.mResult = null;
    }

    boolean applyDestructiveEqualityReasoning() {
        this.collectSubstitution();
        if (!this.mSigma.isEmpty()) {
            SubstitutionHelper subsHelper = new SubstitutionHelper(this.mQuantTheory, this.mGroundLits, this.mQuantLits, this.mSource, this.mSigma);
            SubstitutionHelper.SubstitutionResult subsResult = subsHelper.substituteInClause();
            Term[] subs = new Term[this.mVars.length];
            for (int i = 0; i < subs.length; ++i) {
                subs[i] = this.mSigma.containsKey(this.mVars[i]) ? this.mSigma.get(this.mVars[i]) : this.mVars[i];
            }
            this.mResult = new DERResult(subs, subsResult);
            this.mIsChanged = true;
        }
        return this.mIsChanged;
    }

    DERResult getResult() {
        assert (this.mIsChanged) : "Should only be called if DER has changed the clause.";
        return this.mResult;
    }

    private void collectSubstitution() {
        LinkedHashMap<TermVariable, Term> groundAndVarSubsForVar = new LinkedHashMap<TermVariable, Term>();
        LinkedHashMap potentialSubsForVar = new LinkedHashMap();
        for (QuantLiteral qLit : this.mQuantLits) {
            Term otherVarRep;
            if (!qLit.mIsDERUsable) continue;
            assert (qLit instanceof QuantLiteral.NegQuantLiteral && qLit.getAtom() instanceof QuantEquality);
            QuantEquality varEq = (QuantEquality)qLit.mAtom;
            assert (varEq.getLhs() instanceof TermVariable);
            TermVariable var = (TermVariable)varEq.getLhs();
            Term varRep = this.findRep(var);
            Term rhs = varEq.getRhs();
            if (varRep instanceof TermVariable) {
                if (rhs.getFreeVars().length == 0 || rhs instanceof TermVariable) {
                    groundAndVarSubsForVar.put((TermVariable)varRep, rhs);
                    continue;
                }
                if (!potentialSubsForVar.containsKey(varRep)) {
                    potentialSubsForVar.put(var, new ArrayList());
                }
                ((List)potentialSubsForVar.get(var)).add(rhs);
                continue;
            }
            if (!(rhs instanceof TermVariable) || !((otherVarRep = this.findRep((TermVariable)rhs)) instanceof TermVariable)) continue;
            groundAndVarSubsForVar.put((TermVariable)otherVarRep, varRep);
        }
        if (!groundAndVarSubsForVar.isEmpty()) {
            HashSet<TermVariable> visited = new HashSet<TermVariable>();
            for (TermVariable var : groundAndVarSubsForVar.keySet()) {
                if (visited.contains(var)) continue;
                LinkedHashSet<TermVariable> varsWithSameSubs = new LinkedHashSet<TermVariable>();
                Term subs = var;
                while (subs instanceof TermVariable && !visited.contains(subs)) {
                    visited.add((TermVariable)subs);
                    varsWithSameSubs.add((TermVariable)subs);
                    if (!groundAndVarSubsForVar.containsKey(subs)) continue;
                    subs = (Term)groundAndVarSubsForVar.get(subs);
                }
                for (TermVariable equiVar : varsWithSameSubs) {
                    if (equiVar == subs) continue;
                    this.mSigma.put(equiVar, subs);
                    if (subs instanceof TermVariable) continue;
                    potentialSubsForVar.remove(equiVar);
                }
            }
        }
        if (!potentialSubsForVar.isEmpty()) {
            for (TermVariable var : potentialSubsForVar.keySet()) {
                Term varRep = this.findRep(var);
                if (!(varRep instanceof TermVariable)) continue;
                for (Term potentialSubs : (List)potentialSubsForVar.get(var)) {
                    if (this.hasCycle(var, potentialSubs)) continue;
                    FormulaUnLet unletter = new FormulaUnLet();
                    unletter.addSubstitutions(this.mSigma);
                    Term subs = unletter.unlet(potentialSubs);
                    IProofTracker tracker = this.mClausifier.getTracker();
                    subs = tracker.getProvedTerm(this.mClausifier.getTermCompiler().transform(subs));
                    this.mSigma.put((TermVariable)varRep, subs);
                }
            }
        }
    }

    private Term findRep(TermVariable var) {
        TermVariable nextVarRep = var;
        while (this.mSigma.containsKey(nextVarRep)) {
            Term subs = this.mSigma.get(nextVarRep);
            if (subs instanceof TermVariable) {
                nextVarRep = (TermVariable)subs;
                continue;
            }
            return subs;
        }
        return nextVarRep;
    }

    private boolean hasCycle(TermVariable var, Term potentialSubs) {
        assert (potentialSubs.getFreeVars().length > 0);
        for (TermVariable dependentVar : potentialSubs.getFreeVars()) {
            if (!Arrays.asList(this.findRep(dependentVar).getFreeVars()).contains(var)) continue;
            return true;
        }
        return false;
    }

    public static class DERResult
    extends SubstitutionHelper.SubstitutionResult {
        private final Term[] mSubs;

        protected DERResult(Term[] subs, SubstitutionHelper.SubstitutionResult subsRes) {
            super(subsRes.mSubstituted, subsRes.mSimplified, subsRes.mGroundLits, subsRes.mQuantLits);
            this.mSubs = subs;
        }

        public Term[] getSubs() {
            return this.mSubs;
        }
    }
}

