/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.List;

class InstClause {
    protected final QuantClause mQuantClause;
    protected final List<Term> mSubs;
    protected final List<Literal> mLits;
    protected int mNumUndefLits;
    protected QuantifierTheory.InstanceOrigin mOrigin;
    private Term mInstClauseTerm;

    InstClause(QuantClause qClause, List<Term> subs, List<Literal> lits, int numUndefLits, QuantifierTheory.InstanceOrigin origin, Term instClauseTerm) {
        this.mQuantClause = qClause;
        this.mSubs = subs;
        this.mLits = lits;
        this.mNumUndefLits = numUndefLits;
        this.mOrigin = origin;
        this.mInstClauseTerm = instClauseTerm;
    }

    public int hashCode() {
        return this.mLits.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof InstClause) {
            return this.mLits.equals(((InstClause)other).mLits);
        }
        return false;
    }

    public String toString() {
        return this.mLits.toString();
    }

    boolean isConflict() {
        return this.mNumUndefLits == 0;
    }

    boolean isUnit() {
        return this.mNumUndefLits == 1;
    }

    int countAndSetUndefLits() {
        int numUndef = 0;
        for (Literal lit : this.mLits) {
            if (lit.getAtom().getDecideStatus() == lit) {
                this.mNumUndefLits = -1;
                return -1;
            }
            if (lit.getAtom().getDecideStatus() != null) continue;
            ++numUndef;
        }
        this.mNumUndefLits = numUndef;
        return numUndef;
    }

    Clause toClause(boolean produceProofs) {
        Clause clause = new Clause(this.mLits.toArray(new Literal[this.mLits.size()]), this.mQuantClause.getQuantTheory().getEngine().getAssertionStackLevel());
        if (produceProofs) {
            clause.setProof(new LeafNode(-2, new QuantAnnotation(this.mQuantClause, this.mSubs, this.mInstClauseTerm, this.mOrigin)));
        }
        return clause;
    }
}

