/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LASharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.SubstitutionHelper;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg.Dawg;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InstantiationManager {
    private final Clausifier mClausifier;
    private final QuantifierTheory mQuantTheory;
    private final EMatching mEMatching;
    private final Map<QuantClause, Map<List<Term>, InstClause>> mClauseInstances;
    private final InstanceValue mDefaultValueForLitDawgs;
    private final List<InstanceValue> mRelevantValuesForCheckpoint;
    private int mSubsAgeForFinalCheck = 0;

    public InstantiationManager(QuantifierTheory quantTheory) {
        this.mQuantTheory = quantTheory;
        this.mClausifier = quantTheory.getClausifier();
        this.mEMatching = quantTheory.getEMatching();
        this.mClauseInstances = new HashMap<QuantClause, Map<List<Term>, InstClause>>();
        this.mDefaultValueForLitDawgs = this.mQuantTheory.mUseUnknownTermValueInDawgs ? InstanceValue.UNKNOWN_TERM : InstanceValue.ONE_UNDEF;
        this.mRelevantValuesForCheckpoint = new ArrayList<InstanceValue>();
        this.mRelevantValuesForCheckpoint.add(InstanceValue.FALSE);
        this.mRelevantValuesForCheckpoint.add(InstanceValue.ONE_UNDEF);
        if (this.mQuantTheory.mInstantiationMethod == QuantifierTheory.InstantiationMethod.E_MATCHING_EAGER || this.mQuantTheory.mInstantiationMethod == QuantifierTheory.InstantiationMethod.E_MATCHING_LAZY) {
            this.mRelevantValuesForCheckpoint.add(InstanceValue.OTHER);
        } else if (this.mQuantTheory.mPropagateNewTerms) {
            this.mRelevantValuesForCheckpoint.add(InstanceValue.UNKNOWN_TERM);
        }
    }

    public void addClause(QuantClause qClause) {
        this.mClauseInstances.put(qClause, new LinkedHashMap());
    }

    public void removeClause(QuantClause clause) {
        assert (this.mClauseInstances.containsKey(clause));
        this.mClauseInstances.remove(clause);
    }

    public void removeAllInstClauses() {
        for (Map<List<Term>, InstClause> instClauses : this.mClauseInstances.values()) {
            instClauses.clear();
        }
    }

    public void resetInterestingTerms() {
        for (QuantClause qClause : this.mQuantTheory.getQuantClauses()) {
            qClause.clearInterestingTerms();
        }
    }

    public void resetSubsAgeForFinalCheck() {
        this.mSubsAgeForFinalCheck = 0;
    }

    public Set<InstClause> findConflictAndUnitInstancesWithEMatching() {
        LinkedHashSet<InstClause> conflictAndUnitClauses = new LinkedHashSet<InstClause>();
        LinkedHashMap unitSubs = new LinkedHashMap();
        ArrayList<QuantClause> currentQuantClauses = new ArrayList<QuantClause>();
        currentQuantClauses.addAll(this.mQuantTheory.getQuantClauses());
        for (QuantClause quantClause : currentQuantClauses) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (quantClause.hasTrueGroundLits()) continue;
            Dawg<Term, InstantiationInfo> dawg = this.computeClauseDawg(quantClause);
            for (InstantiationInfo subsWithVal : this.getRelevantSubsFromDawg(quantClause, dawg)) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                List<Term> subs = subsWithVal.getSubs();
                InstanceValue val = subsWithVal.getInstValue();
                if (val == InstanceValue.FALSE) {
                    InstClause inst = this.computeClauseInstance(quantClause, subs, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (inst == null) continue;
                    conflictAndUnitClauses.add(inst);
                    continue;
                }
                assert (val == InstanceValue.ONE_UNDEF || val == InstanceValue.UNKNOWN_TERM);
                if (!unitSubs.containsKey(quantClause)) {
                    unitSubs.put(quantClause, new ArrayList());
                }
                ((Collection)unitSubs.get(quantClause)).add(subs);
            }
        }
        if (conflictAndUnitClauses.isEmpty()) {
            for (Map.Entry entry : unitSubs.entrySet()) {
                QuantClause clause = (QuantClause)entry.getKey();
                for (List subs : (Collection)entry.getValue()) {
                    if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return Collections.emptySet();
                    }
                    InstClause inst = this.computeClauseInstance(clause, subs, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (inst == null) continue;
                    conflictAndUnitClauses.add(inst);
                }
            }
        }
        return conflictAndUnitClauses;
    }

    public Set<InstClause> findConflictAndUnitInstances() {
        LinkedHashSet<InstClause> conflictAndUnitClauses = new LinkedHashSet<InstClause>();
        LinkedHashMap unitSubs = new LinkedHashMap();
        ArrayList<QuantClause> currentQuantClauses = new ArrayList<QuantClause>();
        currentQuantClauses.addAll(this.mQuantTheory.getQuantClauses());
        for (QuantClause quantClause : currentQuantClauses) {
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            if (quantClause.hasTrueGroundLits()) continue;
            quantClause.updateInterestingTermsAllVars();
            Set<List<Term>> allSubstitutions = this.computeAllSubstitutions(quantClause);
            for (List<Term> subs : allSubstitutions) {
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                InstanceValue clauseValue = this.evaluateClauseInstance(quantClause, subs);
                if (clauseValue == InstanceValue.IRRELEVANT) continue;
                if (clauseValue == InstanceValue.FALSE) {
                    InstClause inst = this.computeClauseInstance(quantClause, subs, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (inst == null) continue;
                    conflictAndUnitClauses.add(inst);
                    continue;
                }
                assert (clauseValue == InstanceValue.ONE_UNDEF || clauseValue == InstanceValue.UNKNOWN_TERM);
                if (!unitSubs.containsKey(quantClause)) {
                    unitSubs.put(quantClause, new ArrayList());
                }
                ((Collection)unitSubs.get(quantClause)).add(subs);
            }
        }
        if (conflictAndUnitClauses.isEmpty()) {
            for (Map.Entry entry : unitSubs.entrySet()) {
                QuantClause clause = (QuantClause)entry.getKey();
                for (List<Term> subs : (Collection)entry.getValue()) {
                    if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return Collections.emptySet();
                    }
                    InstClause inst = this.computeClauseInstance(clause, subs, QuantifierTheory.InstanceOrigin.CONFLICT);
                    if (inst == null) continue;
                    conflictAndUnitClauses.add(inst);
                }
            }
        }
        return conflictAndUnitClauses;
    }

    public Set<InstClause> computeEMatchingInstances() {
        LinkedHashSet<InstClause> newInstances = new LinkedHashSet<InstClause>();
        ArrayList<QuantClause> currentQuantClauses = new ArrayList<QuantClause>();
        currentQuantClauses.addAll(this.mQuantTheory.getQuantClauses());
        block0: for (QuantClause clause : currentQuantClauses) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (clause.hasTrueGroundLits()) continue;
            Dawg<Term, InstantiationInfo> clauseDawg = Dawg.createConst(clause.getVars().length, new InstantiationInfo(InstanceValue.FALSE, new ArrayList()));
            for (QuantLiteral lit : clause.getQuantLits()) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                Dawg<Term, InstantiationInfo> instDawg = null;
                QuantLiteral atom = lit.getAtom();
                if (this.mEMatching.isUsingEmatching(lit) || this.mEMatching.isPartiallyUsingEmatching(lit)) {
                    Term lhs;
                    if (this.mQuantTheory.mPropagateNewAux && atom instanceof QuantEquality && QuantUtil.isAuxApplication(lhs = ((QuantEquality)atom).getLhs())) {
                        instDawg = Dawg.createConst(clause.getVars().length, new InstantiationInfo(InstanceValue.ONE_UNDEF, new ArrayList()));
                    }
                    if (instDawg == null) {
                        Dawg<Term, EMatching.SubstitutionInfo> subsDawg = this.mEMatching.getSubstitutionInfos(atom);
                        Dawg<Term, EMatching.SubstitutionInfo> representativeSubsDawg = this.getRepresentativeSubsDawg(subsDawg);
                        instDawg = representativeSubsDawg.map(v -> v.equals(this.mEMatching.getEmptySubs()) && !QuantUtil.isVarEq(lit.getAtom()) ? new InstantiationInfo(InstanceValue.IRRELEVANT, new ArrayList()) : new InstantiationInfo(InstanceValue.ONE_UNDEF, this.getTermSubsFromSubsInfo(lit, (EMatching.SubstitutionInfo)v)));
                    }
                } else if (lit.mIsArithmetical) {
                    instDawg = Dawg.createConst(clause.getVars().length, new InstantiationInfo(InstanceValue.ONE_UNDEF, new ArrayList()));
                }
                if (instDawg == null) continue block0;
                clauseDawg = clauseDawg.combine(instDawg, (v1, v2) -> this.combineForCheckpoint((InstantiationInfo)v1, (InstantiationInfo)v2));
            }
            for (InstantiationInfo subs : this.getRelevantSubsFromDawg(clause, clauseDawg)) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                InstClause inst = this.computeClauseInstance(clause, subs.getSubs(), QuantifierTheory.InstanceOrigin.EMATCHING);
                if (inst == null) continue;
                newInstances.add(inst);
            }
        }
        return newInstances;
    }

    private Dawg<Term, EMatching.SubstitutionInfo> getRepresentativeSubsDawg(Dawg<Term, EMatching.SubstitutionInfo> dawg) {
        return dawg.mapKeys(l -> this.mQuantTheory.getRepresentativeTerm((Term)l), (v1, v2) -> this.mapToFirstChecked((EMatching.SubstitutionInfo)v1, (EMatching.SubstitutionInfo)v2));
    }

    public Set<InstClause> instantiateSomeNotSat() {
        ArrayList<QuantClause> currentQuantClauses = new ArrayList<QuantClause>();
        for (QuantClause clause : this.mQuantTheory.getQuantClauses()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            if (clause.hasTrueGroundLits()) continue;
            assert (this.mClauseInstances.containsKey(clause));
            for (Map.Entry entry : this.mClauseInstances.get(clause).entrySet()) {
                InstClause instClause = (InstClause)entry.getValue();
                if (instClause == null) continue;
                int numUndef = instClause.countAndSetUndefLits();
                assert (numUndef == -1 || numUndef == 0);
                if (numUndef != 0) continue;
                this.mQuantTheory.getLogger().info("Conflict on existing clause instance hasn't been detected in checkpoint(): ", instClause);
                return Collections.singleton(instClause);
            }
            currentQuantClauses.add(clause);
        }
        HashMap<QuantClause, List<Term>[]> interestingTermsSortedByAge = new HashMap<QuantClause, List<Term>[]>();
        int oldest = 0;
        for (QuantClause quantClause : currentQuantClauses) {
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            quantClause.updateInterestingTermsAllVars();
            Pair<List<Term>[], Integer> termsSortedByAge = this.sortInterestingTermsByAge(quantClause.getInterestingTerms());
            oldest = Math.max(oldest, termsSortedByAge.getSecond());
            interestingTermsSortedByAge.put(quantClause, termsSortedByAge.getFirst());
        }
        this.mQuantTheory.getLogger().debug("Quant: Max term age %d", oldest);
        while (this.mSubsAgeForFinalCheck <= oldest) {
            this.mQuantTheory.getLogger().debug("Searching for instances of age %d", this.mSubsAgeForFinalCheck);
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            ArrayList<Pair<QuantClause, List<Term>>> otherValueInstancesOnKnownTerms = new ArrayList<Pair<QuantClause, List<Term>>>();
            ArrayList<Pair<QuantClause, List<Term>>> arrayList = new ArrayList<Pair<QuantClause, List<Term>>>();
            ArrayList<Pair<QuantClause, List<Term>>> otherValueInstancesNewTerms = new ArrayList<Pair<QuantClause, List<Term>>>();
            for (QuantClause clause : currentQuantClauses) {
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                Set<List<Term>> set = this.computeSubstitutionsForAge((List[])interestingTermsSortedByAge.get(clause), this.mSubsAgeForFinalCheck);
                for (List<Term> subs : set) {
                    Pair<InstanceValue, Boolean> candVal;
                    assert (this.getMaxAge(subs) == this.mSubsAgeForFinalCheck);
                    if (this.mClausifier.getEngine().isTerminationRequested()) {
                        return null;
                    }
                    if (this.mClauseInstances.containsKey(clause) && this.mClauseInstances.get(clause).containsKey(subs) || (candVal = this.evaluateNewClauseInstanceFinalCheck(clause, subs)).getFirst() == InstanceValue.TRUE) continue;
                    if (candVal.getFirst() == InstanceValue.FALSE || candVal.getFirst() == InstanceValue.ONE_UNDEF) {
                        int numUndef;
                        assert (candVal.getSecond().booleanValue());
                        InstClause unitClause = this.computeClauseInstance(clause, subs, QuantifierTheory.InstanceOrigin.ENUMERATION);
                        if (unitClause == null || (numUndef = unitClause.countAndSetUndefLits()) < 0) continue;
                        this.mQuantTheory.getLogger().debug("Found inst of age %d", this.mSubsAgeForFinalCheck);
                        return Collections.singleton(unitClause);
                    }
                    Pair<QuantClause, List<Term>> clauseSubsPair = new Pair<QuantClause, List<Term>>(clause, subs);
                    if (candVal.getFirst() == InstanceValue.UNKNOWN_TERM) {
                        assert (!candVal.getSecond().booleanValue());
                        arrayList.add(clauseSubsPair);
                        continue;
                    }
                    assert (candVal.getFirst() == InstanceValue.OTHER);
                    if (candVal.getSecond().booleanValue()) {
                        otherValueInstancesOnKnownTerms.add(clauseSubsPair);
                        continue;
                    }
                    otherValueInstancesNewTerms.add(clauseSubsPair);
                }
            }
            ArrayList<Pair<QuantClause, List<Term>>> sortedInstances = new ArrayList<Pair<QuantClause, List<Term>>>();
            sortedInstances.addAll(arrayList);
            sortedInstances.addAll(otherValueInstancesOnKnownTerms);
            sortedInstances.addAll(otherValueInstancesNewTerms);
            for (Pair pair : sortedInstances) {
                int numUndef;
                if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                InstClause inst = this.computeClauseInstance((QuantClause)pair.getFirst(), (List)pair.getSecond(), QuantifierTheory.InstanceOrigin.ENUMERATION);
                if (inst == null || (numUndef = inst.countAndSetUndefLits()) < 0) continue;
                this.mQuantTheory.getLogger().debug("Found inst of age %d", this.mSubsAgeForFinalCheck);
                return Collections.singleton(inst);
            }
            ++this.mSubsAgeForFinalCheck;
        }
        return null;
    }

    private Pair<List<Term>[], Integer> sortInterestingTermsByAge(Map<Term, Term>[] interestingTermsForClause) {
        ArrayList[] sortedTerms = new ArrayList[interestingTermsForClause.length];
        int oldest = 0;
        for (int i = 0; i < sortedTerms.length; ++i) {
            sortedTerms[i] = this.sortInterestingTermsByAge(interestingTermsForClause[i].values());
            assert (!sortedTerms[i].isEmpty());
            oldest = Math.max(oldest, this.getTermAge((Term)sortedTerms[i].get(sortedTerms[i].size() - 1)));
        }
        return new Pair<ArrayList[], Integer>(sortedTerms, oldest);
    }

    private List<Term> sortInterestingTermsByAge(Collection<Term> terms) {
        ArrayList<Term> termList = new ArrayList<Term>();
        termList.addAll(terms);
        Collections.sort(termList, new Comparator<Term>(){

            @Override
            public int compare(Term t1, Term t2) {
                return InstantiationManager.this.getTermAge(t1) - InstantiationManager.this.getTermAge(t2);
            }
        });
        return termList;
    }

    private Set<List<Term>> computeSubstitutionsForAge(List<Term>[] sortedSubstitutionTerms, int age) {
        int length = sortedSubstitutionTerms.length;
        LinkedHashMap<ArrayList<Object>, Integer> allSubs = new LinkedHashMap<ArrayList<Object>, Integer>();
        allSubs.put(new ArrayList(length), 0);
        for (int i = 0; i < length; ++i) {
            assert (!sortedSubstitutionTerms[i].isEmpty());
            LinkedHashMap partialSubs = new LinkedHashMap();
            for (Map.Entry oldSub : allSubs.entrySet()) {
                Term ground;
                int groundAge;
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                int oldSubAge = (Integer)oldSub.getValue();
                Iterator<Term> iterator = sortedSubstitutionTerms[i].iterator();
                while (iterator.hasNext() && (groundAge = this.getTermAge(ground = iterator.next())) <= age) {
                    if (i == length - 1 && oldSubAge != age && groundAge != age) continue;
                    ArrayList<Term> newSub = new ArrayList<Term>(length);
                    newSub.addAll((Collection)oldSub.getKey());
                    newSub.add(ground);
                    int newAge = (Integer)oldSub.getValue() > groundAge ? (Integer)oldSub.getValue() : groundAge;
                    partialSubs.put(newSub, newAge);
                }
            }
            allSubs.clear();
            allSubs.putAll(partialSubs);
        }
        return allSubs.keySet();
    }

    private int getTermAge(Term t) {
        CCTerm cc = this.mClausifier.getCCTerm(t);
        return cc != null ? cc.getAge() : 0;
    }

    private int getMaxAge(List<Term> terms) {
        int age = 0;
        for (Term t : terms) {
            age = Math.max(age, this.getTermAge(t));
        }
        return age;
    }

    private Dawg<Term, InstantiationInfo> computeClauseDawg(QuantClause qClause) {
        Literal groundLit;
        int numVars = qClause.getVars().length;
        ArrayList emptySubs = new ArrayList();
        Dawg<Term, InstantiationInfo> constIrrelDawg = Dawg.createConst(qClause.getVars().length, new InstantiationInfo(InstanceValue.IRRELEVANT, emptySubs));
        InstanceValue clauseValue = InstanceValue.FALSE;
        Literal[] literalArray = qClause.getGroundLits();
        int n = literalArray.length;
        for (int i = 0; i < n && (clauseValue = (groundLit = literalArray[i]).getAtom().getDecideStatus() == groundLit ? this.combineForCheckpoint(clauseValue, InstanceValue.TRUE) : (groundLit.getAtom().getDecideStatus() == groundLit.negate() ? this.combineForCheckpoint(clauseValue, InstanceValue.FALSE) : this.combineForCheckpoint(clauseValue, InstanceValue.ONE_UNDEF))) != InstanceValue.IRRELEVANT; ++i) {
        }
        Dawg<Term, InstantiationInfo> clauseDawg = Dawg.createConst(numVars, new InstantiationInfo(clauseValue, emptySubs));
        if (clauseValue != InstanceValue.IRRELEVANT) {
            BiFunction<InstantiationInfo, InstantiationInfo, InstantiationInfo> combinator = (v1, v2) -> this.combineForCheckpoint((InstantiationInfo)v1, (InstantiationInfo)v2);
            ArrayList<QuantLiteral> unknownLits = new ArrayList<QuantLiteral>(qClause.getQuantLits().length);
            ArrayList<QuantLiteral> arithLits = new ArrayList<QuantLiteral>(qClause.getQuantLits().length);
            ArrayList<QuantLiteral> partialEMLits = new ArrayList<QuantLiteral>(qClause.getQuantLits().length);
            for (QuantLiteral qLit : qClause.getQuantLits()) {
                if (clauseDawg == constIrrelDawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                    return constIrrelDawg;
                }
                if (qLit.isArithmetical()) {
                    arithLits.add(qLit);
                    continue;
                }
                if (this.mEMatching.isUsingEmatching(qLit)) {
                    Dawg<Term, InstantiationInfo> litDawg = this.computeEMatchingLitDawg(qLit);
                    clauseDawg = clauseDawg.combine(litDawg, combinator);
                    continue;
                }
                if (this.mEMatching.isPartiallyUsingEmatching(qLit)) {
                    partialEMLits.add(qLit);
                    continue;
                }
                unknownLits.add(qLit);
            }
            if (clauseDawg != constIrrelDawg && !partialEMLits.isEmpty()) {
                for (QuantLiteral lit : partialEMLits) {
                    if (clauseDawg == constIrrelDawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return constIrrelDawg;
                    }
                    Dawg<Term, EMatching.SubstitutionInfo> info = this.mEMatching.getSubstitutionInfos(lit.getAtom());
                    Dawg<Term, EMatching.SubstitutionInfo> rep = this.getRepresentativeSubsDawg(info);
                    clauseDawg = clauseDawg.combine(rep, (v1, v2) -> this.combineForCheckpoint((InstantiationInfo)v1, this.evaluateLitForPartialEMatchingSubsInfo(lit, (InstantiationInfo)v1, (EMatching.SubstitutionInfo)v2)));
                }
            }
            if (clauseDawg != constIrrelDawg && !unknownLits.isEmpty()) {
                for (QuantLiteral lit : unknownLits) {
                    if (clauseDawg == constIrrelDawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return constIrrelDawg;
                    }
                    clauseDawg = clauseDawg.mapWithKey((key, value) -> this.combineForCheckpoint((InstantiationInfo)value, new InstantiationInfo(this.evaluateLitInstance(lit, (List<Term>)key), value.getSubs())));
                }
            }
            if (clauseDawg != constIrrelDawg && !arithLits.isEmpty()) {
                Term[][] interestingSubsForArith = this.computeSubsForArithmetical(qClause, arithLits, clauseDawg);
                for (QuantLiteral arLit : arithLits) {
                    if (clauseDawg == constIrrelDawg || this.mQuantTheory.getEngine().isTerminationRequested()) {
                        return constIrrelDawg;
                    }
                    Dawg<Term, InstantiationInfo> litDawg = this.computeArithLitDawg(arLit, interestingSubsForArith);
                    clauseDawg = clauseDawg.combine(litDawg, combinator);
                }
            }
        }
        return clauseDawg;
    }

    private InstanceValue combineForCheckpoint(InstanceValue first, InstanceValue second) {
        return first.combine(second).keepOnlyRelevant(this.mRelevantValuesForCheckpoint);
    }

    private InstantiationInfo combineForCheckpoint(InstantiationInfo first, InstantiationInfo second) {
        InstanceValue combinedValue = this.combineForCheckpoint(first.getInstValue(), second.getInstValue());
        if (combinedValue == InstanceValue.IRRELEVANT) {
            return new InstantiationInfo(combinedValue, new ArrayList());
        }
        List<Term> combinedSubs = this.combineSubs(first.getSubs(), second.getSubs());
        return new InstantiationInfo(combinedValue, combinedSubs);
    }

    private List<Term> combineSubs(List<Term> firstSubs, List<Term> secondSubs) {
        assert (firstSubs.isEmpty() || secondSubs.isEmpty() || firstSubs.size() == secondSubs.size());
        ArrayList<Term> combinedSubs = new ArrayList<Term>();
        if (firstSubs.isEmpty()) {
            combinedSubs.addAll(secondSubs);
        } else if (secondSubs.isEmpty()) {
            combinedSubs.addAll(firstSubs);
        } else {
            for (int i = 0; i < firstSubs.size(); ++i) {
                if (firstSubs.get(i) == null) {
                    combinedSubs.add(secondSubs.get(i));
                    continue;
                }
                if ($assertionsDisabled || secondSubs.get(i) != null) {
                    // empty if block
                }
                combinedSubs.add(firstSubs.get(i));
            }
        }
        return combinedSubs;
    }

    private boolean isUsedValueForCheckpoint(InstanceValue value) {
        if (value == InstanceValue.IRRELEVANT) {
            return true;
        }
        for (InstanceValue relVal : this.mRelevantValuesForCheckpoint) {
            if (value != relVal) continue;
            return true;
        }
        return false;
    }

    private Dawg<Term, InstantiationInfo> computeEMatchingLitDawg(QuantLiteral qLit) {
        assert (this.mEMatching.isUsingEmatching(qLit));
        Dawg<Term, EMatching.SubstitutionInfo> atomSubsDawg = this.mEMatching.getSubstitutionInfos(qLit.getAtom());
        Dawg<Term, EMatching.SubstitutionInfo> representativeSubsDawg = this.getRepresentativeSubsDawg(atomSubsDawg);
        Function<EMatching.SubstitutionInfo, InstantiationInfo> evaluationMap = v1 -> new InstantiationInfo(this.evaluateLitForEMatchingSubsInfo(qLit, (EMatching.SubstitutionInfo)v1), this.getTermSubsFromSubsInfo(qLit, (EMatching.SubstitutionInfo)v1));
        return representativeSubsDawg.map(evaluationMap);
    }

    private EMatching.SubstitutionInfo mapToFirstChecked(EMatching.SubstitutionInfo first, EMatching.SubstitutionInfo second) {
        return first;
    }

    private List<Term> getTermSubsFromSubsInfo(QuantLiteral qLit, EMatching.SubstitutionInfo info) {
        int length = qLit.getClause().getVars().length;
        ArrayList<Term> termSubs = new ArrayList<Term>();
        if (!info.equals(this.mEMatching.getEmptySubs())) {
            List<CCTerm> ccSubs = info.getVarSubs();
            assert (ccSubs.size() == length);
            for (int i = 0; i < length; ++i) {
                CCTerm ccTerm = ccSubs.get(i);
                termSubs.add(ccTerm == null ? null : ccTerm.getFlatTerm());
            }
        }
        return termSubs;
    }

    private InstanceValue evaluateLitForEMatchingSubsInfo(QuantLiteral qLit, EMatching.SubstitutionInfo info) {
        InstanceValue val;
        QuantLiteral qAtom = qLit.getAtom();
        if (info.equals(this.mEMatching.getEmptySubs())) {
            if (this.mQuantTheory.mPropagateNewAux && !this.mQuantTheory.mPropagateNewTerms && qAtom instanceof QuantEquality && QuantUtil.isAuxApplication(((QuantEquality)qAtom).getLhs())) {
                return InstanceValue.ONE_UNDEF;
            }
            return this.mDefaultValueForLitDawgs;
        }
        if (qAtom instanceof QuantBoundConstraint) {
            Map<Term, Term> sharedForQuantSmds = this.buildSharedMapFromCCMap(info.getEquivalentCCTerms());
            val = this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)qAtom, sharedForQuantSmds);
        } else {
            QuantEquality qEq = (QuantEquality)qAtom;
            val = this.evaluateCCEqualityKnownShared(qEq, info.getEquivalentCCTerms());
            if ((val == InstanceValue.ONE_UNDEF || val == InstanceValue.UNKNOWN_TERM) && qEq.getLhs().getSort().isNumericSort()) {
                Map<Term, Term> sharedForQuantSmds = this.buildSharedMapFromCCMap(info.getEquivalentCCTerms());
                val = this.evaluateLAEqualityKnownShared(qEq, sharedForQuantSmds);
            }
        }
        if (qLit.isNegated()) {
            val = val.negate();
        }
        return val;
    }

    private InstantiationInfo evaluateLitForPartialEMatchingSubsInfo(QuantLiteral lit, InstantiationInfo clauseInstInfo, EMatching.SubstitutionInfo litSubsInfo) {
        InstanceValue val = this.mDefaultValueForLitDawgs;
        TermVariable[] clauseVars = lit.getClause().getVars();
        List<Term> clauseVarSubs = clauseInstInfo.getSubs();
        if (clauseInstInfo.getInstValue() != InstanceValue.IRRELEVANT && !clauseVarSubs.isEmpty()) {
            HashMap<Term, CCTerm> equivalentTerms = new HashMap<Term, CCTerm>();
            equivalentTerms.putAll(litSubsInfo.getEquivalentCCTerms());
            for (int i = 0; i < clauseVars.length; ++i) {
                CCTerm litSubs;
                CCTerm clauseSubs = this.mClausifier.getCCTerm(clauseVarSubs.get(i));
                if (clauseSubs == null) continue;
                CCTerm cCTerm = litSubs = litSubsInfo.equals(this.mEMatching.getEmptySubs()) ? null : litSubsInfo.getVarSubs().get(i);
                if (litSubs != null) {
                    assert (litSubs.getRepresentative().equals(clauseSubs.getRepresentative()));
                    continue;
                }
                equivalentTerms.put(clauseVars[i], clauseSubs);
            }
            QuantLiteral atom = lit.getAtom();
            if (atom instanceof QuantBoundConstraint) {
                Map<Term, Term> sharedForQuantSmds = this.buildSharedMapFromCCMap(equivalentTerms);
                val = this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)atom, sharedForQuantSmds);
            } else {
                QuantEquality qEq = (QuantEquality)atom;
                val = this.evaluateCCEqualityKnownShared(qEq, equivalentTerms);
                if ((val == InstanceValue.ONE_UNDEF || val == InstanceValue.UNKNOWN_TERM) && qEq.getLhs().getSort().isNumericSort()) {
                    Map<Term, Term> sharedForQuantSmds = this.buildSharedMapFromCCMap(equivalentTerms);
                    val = this.evaluateLAEqualityKnownShared(qEq, sharedForQuantSmds);
                }
            }
            if (lit.isNegated()) {
                val = val.negate();
            }
        }
        return new InstantiationInfo(val, val == InstanceValue.IRRELEVANT ? new ArrayList() : this.getTermSubsFromSubsInfo(lit, litSubsInfo));
    }

    private InstanceValue evaluateLitInstance(QuantLiteral quantLit, List<Term> substitution) {
        InstanceValue litValue = this.mDefaultValueForLitDawgs;
        boolean isNeg = quantLit.isNegated();
        QuantLiteral atom = quantLit.getAtom();
        if (atom instanceof QuantEquality) {
            QuantEquality eq = (QuantEquality)atom;
            litValue = this.evaluateCCEquality(eq, substitution);
            if ((litValue == InstanceValue.ONE_UNDEF || litValue == InstanceValue.UNKNOWN_TERM) && eq.getLhs().getSort().isNumericSort()) {
                litValue = this.evaluateLAEquality(eq, substitution);
            }
        } else {
            litValue = this.evaluateBoundConstraint((QuantBoundConstraint)atom, substitution);
        }
        if (isNeg) {
            litValue = litValue.negate();
        }
        return litValue;
    }

    private Dawg<Term, InstantiationInfo> computeArithLitDawg(QuantLiteral arLit, Term[][] interestingSubs) {
        int firstVarPosInClause;
        QuantLiteral qAtom = arLit.getAtom();
        int numVarsInClause = arLit.getClause().getVars().length;
        TermVariable[] varsInLit = qAtom.getTerm().getFreeVars();
        assert (varsInLit.length == 1 || varsInLit.length == 2);
        TermVariable var = varsInLit[0];
        TermVariable otherVar = varsInLit.length == 2 ? varsInLit[1] : null;
        int varPosInClause = arLit.getClause().getVarIndex(varsInLit[0]);
        int n = firstVarPosInClause = otherVar == null ? varPosInClause : arLit.getClause().getVarIndex(varsInLit[1]);
        if (otherVar != null && firstVarPosInClause > varPosInClause) {
            int temp = varPosInClause;
            varPosInClause = firstVarPosInClause;
            firstVarPosInClause = temp;
            TermVariable tempVar = var;
            var = otherVar;
            otherVar = tempVar;
        }
        int nOuterLoops = otherVar == null ? 1 : interestingSubs[firstVarPosInClause].length;
        LinkedHashMap<Term, Dawg<Term, InstantiationInfo>> transitionsFromOtherVar = new LinkedHashMap<Term, Dawg<Term, InstantiationInfo>>();
        int remainderDawgLengthForVar = numVarsInClause - varPosInClause - 1;
        Dawg remainderDawgAllVars = null;
        for (int i = 0; i < nOuterLoops; ++i) {
            Term otherSubs = otherVar != null ? interestingSubs[firstVarPosInClause][i] : null;
            ArrayList<Term> partialSubs = new ArrayList<Term>();
            for (int j = 0; j < numVarsInClause; ++j) {
                partialSubs.add(null);
            }
            partialSubs.set(firstVarPosInClause, otherSubs);
            LinkedHashMap transitionsFromVar = new LinkedHashMap();
            for (Term subs : interestingSubs[varPosInClause]) {
                InstanceValue val = InstanceValue.ONE_UNDEF;
                HashMap<Term, Term> subsMap = new HashMap<Term, Term>();
                subsMap.put(var, subs);
                if (otherVar != null) {
                    subsMap.put(otherVar, otherSubs);
                }
                val = qAtom instanceof QuantBoundConstraint ? this.evaluateBoundConstraintKnownShared((QuantBoundConstraint)qAtom, subsMap) : this.evaluateLAEqualityKnownShared((QuantEquality)qAtom, subsMap);
                if (arLit.isNegated()) {
                    val = val.negate();
                }
                long time = System.nanoTime();
                if (val != this.mDefaultValueForLitDawgs) {
                    partialSubs.set(varPosInClause, subs);
                    Dawg remainderDawgForVarSub = Dawg.createConst(remainderDawgLengthForVar, new InstantiationInfo(val, new ArrayList(partialSubs)));
                    transitionsFromVar.put(subs, remainderDawgForVarSub);
                }
                this.mQuantTheory.addDawgTime(System.nanoTime() - time);
            }
            long time = System.nanoTime();
            Dawg<Term, InstantiationInfo> dawgForVar = Dawg.createDawg(transitionsFromVar, Dawg.createConst(remainderDawgLengthForVar, new InstantiationInfo(this.mDefaultValueForLitDawgs, new ArrayList())));
            if (otherVar != null) {
                transitionsFromOtherVar.put(otherSubs, this.createAncestorDawg(dawgForVar, varPosInClause - firstVarPosInClause - 1));
            } else {
                remainderDawgAllVars = dawgForVar;
            }
            this.mQuantTheory.addDawgTime(System.nanoTime() - time);
        }
        long time = System.nanoTime();
        if (otherVar != null) {
            remainderDawgAllVars = Dawg.createDawg(transitionsFromOtherVar, Dawg.createConst(arLit.getClause().getVars().length - firstVarPosInClause - 1, new InstantiationInfo(this.mDefaultValueForLitDawgs, new ArrayList())));
        }
        Dawg<Term, InstantiationInfo> litDawg = this.createAncestorDawg(remainderDawgAllVars, firstVarPosInClause);
        this.mQuantTheory.addDawgTime(System.nanoTime() - time);
        return litDawg;
    }

    private Dawg<Term, InstantiationInfo> createAncestorDawg(Dawg<Term, InstantiationInfo> dawg, int level) {
        Dawg<Term, InstantiationInfo> prepended = dawg;
        for (int i = 0; i < level; ++i) {
            prepended = Dawg.createDawg(Collections.emptyMap(), prepended);
        }
        return prepended;
    }

    private Collection<InstantiationInfo> getRelevantSubsFromDawg(QuantClause qClause, Dawg<Term, InstantiationInfo> clauseDawg) {
        ArrayList<InstantiationInfo> relevantSubs = new ArrayList<InstantiationInfo>();
        for (InstantiationInfo info : clauseDawg.values()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return Collections.emptySet();
            }
            List<Term> subs = info.getSubs();
            InstanceValue val = info.getInstValue();
            if (val == InstanceValue.IRRELEVANT || subs.isEmpty()) continue;
            boolean isComplete = true;
            for (int i = 0; i < subs.size(); ++i) {
                if (subs.get(i) != null) continue;
                isComplete = false;
                break;
            }
            if (!isComplete) continue;
            relevantSubs.add(info);
        }
        return relevantSubs;
    }

    private Map<Term, Term> buildSharedMapFromCCMap(Map<Term, CCTerm> ccMap) {
        HashMap<Term, Term> sharedMap = new HashMap<Term, Term>();
        for (Map.Entry<Term, CCTerm> entry : ccMap.entrySet()) {
            CCTerm ccTerm = entry.getValue();
            Term term = ccTerm.getFlatTerm();
            sharedMap.put(entry.getKey(), term);
        }
        return sharedMap;
    }

    private MutableAffineTerm buildMutableAffineTerm(SMTAffineTerm smtAff, Map<Term, Term> sharedForQuantSmds) {
        MutableAffineTerm at = new MutableAffineTerm();
        for (Map.Entry<Term, Rational> entry : smtAff.getSummands().entrySet()) {
            Term sharedTerm;
            if (entry.getKey().getFreeVars().length == 0) {
                sharedTerm = entry.getKey();
            } else {
                sharedTerm = sharedForQuantSmds.get(entry.getKey());
                if (sharedTerm == null) {
                    return null;
                }
            }
            LASharedTerm laTerm = this.mClausifier.getLATerm(sharedTerm);
            Rational coeff = entry.getValue();
            if (laTerm != null) {
                for (Map.Entry<LinVar, Rational> summand : laTerm.getSummands().entrySet()) {
                    at.add(coeff.mul(summand.getValue()), summand.getKey());
                }
                at.add(coeff.mul(laTerm.getOffset()));
                continue;
            }
            return null;
        }
        at.add(smtAff.getConstant());
        return at;
    }

    private Term[][] computeSubsForArithmetical(QuantClause clause, Collection<QuantLiteral> arLits, Dawg<Term, InstantiationInfo> clauseDawg) {
        TermVariable[] clauseVars = clause.getVars();
        int nClauseVars = clauseVars.length;
        TermVariable[] clauseVarsInArLits = new TermVariable[nClauseVars];
        for (int i = 0; i < nClauseVars; ++i) {
            TermVariable var = clauseVars[i];
            if (clause.getGroundBounds(var).isEmpty() && clause.getVarBounds(var).isEmpty()) continue;
            clauseVarsInArLits[i] = var;
        }
        LinkedHashSet[] interestingTerms = new LinkedHashSet[nClauseVars];
        for (int i = 0; i < nClauseVars; ++i) {
            interestingTerms[i] = new LinkedHashSet();
            if (clauseVarsInArLits[i] == null) continue;
            interestingTerms[i].addAll(clause.getGroundBounds(clauseVarsInArLits[i]));
        }
        for (Dawg.Entry<Term, InstantiationInfo> entry : clauseDawg.entrySet()) {
            if (entry.getValue().getInstValue() == InstanceValue.IRRELEVANT) continue;
            for (int i = 0; i < nClauseVars; ++i) {
                if (clauseVarsInArLits[i] == null) continue;
                interestingTerms[i].add(entry.getKey().get(i));
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < clauseVarsInArLits.length; ++i) {
                TermVariable var = clauseVarsInArLits[i];
                if (var == null) continue;
                for (TermVariable t : clause.getVarBounds(var)) {
                    int j = clause.getVarIndex(t);
                    changed = interestingTerms[i].addAll(interestingTerms[j]);
                }
            }
        }
        Term[][] interestingTermArrays = new Term[nClauseVars][];
        for (int i = 0; i < nClauseVars; ++i) {
            interestingTermArrays[i] = interestingTerms[i].toArray(new Term[interestingTerms[i].size()]);
        }
        return interestingTermArrays;
    }

    private Set<List<Term>> computeAllSubstitutions(QuantClause quantClause) {
        int nVars = quantClause.getVars().length;
        LinkedHashSet<List<Term>> allSubs = new LinkedHashSet<List<Term>>();
        allSubs.add(new ArrayList(nVars));
        for (int i = 0; i < nVars; ++i) {
            LinkedHashSet partialSubs = new LinkedHashSet();
            for (List list : allSubs) {
                if (this.mClausifier.getEngine().isTerminationRequested()) {
                    return Collections.emptySet();
                }
                assert (!quantClause.getInterestingTerms()[i].isEmpty());
                for (Term ground : quantClause.getInterestingTerms()[i].values()) {
                    ArrayList<Term> newSub = new ArrayList<Term>(nVars);
                    newSub.addAll(list);
                    newSub.add(ground);
                    partialSubs.add(newSub);
                }
            }
            allSubs.clear();
            allSubs.addAll(partialSubs);
        }
        return allSubs;
    }

    private InstanceValue evaluateClauseInstance(QuantClause quantClause, List<Term> substitution) {
        InstanceValue clauseValue = InstanceValue.FALSE;
        for (Literal literal : quantClause.getGroundLits()) {
            if (literal.getAtom().getDecideStatus() == literal) {
                return this.combineForCheckpoint(clauseValue, InstanceValue.TRUE);
            }
            if (literal.getAtom().getDecideStatus() == null) {
                clauseValue = this.combineForCheckpoint(clauseValue, InstanceValue.ONE_UNDEF);
                continue;
            }
            assert (literal.getAtom().getDecideStatus() != literal);
        }
        if (clauseValue == InstanceValue.IRRELEVANT) {
            return clauseValue;
        }
        for (ILiteral iLiteral : quantClause.getQuantLits()) {
            InstanceValue litValue = this.evaluateLitInstance((QuantLiteral)iLiteral, substitution);
            if ((clauseValue = this.combineForCheckpoint(clauseValue, litValue)) != InstanceValue.IRRELEVANT) continue;
            return clauseValue;
        }
        return clauseValue;
    }

    private Pair<InstanceValue, Boolean> evaluateNewClauseInstanceFinalCheck(QuantClause quantClause, List<Term> substitution) {
        assert (!this.mClauseInstances.containsKey(quantClause) || !this.mClauseInstances.get(quantClause).containsKey(substitution));
        InstanceValue clauseValue = InstanceValue.FALSE;
        for (Literal groundLit : quantClause.getGroundLits()) {
            assert (groundLit.getAtom().getDecideStatus() != null);
            if (groundLit.getAtom().getDecideStatus() != groundLit) continue;
            return new Pair<InstanceValue, Object>(InstanceValue.TRUE, null);
        }
        boolean hasOnlyKnownTerms = true;
        for (QuantLiteral quantLit : quantClause.getQuantLits()) {
            InstanceValue litValue = this.evaluateLitInstance(quantLit, substitution);
            if (litValue == InstanceValue.UNKNOWN_TERM) {
                hasOnlyKnownTerms = false;
            }
            if ((clauseValue = clauseValue.combine(litValue)) != InstanceValue.TRUE) continue;
            return new Pair<InstanceValue, Object>(clauseValue, null);
        }
        return new Pair<InstanceValue, Boolean>(clauseValue, hasOnlyKnownTerms);
    }

    private InstClause computeClauseInstance(QuantClause clause, List<Term> subs, QuantifierTheory.InstanceOrigin origin) {
        InstClause inst;
        assert (this.mClauseInstances.containsKey(clause));
        if (this.mClauseInstances.get(clause).containsKey(subs)) {
            return this.mClauseInstances.get(clause).get(subs);
        }
        LinkedHashMap<TermVariable, Term> sigma = new LinkedHashMap<TermVariable, Term>();
        for (int i = 0; i < subs.size(); ++i) {
            sigma.put(clause.getVars()[i], subs.get(i));
        }
        SubstitutionHelper instHelper = new SubstitutionHelper(this.mQuantTheory, clause.getGroundLits(), clause.getQuantLits(), clause.getQuantSource(), sigma);
        SubstitutionHelper.SubstitutionResult result = instHelper.substituteInClause();
        if (result.isTriviallyTrue()) {
            inst = null;
        } else {
            assert (result.isGround());
            this.mQuantTheory.getLogger().debug("Quant: instantiating quant clause %s results in %s", clause, Arrays.asList(result.mGroundLits));
            inst = new InstClause(clause, subs, Arrays.asList(result.mGroundLits), -1, origin, result.mSimplified);
        }
        this.mClauseInstances.get(clause).put(subs, inst);
        ++this.mQuantTheory.mNumInstancesProduced;
        if (origin.equals((Object)QuantifierTheory.InstanceOrigin.CONFLICT)) {
            ++this.mQuantTheory.mNumInstancesProducedConfl;
        } else if (origin.equals((Object)QuantifierTheory.InstanceOrigin.EMATCHING)) {
            ++this.mQuantTheory.mNumInstancesProducedEM;
        } else if (origin.equals((Object)QuantifierTheory.InstanceOrigin.ENUMERATION)) {
            ++this.mQuantTheory.mNumInstancesProducedEnum;
        }
        this.recordSubstAgeForStats(this.getMaxAge(subs), origin.equals((Object)QuantifierTheory.InstanceOrigin.ENUMERATION));
        return inst;
    }

    private InstanceValue evaluateCCEqualityKnownShared(QuantEquality qEq, Map<Term, CCTerm> equivalentCCTerms) {
        CCTerm leftCC = qEq.getLhs().getFreeVars().length == 0 ? this.mClausifier.getCCTerm(qEq.getLhs()) : equivalentCCTerms.get(qEq.getLhs());
        CCTerm rightCC = qEq.getRhs().getFreeVars().length == 0 ? this.mClausifier.getCCTerm(qEq.getRhs()) : equivalentCCTerms.get(qEq.getRhs());
        if (leftCC != null && rightCC != null) {
            if (this.mQuantTheory.getCClosure().isEqSet(leftCC, rightCC)) {
                return InstanceValue.TRUE;
            }
            if (this.mQuantTheory.getCClosure().isDiseqSet(leftCC, rightCC)) {
                return InstanceValue.FALSE;
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateCCEquality(QuantEquality qEq, List<Term> subs) {
        QuantClause qClause = qEq.getClause();
        TermFinder finder = new TermFinder(qClause.getVars(), subs);
        Term left = finder.findEquivalentShared(qEq.getLhs());
        Term right = finder.findEquivalentShared(qEq.getRhs());
        if (left != null && right != null) {
            CCTerm leftCC = this.mClausifier.getCCTerm(left);
            CCTerm rightCC = this.mClausifier.getCCTerm(right);
            if (leftCC != null && rightCC != null) {
                if (this.mQuantTheory.getCClosure().isEqSet(leftCC, rightCC)) {
                    return InstanceValue.TRUE;
                }
                if (this.mQuantTheory.getCClosure().isDiseqSet(leftCC, rightCC)) {
                    return InstanceValue.FALSE;
                }
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateLAEqualityKnownShared(QuantEquality qEq, Map<Term, Term> sharedForQuant) {
        SMTAffineTerm diff = new SMTAffineTerm(qEq.getLhs());
        diff.add(Rational.MONE, new SMTAffineTerm(qEq.getRhs()));
        MutableAffineTerm at = this.buildMutableAffineTerm(diff, sharedForQuant);
        if (at != null) {
            InfinitesimalNumber upperBound = this.mQuantTheory.mLinArSolve.getUpperBound(at);
            at.negate();
            InfinitesimalNumber negLowerBound = this.mQuantTheory.mLinArSolve.getUpperBound(at);
            if (upperBound.signum() == 0 && negLowerBound.signum() == 0) {
                return InstanceValue.TRUE;
            }
            if (upperBound.signum() < 0 || negLowerBound.signum() < 0) {
                return InstanceValue.FALSE;
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateLAEquality(QuantEquality qEq, List<Term> subs) {
        SMTAffineTerm diff = new SMTAffineTerm(qEq.getLhs());
        diff.add(Rational.MONE, qEq.getRhs());
        QuantClause qClause = qEq.getClause();
        TermFinder finder = new TermFinder(qClause.getVars(), subs);
        SMTAffineTerm smtAff = finder.findEquivalentAffine(diff);
        if (smtAff != null) {
            InfinitesimalNumber upperBound = this.mQuantTheory.mLinArSolve.getUpperBound(this.mClausifier, smtAff);
            smtAff.negate();
            InfinitesimalNumber negLowerBound = this.mQuantTheory.mLinArSolve.getUpperBound(this.mClausifier, smtAff);
            if (upperBound.signum() == 0 && negLowerBound.signum() == 0) {
                return InstanceValue.TRUE;
            }
            if (upperBound.signum() < 0 || negLowerBound.signum() < 0) {
                return InstanceValue.FALSE;
            }
            return InstanceValue.ONE_UNDEF;
        }
        return this.mDefaultValueForLitDawgs;
    }

    private InstanceValue evaluateBoundConstraintKnownShared(QuantBoundConstraint qBc, Map<Term, Term> sharedForQuant) {
        MutableAffineTerm at = this.buildMutableAffineTerm(qBc.getAffineTerm(), sharedForQuant);
        if (at == null) {
            return this.mDefaultValueForLitDawgs;
        }
        InfinitesimalNumber upperBound = this.mQuantTheory.mLinArSolve.getUpperBound(at);
        if (upperBound.lesseq(InfinitesimalNumber.ZERO)) {
            return InstanceValue.TRUE;
        }
        at.negate();
        InfinitesimalNumber lowerBound = this.mQuantTheory.mLinArSolve.getUpperBound(at);
        if (lowerBound.less(InfinitesimalNumber.ZERO)) {
            return InstanceValue.FALSE;
        }
        return InstanceValue.ONE_UNDEF;
    }

    private InstanceValue evaluateBoundConstraint(QuantBoundConstraint qBc, List<Term> subs) {
        TermFinder finder = new TermFinder(qBc.getClause().getVars(), subs);
        SMTAffineTerm affine = finder.findEquivalentAffine(qBc.getAffineTerm());
        if (affine == null) {
            return this.mDefaultValueForLitDawgs;
        }
        InfinitesimalNumber upperBound = this.mQuantTheory.mLinArSolve.getUpperBound(this.mClausifier, affine);
        if (upperBound.lesseq(InfinitesimalNumber.ZERO)) {
            return InstanceValue.TRUE;
        }
        affine.negate();
        InfinitesimalNumber lowerBound = this.mQuantTheory.mLinArSolve.getUpperBound(this.mClausifier, affine);
        if (lowerBound.less(InfinitesimalNumber.ZERO)) {
            return InstanceValue.FALSE;
        }
        return InstanceValue.ONE_UNDEF;
    }

    private void recordSubstAgeForStats(int age, boolean isProducedByEnumeration) {
        int index;
        assert (age >= 0);
        int n = index = 32 - Integer.numberOfLeadingZeros(age);
        this.mQuantTheory.mNumInstancesOfAge[n] = this.mQuantTheory.mNumInstancesOfAge[n] + 1;
        if (isProducedByEnumeration) {
            int n2 = index;
            this.mQuantTheory.mNumInstancesOfAgeEnum[n2] = this.mQuantTheory.mNumInstancesOfAgeEnum[n2] + 1;
        }
    }

    private static enum InstanceValue {
        TRUE,
        FALSE,
        ONE_UNDEF,
        UNKNOWN_TERM,
        OTHER,
        IRRELEVANT;


        private InstanceValue combine(InstanceValue other) {
            if (this == IRRELEVANT || other == IRRELEVANT) {
                return IRRELEVANT;
            }
            if (this == TRUE || other == TRUE) {
                return TRUE;
            }
            if (this == FALSE) {
                return other;
            }
            if (other == FALSE) {
                return this;
            }
            return OTHER;
        }

        private InstanceValue negate() {
            if (this == TRUE) {
                return FALSE;
            }
            if (this == FALSE) {
                return TRUE;
            }
            return this;
        }

        private InstanceValue keepOnlyRelevant(List<InstanceValue> values) {
            for (InstanceValue val : values) {
                if (this != val) continue;
                return this;
            }
            return IRRELEVANT;
        }
    }

    private class InstantiationInfo {
        private final InstanceValue mValue;
        private final List<Term> mSubs;

        private InstantiationInfo(InstanceValue val, List<Term> subs) {
            this.mValue = val;
            this.mSubs = subs;
        }

        InstanceValue getInstValue() {
            return this.mValue;
        }

        List<Term> getSubs() {
            return this.mSubs;
        }

        public String toString() {
            return "InstInfo: [" + (Object)((Object)this.mValue) + this.mSubs + "]";
        }

        public int hashCode() {
            return this.mSubs.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof InstantiationInfo) {
                InstantiationInfo otherInfo = (InstantiationInfo)other;
                return this.mValue == otherInfo.getInstValue() && this.mSubs.equals(otherInfo.getSubs());
            }
            return false;
        }
    }

    private class TermFinder
    extends NonRecursive {
        private final List<TermVariable> mVars;
        private final List<Term> mSubstitution;
        private final Map<Term, Term> mTerms;

        TermFinder(TermVariable[] vars, List<Term> substitution) {
            this.mVars = Arrays.asList(vars);
            this.mSubstitution = substitution;
            this.mTerms = new HashMap<Term, Term>();
        }

        Term findEquivalentShared(Term term) {
            this.enqueueWalker(new FindTerm(term));
            this.run();
            return this.mTerms.get(term);
        }

        SMTAffineTerm findEquivalentAffine(SMTAffineTerm smtAff) {
            for (Term smd : smtAff.getSummands().keySet()) {
                this.enqueueWalker(new FindTerm(smd));
            }
            this.run();
            return this.buildEquivalentAffine(smtAff);
        }

        private SMTAffineTerm buildEquivalentAffine(SMTAffineTerm smtAff) {
            SMTAffineTerm instAff = new SMTAffineTerm();
            for (Map.Entry<Term, Rational> smd : smtAff.getSummands().entrySet()) {
                Term inst = this.mTerms.get(smd.getKey());
                if (inst == null) {
                    return null;
                }
                instAff.add(smd.getValue(), inst);
            }
            instAff.add(smtAff.getConstant());
            return instAff;
        }

        class FindSharedAffine
        implements NonRecursive.Walker {
            private final Term mTerm;
            private final SMTAffineTerm mSmtAff;

            FindSharedAffine(Term term, SMTAffineTerm smtAff) {
                this.mTerm = term;
                this.mSmtAff = smtAff;
            }

            @Override
            public void walk(NonRecursive engine) {
                SMTAffineTerm instAffine = TermFinder.this.buildEquivalentAffine(this.mSmtAff);
                if (instAffine != null) {
                    Term instTerm = instAffine.toTerm(InstantiationManager.this.mClausifier.getTermCompiler(), this.mTerm.getSort());
                    CCTerm ccTermRep = InstantiationManager.this.mQuantTheory.getCClosure().getCCTermRep(instTerm);
                    if (ccTermRep != null) {
                        TermFinder.this.mTerms.put(this.mTerm, ccTermRep.getFlatTerm());
                    }
                }
            }
        }

        class FindSharedAppTerm
        implements NonRecursive.Walker {
            private final Term mTerm;
            private final FunctionSymbol mFunc;
            private final Term[] mParams;

            public FindSharedAppTerm(Term term, FunctionSymbol func, Term[] params) {
                this.mTerm = term;
                this.mFunc = func;
                this.mParams = params;
            }

            @Override
            public void walk(NonRecursive engine) {
                Term[] instArgs = new Term[this.mParams.length];
                for (int i = 0; i < this.mParams.length; ++i) {
                    Term sharedArg = (Term)TermFinder.this.mTerms.get(this.mParams[i]);
                    if (sharedArg == null) {
                        return;
                    }
                    instArgs[i] = sharedArg;
                }
                Term instAppTerm = InstantiationManager.this.mClausifier.getTheory().term(this.mFunc, instArgs);
                CCTerm ccTermRep = InstantiationManager.this.mQuantTheory.getCClosure().getCCTermRep(instAppTerm);
                if (ccTermRep != null) {
                    TermFinder.this.mTerms.put(this.mTerm, ccTermRep.getFlatTerm());
                }
            }
        }

        class FindTerm
        implements NonRecursive.Walker {
            private final Term mTerm;

            public FindTerm(Term term) {
                this.mTerm = term;
            }

            @Override
            public void walk(NonRecursive engine) {
                block3: {
                    FunctionSymbol func;
                    block6: {
                        block5: {
                            block4: {
                                if (TermFinder.this.mTerms.containsKey(this.mTerm)) break block3;
                                if (this.mTerm.getFreeVars().length != 0) break block4;
                                TermFinder.this.mTerms.put(this.mTerm, this.mTerm);
                                break block3;
                            }
                            if (!(this.mTerm instanceof TermVariable)) break block5;
                            TermFinder.this.mTerms.put(this.mTerm, (Term)TermFinder.this.mSubstitution.get(TermFinder.this.mVars.indexOf(this.mTerm)));
                            break block3;
                        }
                        assert (this.mTerm instanceof ApplicationTerm);
                        ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
                        func = appTerm.getFunction();
                        if (!Clausifier.needCCTerm(appTerm)) break block6;
                        Term[] params = appTerm.getParameters();
                        TermFinder.this.enqueueWalker(new FindSharedAppTerm(this.mTerm, func, params));
                        for (Term arg : params) {
                            TermFinder.this.enqueueWalker(new FindTerm(arg));
                        }
                        break block3;
                    }
                    if (func.getName() != "+" && func.getName() != "*" && func.getName() != "-") break block3;
                    SMTAffineTerm smtAff = new SMTAffineTerm(this.mTerm);
                    TermFinder.this.enqueueWalker(new FindSharedAffine(this.mTerm, smtAff));
                    for (Term smd : smtAff.getSummands().keySet()) {
                        TermFinder.this.enqueueWalker(new FindTerm(smd));
                    }
                }
            }
        }
    }
}

