/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.List;

public class QuantAnnotation
implements IAnnotation {
    private final Term mQuantClauseTerm;
    private final TermVariable[] mVars;
    private final Term[] mSubs;
    private final Term mInstClauseTerm;
    private final QuantifierTheory.InstanceOrigin mOrigin;
    private final SourceAnnotation mSource;
    private final IProofTracker mProofTracker;

    public QuantAnnotation(QuantClause qClause, List<Term> subs, Term instTerm, QuantifierTheory.InstanceOrigin origin) {
        this.mQuantClauseTerm = qClause.getClauseWithProof();
        this.mVars = qClause.getVars();
        this.mSubs = subs.toArray(new Term[subs.size()]);
        this.mInstClauseTerm = instTerm;
        this.mOrigin = origin;
        this.mSource = qClause.getQuantSource();
        this.mProofTracker = qClause.getQuantTheory().getClausifier().getTracker();
    }

    public SourceAnnotation getSource() {
        return this.mSource;
    }

    @Override
    public Term toTerm(Clause cls, ProofRules proofRules) {
        Term quantUnitClauseProof;
        Term quantClauseLit = this.mProofTracker.getProvedTerm(this.mQuantClauseTerm);
        Theory theory = proofRules.getTheory();
        ProofLiteral[] quantClause = new ProofLiteral[]{new ProofLiteral(quantClauseLit, true)};
        Annotation quantClauseAnnot = new Annotation(":input", this.mSource.getAnnotation().isEmpty() ? null : this.mSource.getAnnotation());
        if (this.mProofTracker instanceof ProofTracker) {
            Annotation[] clauseAnnots = new Annotation[]{new Annotation(":proves", ProofRules.convertProofLiteralsToAnnotation(quantClause)), quantClauseAnnot};
            quantUnitClauseProof = theory.annotatedTerm(clauseAnnots, ((ProofTracker)this.mProofTracker).getProof(this.mQuantClauseTerm));
        } else {
            quantUnitClauseProof = proofRules.oracle(quantClause, new Annotation[]{quantClauseAnnot});
        }
        ProofLiteral[] clause = cls.toProofLiterals(proofRules);
        ProofLiteral[] instLemma = new ProofLiteral[clause.length + 1];
        instLemma[0] = new ProofLiteral(quantClauseLit, false);
        System.arraycopy(clause, 0, instLemma, 1, clause.length);
        boolean isFullProofModeActive = this.mProofTracker instanceof ProofTracker;
        Object[] subannots = new Object[isFullProofModeActive ? 5 : 3];
        subannots[0] = ":subs";
        subannots[1] = this.mSubs;
        subannots[2] = this.mOrigin.getOrigin();
        if (isFullProofModeActive) {
            subannots[3] = ":subproof";
            subannots[4] = ((ProofTracker)this.mProofTracker).getProof(this.mInstClauseTerm);
        }
        Annotation[] annots = new Annotation[]{new Annotation(":inst", subannots)};
        Term lemma = proofRules.oracle(instLemma, annots);
        return proofRules.resolutionRule(quantClauseLit, quantUnitClauseProof, lemma);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(":inst ").append(this.mQuantClauseTerm.toString());
        sb.append(" :vars ").append(this.mVars.toString());
        sb.append(" :subs ").append(this.mSubs.toString());
        return sb.toString();
    }
}

