/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuantClause {
    private final QuantifierTheory mQuantTheory;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final SourceAnnotation mQuantSource;
    private final Term mClauseWithProof;
    private final TermVariable[] mVars;
    private final VarInfo[] mVarInfos;
    private final LinkedHashMap<Term, Term>[] mInterestingTermsForVars;

    QuantClause(TermVariable[] vars, Literal[] groundLits, QuantLiteral[] quantLits, QuantifierTheory quantTheory, SourceAnnotation source, Term clauseWithProof) {
        int i;
        assert (quantLits.length != 0);
        this.mQuantTheory = quantTheory;
        this.mGroundLits = groundLits;
        this.mQuantLits = this.mQuantTheory.getLiteralCopies(quantLits, this);
        this.mSource = source;
        this.mQuantSource = new SourceAnnotation(source, true);
        this.mClauseWithProof = clauseWithProof;
        this.mVars = vars;
        this.mVarInfos = new VarInfo[this.mVars.length];
        for (i = 0; i < this.mVars.length; ++i) {
            this.mVarInfos[i] = new VarInfo();
        }
        this.collectVarInfos();
        this.mInterestingTermsForVars = new LinkedHashMap[this.mVars.length];
        for (i = 0; i < this.mVars.length; ++i) {
            this.mInterestingTermsForVars[i] = new LinkedHashMap();
        }
    }

    public void updateInterestingTermsAllVars() {
        for (int i = 0; i < this.mVars.length; ++i) {
            this.collectBoundAndDefaultTerms(i);
            if (this.mVars[i].getSort().getName() == "Bool") continue;
            this.updateInterestingTermsForFuncArgs(this.mVars[i], i);
        }
        this.synchronizeInterestingTermsAllVars();
    }

    public boolean hasTrueGroundLits() {
        for (Literal lit : this.mGroundLits) {
            if (lit.getAtom().getDecideStatus() != lit) continue;
            return true;
        }
        return false;
    }

    public QuantifierTheory getQuantTheory() {
        return this.mQuantTheory;
    }

    public Literal[] getGroundLits() {
        return this.mGroundLits;
    }

    public QuantLiteral[] getQuantLits() {
        return this.mQuantLits;
    }

    public SourceAnnotation getSource() {
        return this.mSource;
    }

    public SourceAnnotation getQuantSource() {
        return this.mQuantSource;
    }

    public TermVariable[] getVars() {
        return this.mVars;
    }

    public Set<Term> getGroundBounds(TermVariable var) {
        LinkedHashSet<Term> bounds = new LinkedHashSet<Term>();
        bounds.addAll(this.mVarInfos[this.getVarIndex(var)].mUpperGroundBounds);
        bounds.addAll(this.mVarInfos[this.getVarIndex(var)].mLowerGroundBounds);
        return bounds;
    }

    public Set<TermVariable> getVarBounds(TermVariable var) {
        LinkedHashSet<TermVariable> bounds = new LinkedHashSet<TermVariable>();
        bounds.addAll(this.mVarInfos[this.getVarIndex(var)].mUpperVarBounds);
        bounds.addAll(this.mVarInfos[this.getVarIndex(var)].mLowerVarBounds);
        return bounds;
    }

    public LinkedHashMap<Term, Term>[] getInterestingTerms() {
        return this.mInterestingTermsForVars;
    }

    public String toString() {
        return Arrays.toString(this.mGroundLits).concat(Arrays.toString(this.mQuantLits));
    }

    public Term toTerm(Theory theory) {
        int i;
        int groundLength = this.mGroundLits.length;
        int quantLength = this.mQuantLits.length;
        Term[] litTerms = new Term[groundLength + quantLength];
        for (i = 0; i < groundLength; ++i) {
            litTerms[i] = this.mGroundLits[i].getSMTFormula(theory);
        }
        for (i = 0; i < quantLength; ++i) {
            litTerms[i + groundLength] = this.mQuantLits[i].getTerm();
        }
        return theory.or(litTerms);
    }

    public Term getClauseWithProof() {
        return this.mClauseWithProof;
    }

    void clearInterestingTerms() {
        for (int i = 0; i < this.mVars.length; ++i) {
            this.mInterestingTermsForVars[i].clear();
        }
    }

    int getVarIndex(TermVariable var) {
        return Arrays.asList(this.mVars).indexOf(var);
    }

    private void collectVarInfos() {
        for (QuantLiteral lit : this.mQuantLits) {
            QuantLiteral atom = lit.getAtom();
            if (atom instanceof QuantBoundConstraint) {
                if (lit.isArithmetical()) {
                    VarInfo info;
                    Term[] termLtTerm = QuantUtil.getArithmeticalTermLtTerm(lit, this.mQuantTheory.getClausifier().getTermCompiler());
                    if (termLtTerm[0] instanceof TermVariable) {
                        TermVariable lowerVar = (TermVariable)termLtTerm[0];
                        info = this.mVarInfos[this.getVarIndex(lowerVar)];
                        if (termLtTerm[1] instanceof TermVariable) {
                            info.addUpperVarBound((TermVariable)termLtTerm[1]);
                        } else {
                            assert (((Term)termLtTerm[1]).getFreeVars().length == 0);
                            info.addUpperGroundBound((Term)termLtTerm[1]);
                        }
                    }
                    if (!(termLtTerm[1] instanceof TermVariable)) continue;
                    TermVariable upperVar = (TermVariable)termLtTerm[1];
                    info = this.mVarInfos[this.getVarIndex(upperVar)];
                    if (termLtTerm[0] instanceof TermVariable) {
                        info.addLowerVarBound((TermVariable)termLtTerm[0]);
                        continue;
                    }
                    assert (((Term)termLtTerm[0]).getFreeVars().length == 0);
                    info.addLowerGroundBound((Term)termLtTerm[0]);
                    continue;
                }
                for (Term smd : ((QuantBoundConstraint)atom).getAffineTerm().getSummands().keySet()) {
                    if (!(smd instanceof ApplicationTerm) || smd.getFreeVars().length == 0) continue;
                    this.addVarArgInfo((ApplicationTerm)smd);
                }
                continue;
            }
            assert (atom instanceof QuantEquality);
            QuantEquality eq = (QuantEquality)atom;
            Term lhs = eq.getLhs();
            Term rhs = eq.getRhs();
            if (lit.isArithmetical()) {
                assert (lhs instanceof TermVariable && lhs.getSort().getName() == "Int" && rhs.getFreeVars().length == 0);
                int pos = this.getVarIndex((TermVariable)lhs);
                VarInfo varInfo = this.mVarInfos[pos];
                SMTAffineTerm lowerAffine = new SMTAffineTerm(rhs);
                lowerAffine.add(Rational.MONE);
                SMTAffineTerm upperAffine = new SMTAffineTerm(rhs);
                upperAffine.add(Rational.ONE);
                TermCompiler compiler = this.mQuantTheory.getClausifier().getTermCompiler();
                Term lowerBound = lowerAffine.toTerm(compiler, rhs.getSort());
                Term upperBound = upperAffine.toTerm(compiler, rhs.getSort());
                varInfo.addLowerGroundBound(lowerBound);
                varInfo.addUpperGroundBound(upperBound);
                continue;
            }
            if (!(lhs instanceof TermVariable) && lhs.getFreeVars().length != 0) {
                assert (lhs instanceof ApplicationTerm);
                this.addVarArgInfo((ApplicationTerm)lhs);
            }
            if (rhs instanceof TermVariable || rhs.getFreeVars().length == 0) continue;
            assert (rhs instanceof ApplicationTerm);
            this.addVarArgInfo((ApplicationTerm)rhs);
        }
    }

    private void addVarArgInfo(ApplicationTerm qTerm) {
        block8: {
            FunctionSymbol func;
            block9: {
                Term[] args;
                block7: {
                    func = qTerm.getFunction();
                    args = qTerm.getParameters();
                    if (func.isInterpreted()) break block7;
                    for (int i = 0; i < args.length; ++i) {
                        Term arg = args[i];
                        if (arg instanceof TermVariable) {
                            int index = this.getVarIndex((TermVariable)arg);
                            VarInfo varInfo = this.mVarInfos[index];
                            varInfo.addPosition(func, i);
                            continue;
                        }
                        if (arg.getFreeVars().length == 0) continue;
                        assert (arg instanceof ApplicationTerm);
                        this.addVarArgInfo((ApplicationTerm)arg);
                    }
                    break block8;
                }
                if (func.getName() != "select" && func.getName() != "store") break block9;
                for (int i = 0; i < args.length; ++i) {
                    Term arg = args[i];
                    if (i == 0 && arg instanceof TermVariable) continue;
                    if (i != 0 && arg instanceof TermVariable) {
                        int index = this.getVarIndex((TermVariable)arg);
                        VarInfo varInfo = this.mVarInfos[index];
                        varInfo.addArrayTerm(qTerm);
                        continue;
                    }
                    if (arg.getFreeVars().length == 0) continue;
                    assert (arg instanceof ApplicationTerm);
                    this.addVarArgInfo((ApplicationTerm)arg);
                }
                break block8;
            }
            if (func.getName() != "+" && func.getName() != "-" && func.getName() != "*") break block8;
            SMTAffineTerm affine = new SMTAffineTerm(qTerm);
            for (Term smd : affine.getSummands().keySet()) {
                if (!(smd instanceof ApplicationTerm)) continue;
                this.addVarArgInfo((ApplicationTerm)smd);
            }
        }
    }

    private void collectBoundAndDefaultTerms(int varPos) {
        this.addAllInteresting(this.mInterestingTermsForVars[varPos], this.mVarInfos[varPos].mLowerGroundBounds);
        this.addAllInteresting(this.mInterestingTermsForVars[varPos], this.mVarInfos[varPos].mUpperGroundBounds);
        if (this.mVars[varPos].getSort().getName() == "Bool") {
            ApplicationTerm sharedTrue = this.mQuantTheory.getTheory().mTrue;
            ApplicationTerm sharedFalse = this.mQuantTheory.getTheory().mFalse;
            this.mInterestingTermsForVars[varPos].put(sharedTrue, sharedTrue);
            this.mInterestingTermsForVars[varPos].put(sharedFalse, sharedFalse);
        } else {
            Term lambda = this.mQuantTheory.getLambda(this.mVars[varPos].getSort());
            this.mInterestingTermsForVars[varPos].put(lambda, lambda);
        }
    }

    private void synchronizeInterestingTermsAllVars() {
        boolean changed = true;
        while (changed && !this.mQuantTheory.getEngine().isTerminationRequested()) {
            changed = false;
            for (int i = 0; i < this.mVars.length; ++i) {
                for (TermVariable t : this.getVarBounds(this.mVars[i])) {
                    int j = this.getVarIndex(t);
                    changed = this.addAllInteresting(this.mInterestingTermsForVars[i], this.mInterestingTermsForVars[j].values());
                }
            }
        }
    }

    private void updateInterestingTermsForFuncArgs(TermVariable var, int varNum) {
        FunctionSymbol func;
        VarInfo info = this.mVarInfos[this.getVarIndex(var)];
        assert (info != null);
        LinkedHashSet<Term> interestingTerms = new LinkedHashSet<Term>();
        for (Map.Entry entry : info.mFuncArgPositions.entrySet()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return;
            }
            func = (FunctionSymbol)entry.getKey();
            BitSet pos = (BitSet)entry.getValue();
            int i = pos.nextSetBit(0);
            while (i >= 0) {
                Collection<CCTerm> argTerms = this.mQuantTheory.mCClosure.getArgTermsForFunc(func, i);
                if (argTerms != null) {
                    for (CCTerm ccTerm : argTerms) {
                        interestingTerms.add(ccTerm.getFlatTerm());
                    }
                }
                i = pos.nextSetBit(i + 1);
            }
        }
        for (ApplicationTerm arrayFuncTerm : info.mArrayTermsWithVar) {
            CCTerm weakRep;
            func = arrayFuncTerm.getFunction();
            String funcName = func.getName();
            Term[] args = arrayFuncTerm.getParameters();
            Term array = args[0];
            CCTerm arrayCC = this.mQuantTheory.getCClosure().getCCTermRep(array);
            CCTerm cCTerm = weakRep = arrayCC == null ? null : this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(arrayCC);
            if (args[1] == var) {
                Sort[] storeSorts = funcName == "store" ? func.getParameterSorts() : new Sort[]{func.getParameterSorts()[0], func.getParameterSorts()[1], func.getReturnSort()};
                FunctionSymbol storeFun = this.mQuantTheory.getTheory().getFunction("store", storeSorts);
                List<CCTerm> allStores = this.mQuantTheory.getCClosure().getAllFuncApps(storeFun);
                for (CCTerm st : allStores) {
                    CCTerm stArr = ArrayTheory.getArrayFromStore((CCAppTerm)st);
                    if (!(weakRep == null ? stArr.getFlatTerm().getSort() == array.getSort() : weakRep == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(stArr))) continue;
                    Term indexTerm = ArrayTheory.getIndexFromStore((CCAppTerm)st).getFlatTerm();
                    interestingTerms.add(indexTerm);
                    if (funcName != "select" || var.getSort().getName() != "Int" || QuantUtil.isLambda(indexTerm)) continue;
                    for (Rational offset : new Rational[]{Rational.ONE, Rational.MONE}) {
                        SMTAffineTerm idxPlusMinusOneAff = new SMTAffineTerm(indexTerm);
                        idxPlusMinusOneAff.add(offset);
                        Term shared = idxPlusMinusOneAff.toTerm(this.mQuantTheory.getClausifier().getTermCompiler(), indexTerm.getSort());
                        interestingTerms.add(shared);
                    }
                }
                if (funcName == "select") {
                    Sort[] selectSorts = func.getParameterSorts();
                    FunctionSymbol selectFun = this.mQuantTheory.getTheory().getFunction("select", selectSorts);
                    List<CCTerm> allSelects = this.mQuantTheory.getCClosure().getAllFuncApps(selectFun);
                    for (CCTerm sel : allSelects) {
                        CCTerm selArr = ArrayTheory.getArrayFromSelect((CCAppTerm)sel);
                        if (!(weakRep == null ? selArr.getFlatTerm().getSort() == array.getSort() : weakRep == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(selArr))) continue;
                        CCTerm index = ArrayTheory.getIndexFromSelect((CCAppTerm)sel);
                        interestingTerms.add(index.getFlatTerm());
                    }
                }
            }
            if (funcName != "store" || args[2] != var) continue;
            Sort[] selectSorts = Arrays.copyOf(func.getParameterSorts(), 2);
            FunctionSymbol selectFun = this.mQuantTheory.getTheory().getFunction("select", selectSorts);
            List<CCTerm> allSelects = this.mQuantTheory.getCClosure().getAllFuncApps(selectFun);
            for (CCTerm sel : allSelects) {
                CCTerm selArr = ArrayTheory.getArrayFromSelect((CCAppTerm)sel);
                if (!(weakRep == null ? selArr.getFlatTerm().getSort() == array.getSort() : weakRep == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(selArr))) continue;
                interestingTerms.add(sel.getFlatTerm());
            }
        }
        this.addAllInteresting(this.mInterestingTermsForVars[varNum], interestingTerms);
    }

    private boolean addAllInteresting(Map<Term, Term> interestingTerms, Collection<Term> newTerms) {
        boolean changed = false;
        for (Term newTerm : newTerms) {
            Term rep = this.mQuantTheory.getRepresentativeTerm(newTerm);
            if (interestingTerms.containsKey(rep)) continue;
            interestingTerms.put(rep, newTerm);
            changed = true;
        }
        return changed;
    }

    private class VarInfo {
        private final Map<FunctionSymbol, BitSet> mFuncArgPositions = new LinkedHashMap<FunctionSymbol, BitSet>();
        private final Set<ApplicationTerm> mArrayTermsWithVar = new LinkedHashSet<ApplicationTerm>();
        private final Set<Term> mLowerGroundBounds = new LinkedHashSet<Term>();
        private final Set<Term> mUpperGroundBounds = new LinkedHashSet<Term>();
        private final Set<TermVariable> mLowerVarBounds = new LinkedHashSet<TermVariable>();
        private final Set<TermVariable> mUpperVarBounds = new LinkedHashSet<TermVariable>();

        VarInfo() {
        }

        void addPosition(FunctionSymbol func, int pos) {
            if (this.mFuncArgPositions.containsKey(func)) {
                BitSet occs = this.mFuncArgPositions.get(func);
                occs.set(pos);
            } else {
                BitSet occs = new BitSet(func.getParameterSorts().length);
                occs.set(pos);
                this.mFuncArgPositions.put(func, occs);
            }
        }

        void addArrayTerm(ApplicationTerm term) {
            this.mArrayTermsWithVar.add(term);
        }

        void addLowerGroundBound(Term lowerBound) {
            this.mLowerGroundBounds.add(lowerBound);
        }

        void addUpperGroundBound(Term upperBound) {
            this.mUpperGroundBounds.add(upperBound);
        }

        void addLowerVarBound(TermVariable lower) {
            this.mLowerVarBounds.add(lower);
        }

        void addUpperVarBound(TermVariable lower) {
            this.mUpperVarBounds.add(lower);
        }
    }
}

