/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class QuantUtil {
    private QuantUtil() {
    }

    public static boolean isEssentiallyUninterpreted(Term term) {
        if (term.getFreeVars().length == 0) {
            return true;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol func = appTerm.getFunction();
            if (!func.isInterpreted()) {
                for (Term arg : appTerm.getParameters()) {
                    if (arg instanceof TermVariable || QuantUtil.isEssentiallyUninterpreted(arg)) continue;
                    return false;
                }
                return true;
            }
            if (func.getName() == "select") {
                Term[] params = appTerm.getParameters();
                if (params[0] instanceof TermVariable || !QuantUtil.isEssentiallyUninterpreted(params[0])) {
                    return false;
                }
                return params[1] instanceof TermVariable || QuantUtil.isEssentiallyUninterpreted(params[1]);
            }
            if (func.getName() == "+" || func.getName() == "-" || func.getName() == "*") {
                SMTAffineTerm affineTerm = SMTAffineTerm.create(term);
                for (Term summand : affineTerm.getSummands().keySet()) {
                    if (QuantUtil.isEssentiallyUninterpreted(summand)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsArithmeticOnQuantOnlyAtTopLevel(QuantLiteral atom) {
        assert (!atom.isNegated());
        if (atom instanceof QuantBoundConstraint) {
            return QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(((QuantBoundConstraint)atom).getAffineTerm());
        }
        QuantEquality eq = (QuantEquality)atom;
        SMTAffineTerm lhsAff = new SMTAffineTerm(eq.getLhs());
        if (QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(lhsAff)) {
            SMTAffineTerm rhsAff = new SMTAffineTerm(eq.getRhs());
            return QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(rhsAff);
        }
        return false;
    }

    public static boolean containsAppTermsForEachVar(QuantLiteral atom) {
        assert (!atom.isNegated());
        HashSet<Term> allSummandsWithoutCoeffs = new HashSet<Term>();
        if (atom instanceof QuantEquality) {
            QuantEquality eq = (QuantEquality)atom;
            Term lhs = eq.getLhs();
            Term rhs = eq.getRhs();
            SMTAffineTerm lhsAff = new SMTAffineTerm(lhs);
            SMTAffineTerm rhsAff = new SMTAffineTerm(rhs);
            allSummandsWithoutCoeffs.addAll(lhsAff.getSummands().keySet());
            allSummandsWithoutCoeffs.addAll(rhsAff.getSummands().keySet());
        } else {
            QuantBoundConstraint bc = (QuantBoundConstraint)atom;
            allSummandsWithoutCoeffs.addAll(bc.getAffineTerm().getSummands().keySet());
        }
        HashSet<Term> varTerms = new HashSet<Term>();
        HashSet<TermVariable> varsInApps = new HashSet<TermVariable>();
        for (Term smd : allSummandsWithoutCoeffs) {
            if (smd instanceof TermVariable) {
                varTerms.add(smd);
                continue;
            }
            if (smd.getFreeVars().length == 0) continue;
            varsInApps.addAll(Arrays.asList(smd.getFreeVars()));
        }
        varTerms.removeAll(varsInApps);
        return varTerms.isEmpty();
    }

    public static boolean isVarEq(QuantLiteral atom) {
        assert (!atom.isNegated());
        if (atom instanceof QuantEquality) {
            QuantEquality eq = (QuantEquality)atom;
            return eq.getLhs() instanceof TermVariable && eq.getRhs() instanceof TermVariable;
        }
        return false;
    }

    public static Term[] getArithmeticalTermLtTerm(QuantLiteral arithLit, TermCompiler compiler) {
        assert (arithLit.isArithmetical());
        Term t1 = null;
        Term t2 = null;
        if (arithLit instanceof QuantEquality) {
            QuantEquality eq = (QuantEquality)arithLit;
            assert (eq.getLhs() instanceof TermVariable && eq.getRhs().getFreeVars().length == 0);
            t1 = eq.getLhs();
            t2 = eq.getRhs();
        } else {
            assert (arithLit.isNegated());
            QuantBoundConstraint bc = (QuantBoundConstraint)arithLit.getAtom();
            TermVariable lowerVar = null;
            TermVariable upperVar = null;
            SMTAffineTerm remainder = new SMTAffineTerm();
            SMTAffineTerm aff = bc.getAffineTerm();
            for (Map.Entry<Term, Rational> smd : aff.getSummands().entrySet()) {
                if (smd.getKey() instanceof TermVariable) {
                    if (smd.getValue().signum() < 0) {
                        assert (t1 == null);
                        lowerVar = (TermVariable)smd.getKey();
                        continue;
                    }
                    assert (upperVar == null);
                    upperVar = (TermVariable)smd.getKey();
                    continue;
                }
                remainder.add(smd.getValue(), smd.getKey());
            }
            remainder.add(aff.getConstant());
            assert (lowerVar != null || upperVar != null);
            if (lowerVar != null && upperVar != null) {
                assert (remainder.isConstant() && remainder.getConstant() == Rational.ZERO);
                t1 = lowerVar;
                t2 = upperVar;
            } else if (lowerVar != null) {
                t1 = lowerVar;
                t2 = remainder.toTerm(compiler, lowerVar.getSort());
            } else {
                remainder.negate();
                t1 = remainder.toTerm(compiler, upperVar.getSort());
                t2 = upperVar;
            }
        }
        return new Term[]{t1, t2};
    }

    public static boolean containsArithmeticOnQuantOnlyAtTopLevel(SMTAffineTerm at) {
        for (Term smd : at.getSummands().keySet()) {
            if (smd instanceof TermVariable || QuantUtil.isSimpleEU(smd)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimpleEU(Term term) {
        if (term.getFreeVars().length != 0) {
            if (term instanceof TermVariable) {
                return false;
            }
            assert (term instanceof ApplicationTerm);
            ApplicationTerm at = (ApplicationTerm)term;
            FunctionSymbol func = at.getFunction();
            if (func.isInterpreted() && !func.getName().equals("select")) {
                return false;
            }
            Term[] args = at.getParameters();
            if (func.getName().equals("select")) {
                if (!QuantUtil.isSimpleEU(args[0])) {
                    return false;
                }
                if (!(args[1] instanceof TermVariable) && !QuantUtil.isSimpleEU(args[1])) {
                    return false;
                }
            } else {
                for (Term arg : args) {
                    if (arg instanceof TermVariable || QuantUtil.isSimpleEU(arg)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAuxApplication(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol fsym = ((ApplicationTerm)term).getFunction();
            return fsym.isIntern() && fsym.getName().startsWith("@AUX");
        }
        return false;
    }

    public static boolean isLambda(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol fsym = ((ApplicationTerm)term).getFunction();
            return fsym.isIntern() && fsym.getName().startsWith("@0");
        }
        return false;
    }
}

