/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.DestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstantiationManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAuxEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class QuantifierTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final LogProxy mLogger;
    private final Theory mTheory;
    private final DPLLEngine mEngine;
    final CClosure mCClosure;
    final LinArSolve mLinArSolve;
    private final EMatching mEMatching;
    private final InstantiationManager mInstantiationManager;
    private final Map<Sort, Term> mLambdas;
    private final ScopedArrayList<QuantClause> mQuantClauses;
    private final Map<Literal, Set<InstClause>> mPendingInstances;
    long mNumInstancesProduced;
    long mNumInstancesDER;
    long mNumInstancesProducedConfl;
    long mNumInstancesProducedEM;
    long mNumInstancesProducedEnum;
    private long mNumCheckpoints;
    private long mNumCheckpointsWithNewEval;
    private long mNumConflicts;
    private long mNumProps;
    private long mNumFinalcheck;
    private long mCheckpointTime;
    private long mFindEmatchingTime;
    private long mFinalCheckTime;
    private long mEMatchingTime;
    private long mDawgTime;
    int[] mNumInstancesOfAge;
    int[] mNumInstancesOfAgeEnum;
    InstantiationMethod mInstantiationMethod;
    boolean mUseUnknownTermValueInDawgs;
    boolean mPropagateNewAux;
    boolean mPropagateNewTerms;

    public QuantifierTheory(Theory th, DPLLEngine engine, Clausifier clausifier, InstantiationMethod instMethod, boolean useUnknownTermDawgs, boolean propagateNewTerms, boolean propagateNewAux) {
        this.mClausifier = clausifier;
        this.mLogger = clausifier.getLogger();
        this.mTheory = th;
        this.mEngine = engine;
        this.mInstantiationMethod = instMethod;
        this.mUseUnknownTermValueInDawgs = useUnknownTermDawgs;
        this.mPropagateNewTerms = propagateNewTerms;
        this.mPropagateNewAux = propagateNewAux;
        this.mCClosure = clausifier.getCClosure();
        this.mLinArSolve = clausifier.getLASolver();
        this.mEMatching = new EMatching(this);
        this.mInstantiationManager = new InstantiationManager(this);
        this.mLambdas = new HashMap<Sort, Term>();
        this.mQuantClauses = new ScopedArrayList();
        this.mPendingInstances = new LinkedHashMap<Literal, Set<InstClause>>();
        this.mNumInstancesOfAge = new int[32];
        this.mNumInstancesOfAgeEnum = new int[32];
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (this.mQuantClauses.isEmpty()) {
            assert (this.mPendingInstances.isEmpty());
            return null;
        }
        if (this.mPendingInstances.containsKey(literal)) {
            for (InstClause instClause : this.mPendingInstances.remove(literal)) {
                assert (instClause.mLits.contains(literal));
                for (Literal otherLit : instClause.mLits) {
                    Set<InstClause> clauses;
                    if (otherLit == literal || (clauses = this.mPendingInstances.get(otherLit)) == null) continue;
                    clauses.remove(instClause);
                    if (!clauses.isEmpty()) continue;
                    this.mPendingInstances.remove(otherLit);
                }
            }
        }
        if (this.mPendingInstances.containsKey(literal.negate())) {
            for (InstClause instClause : this.mPendingInstances.remove(literal.negate())) {
                assert (instClause.mNumUndefLits > 0);
                --instClause.mNumUndefLits;
                if (!instClause.isConflict()) continue;
                this.mLogger.debug("Quant conflict: %s", instClause);
                ++this.mNumConflicts;
                return instClause.toClause(this.mEngine.isProofGenerationEnabled());
            }
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    @Override
    public Clause checkpoint() {
        long time = System.nanoTime();
        ++this.mNumCheckpoints;
        Clause conflict = null;
        if (!this.mQuantClauses.isEmpty()) {
            Set<InstClause> potentiallyInterestingInstances;
            if (!this.mPendingInstances.isEmpty()) {
                return null;
            }
            switch (this.mInstantiationMethod) {
                case E_MATCHING_CONFLICT: {
                    ++this.mNumCheckpointsWithNewEval;
                    this.mEMatching.run();
                    potentiallyInterestingInstances = this.mInstantiationManager.findConflictAndUnitInstancesWithEMatching();
                    this.mFindEmatchingTime += System.nanoTime() - time;
                    break;
                }
                case AUF_CONFLICT: {
                    ++this.mNumCheckpointsWithNewEval;
                    potentiallyInterestingInstances = this.mInstantiationManager.findConflictAndUnitInstances();
                    break;
                }
                case E_MATCHING_EAGER: {
                    ++this.mNumCheckpointsWithNewEval;
                    this.mEMatching.run();
                    potentiallyInterestingInstances = this.mInstantiationManager.computeEMatchingInstances();
                    this.mFindEmatchingTime += System.nanoTime() - time;
                    break;
                }
                case E_MATCHING_LAZY: {
                    potentiallyInterestingInstances = null;
                    break;
                }
                case E_MATCHING_CONFLICT_LAZY: {
                    potentiallyInterestingInstances = null;
                    break;
                }
                default: {
                    throw new InternalError("Unknown instantiation method");
                }
            }
            conflict = this.addInstClausesToPending(potentiallyInterestingInstances);
            if (conflict != null) {
                this.mLogger.debug("Quant conflict: %s", conflict);
                this.mEngine.learnClause(conflict);
                ++this.mNumConflicts;
            }
        }
        this.mCheckpointTime += System.nanoTime() - time;
        return conflict;
    }

    @Override
    public Clause computeConflictClause() {
        long time = System.nanoTime();
        ++this.mNumFinalcheck;
        assert (this.mPendingInstances.isEmpty());
        Clause conflict = null;
        if (!this.mQuantClauses.isEmpty()) {
            Set<Object> potentiallyInterestingInstances = new LinkedHashSet();
            boolean foundNonSat = false;
            if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_LAZY) {
                this.mEMatching.run();
                potentiallyInterestingInstances = this.mInstantiationManager.computeEMatchingInstances();
                this.mFindEmatchingTime += System.nanoTime() - time;
                for (InstClause instClause : potentiallyInterestingInstances) {
                    if (instClause.countAndSetUndefLits() == -1) continue;
                    foundNonSat = true;
                    break;
                }
            } else if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_CONFLICT_LAZY) {
                this.mEMatching.run();
                potentiallyInterestingInstances = this.mInstantiationManager.findConflictAndUnitInstancesWithEMatching();
                this.mFindEmatchingTime += System.nanoTime() - time;
                for (InstClause instClause : potentiallyInterestingInstances) {
                    if (instClause.countAndSetUndefLits() == -1) continue;
                    foundNonSat = true;
                    break;
                }
            }
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            if (potentiallyInterestingInstances.isEmpty() || !foundNonSat) {
                potentiallyInterestingInstances = this.mInstantiationManager.instantiateSomeNotSat();
            }
            if ((conflict = this.addInstClausesToPending(potentiallyInterestingInstances)) != null) {
                ++this.mNumConflicts;
                this.mEngine.learnClause(conflict);
            }
        }
        this.mFinalCheckTime += System.nanoTime() - time;
        return conflict;
    }

    @Override
    public Literal getPropagatedLiteral() {
        if (this.mQuantClauses.isEmpty()) {
            assert (this.mPendingInstances.isEmpty());
            return null;
        }
        for (Map.Entry<Literal, Set<InstClause>> entry : this.mPendingInstances.entrySet()) {
            if (this.mEngine.isTerminationRequested()) {
                return null;
            }
            Literal lit = entry.getKey();
            for (InstClause inst : entry.getValue()) {
                if (inst.isUnit()) {
                    Clause expl = inst.toClause(this.mEngine.isProofGenerationEnabled());
                    lit.getAtom().mExplanation = expl;
                    this.mEngine.learnClause(expl);
                    ++this.mNumProps;
                    this.mLogger.debug("Quant Prop: %s Reason: %s", lit, lit.getAtom().mExplanation);
                    return lit;
                }
                if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_EAGER || this.mInstantiationMethod == InstantiationMethod.E_MATCHING_LAZY) continue;
                this.mLogger.debug("Not propagated: %s Clause: %s", lit, inst.mLits);
            }
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        assert (false) : "Should never be called.";
        return null;
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void printStatistics(LogProxy logger) {
        logger.info("Quant: DER produced %d ground clause(s).", this.mNumInstancesDER);
        logger.info("Quant: Instances produced: %d (Conflict/Unit: %d, E-Matching: %d, Enumeration: %d)", this.mNumInstancesProduced, this.mNumInstancesProducedConfl, this.mNumInstancesProducedEM, this.mNumInstancesProducedEnum);
        logger.info("Quant: Subs of age 0, 1, 2-3, 4-7, ... : %s, (Enumeration: %s)", Arrays.toString(this.mNumInstancesOfAge), Arrays.toString(this.mNumInstancesOfAgeEnum));
        logger.info("Quant: Conflicts: %d Props: %d Checkpoints (with new evaluation): %d (%d) Final Checks: %d", this.mNumConflicts, this.mNumProps, this.mNumCheckpoints, this.mNumCheckpointsWithNewEval, this.mNumFinalcheck);
        logger.info("Quant times: Checkpoint: %d.%03d Find with E-matching: %d.%03d E-Matching: %d.%03d Dawg: %d.%03d Final Check: %d.%03d", this.mCheckpointTime / 1000L / 1000L, this.mCheckpointTime / 1000L % 1000L, this.mFindEmatchingTime / 1000L / 1000L, this.mFindEmatchingTime / 1000L % 1000L, this.mEMatchingTime / 1000L / 1000L, this.mEMatchingTime / 1000L % 1000L, this.mDawgTime / 1000L / 1000L, this.mDawgTime / 1000L % 1000L, this.mFinalCheckTime / 1000L / 1000L, this.mFinalCheckTime / 1000L % 1000L);
    }

    @Override
    public void dumpModel(LogProxy logger) {
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void backtrackAll() {
        this.mEMatching.removeAllTriggers();
        this.mInstantiationManager.resetInterestingTerms();
        this.mPendingInstances.clear();
    }

    @Override
    public void backtrackStart() {
        this.mPendingInstances.clear();
    }

    @Override
    public Clause backtrackComplete() {
        int decisionLevel = this.mClausifier.getEngine().getDecideLevel();
        this.mEMatching.undo(decisionLevel);
        this.mInstantiationManager.resetInterestingTerms();
        this.mInstantiationManager.resetSubsAgeForFinalCheck();
        return null;
    }

    @Override
    public void restart(int iteration) {
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
    }

    @Override
    public void push() {
        this.mQuantClauses.beginScope();
    }

    @Override
    public void pop() {
        assert (this.mPendingInstances.isEmpty());
        this.mInstantiationManager.removeAllInstClauses();
        this.mEMatching.removeAllTriggers();
        for (QuantClause quantClause : this.mQuantClauses.currentScope()) {
            this.mInstantiationManager.removeClause(quantClause);
            this.mEMatching.removeClause(quantClause);
        }
        this.mQuantClauses.endScope();
        this.mEMatching.reAddClauses(this.mQuantClauses);
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":Quant", new Object[][]{{"DER ground results", this.mNumInstancesDER}, {"Instances produced", this.mNumInstancesProduced}, {"thereof by conflict/unit search", this.mNumInstancesProducedConfl}, {"and by E-matching", this.mNumInstancesProducedEM}, {"and by enumeration", this.mNumInstancesProducedEnum}, {"Subs of age 0, 1, 2-3, 4-7, ...", Arrays.toString(this.mNumInstancesOfAge)}, {"thereof for enumeration", Arrays.toString(this.mNumInstancesOfAgeEnum)}, {"Conflicts", this.mNumConflicts}, {"Propagations", this.mNumProps}, {"Checkpoints", this.mNumCheckpoints}, {"Checkpoints with new evaluation", this.mNumCheckpointsWithNewEval}, {"Final Checks", this.mNumFinalcheck}, {"Times", new Object[][]{{"Checkpoint", this.mCheckpointTime}, {"Find E-matching", this.mFindEmatchingTime}, {"E-Matching", this.mEMatchingTime}, {"Final Check", this.mFinalCheckTime}}}}};
    }

    public QuantAuxEquality createAuxLiteral(Term auxTerm, Term definingTerm, SourceAnnotation source) {
        QuantAuxEquality atom = new QuantAuxEquality(auxTerm, this.mTheory.mTrue, definingTerm);
        atom.negate().mIsEssentiallyUninterpreted = true;
        atom.mIsEssentiallyUninterpreted = true;
        return atom;
    }

    public ILiteral createAuxFalseLiteral(QuantAuxEquality auxTrueLit, SourceAnnotation source) {
        Term auxTerm = auxTrueLit.getLhs();
        QuantAuxEquality atom = new QuantAuxEquality(auxTerm, this.mTheory.mFalse, auxTrueLit.getDefinition());
        atom.negate().mIsEssentiallyUninterpreted = true;
        atom.mIsEssentiallyUninterpreted = true;
        return atom;
    }

    public QuantLiteral getQuantEquality(Term lhs, Term rhs, SourceAnnotation source) {
        Term newRhs;
        Term newLhs;
        block12: {
            block11: {
                TermVariable rightVar;
                newLhs = lhs;
                newRhs = rhs;
                if (lhs.getSort().isNumericSort()) break block11;
                TermVariable leftVar = lhs instanceof TermVariable ? (TermVariable)lhs : null;
                TermVariable termVariable = rightVar = rhs instanceof TermVariable ? (TermVariable)rhs : null;
                if (leftVar != null || rightVar == null) break block12;
                newLhs = rightVar;
                newRhs = lhs;
                break block12;
            }
            SMTAffineTerm linAdded = SMTAffineTerm.create(lhs);
            linAdded.add(Rational.MONE, SMTAffineTerm.create(rhs));
            linAdded.div(linAdded.getGcd());
            Rational fac = Rational.ONE;
            TermCompiler compiler = this.mClausifier.getTermCompiler();
            for (Term smd : linAdded.getSummands().keySet()) {
                if (!(smd instanceof TermVariable)) continue;
                fac = linAdded.getSummands().get(smd);
                if (smd.getSort().getName() == "Real") {
                    newLhs = smd;
                    linAdded.add(fac.negate(), smd);
                    linAdded.div(fac.negate());
                    newRhs = linAdded.toTerm(compiler, lhs.getSort());
                    break;
                }
                if (fac.abs() != Rational.ONE) continue;
                newLhs = smd;
                linAdded.add(fac.negate(), smd);
                if (fac == Rational.ONE) {
                    linAdded.negate();
                }
                newRhs = linAdded.toTerm(compiler, lhs.getSort());
                break;
            }
        }
        Term newTerm = this.mTheory.term("=", newLhs, newRhs);
        QuantLiteral atom = (QuantLiteral)this.mClausifier.getILiteral(newTerm);
        if (atom != null) {
            return atom;
        }
        this.addGroundCCTerms(newLhs, source);
        this.addGroundCCTerms(newRhs, source);
        atom = new QuantEquality(newLhs, newRhs);
        if (!(newLhs instanceof TermVariable)) {
            if (QuantUtil.isEssentiallyUninterpreted(newLhs) && QuantUtil.isEssentiallyUninterpreted(newRhs)) {
                atom.negate().mIsEssentiallyUninterpreted = true;
                atom.mIsEssentiallyUninterpreted = true;
            }
        } else if (!(newRhs instanceof TermVariable)) {
            if (newRhs.getFreeVars().length == 0 && newRhs.getSort().getName() == "Int") {
                atom.mIsArithmetical = true;
            }
            if (!Arrays.asList(newRhs.getFreeVars()).contains(newLhs)) {
                atom.negate().mIsDERUsable = true;
            }
        } else {
            atom.negate().mIsDERUsable = true;
        }
        this.mClausifier.setTermFlags(newTerm, this.mClausifier.getTermFlags(newTerm) | 4 | 8);
        this.mClausifier.setLiteral(newTerm, atom);
        return atom;
    }

    public QuantLiteral getQuantInequality(boolean positive, Term lhs, SourceAnnotation source) {
        boolean rewrite = false;
        SMTAffineTerm linTerm = SMTAffineTerm.create(lhs);
        TermVariable var = null;
        Rational fac = Rational.ONE;
        boolean hasUpperBound = false;
        for (Term smd : linTerm.getSummands().keySet()) {
            if (!(smd instanceof TermVariable)) continue;
            fac = linTerm.getSummands().get(smd);
            if (smd.getSort().getName() == "Real") {
                var = (TermVariable)smd;
                if (linTerm.getSummands().get(smd).isNegative()) {
                    hasUpperBound = true;
                    break;
                }
                hasUpperBound = false;
                break;
            }
            if (fac == Rational.MONE) {
                var = (TermVariable)smd;
                hasUpperBound = true;
                break;
            }
            if (fac != Rational.ONE) continue;
            var = (TermVariable)smd;
            hasUpperBound = false;
            break;
        }
        if (positive && var != null && lhs.getSort().getName() == "Int") {
            rewrite = true;
            linTerm.negate();
            linTerm.add(Rational.ONE);
            hasUpperBound = !hasUpperBound;
        } else if (var != null && lhs.getSort().getName() == "Real") {
            linTerm.div(fac.abs());
        }
        TermCompiler compiler = this.mClausifier.getTermCompiler();
        Term newLhs = linTerm.toTerm(compiler, lhs.getSort());
        Term newAtomTerm = this.mTheory.term("<=", newLhs, Rational.ZERO.toTerm(lhs.getSort()));
        QuantLiteral atom = (QuantLiteral)this.mClausifier.getILiteral(newAtomTerm);
        if (atom != null) {
            return rewrite ? atom.negate() : atom;
        }
        atom = new QuantBoundConstraint(newAtomTerm, linTerm);
        this.addGroundCCTerms(newLhs, source);
        if (var == null) {
            boolean hasOnlyEU = true;
            for (Term smd : linTerm.getSummands().keySet()) {
                hasOnlyEU = hasOnlyEU && QuantUtil.isEssentiallyUninterpreted(smd);
            }
            if (hasOnlyEU) {
                atom.negate().mIsEssentiallyUninterpreted = true;
                atom.mIsEssentiallyUninterpreted = true;
            }
        } else {
            Term remainder;
            SMTAffineTerm remainderAff = new SMTAffineTerm();
            remainderAff.add(linTerm);
            remainderAff.add(hasUpperBound ? Rational.ONE : Rational.MONE, var);
            if (!hasUpperBound) {
                remainderAff.negate();
            }
            if ((remainder = remainderAff.toTerm(compiler, lhs.getSort())) instanceof TermVariable || remainder.getFreeVars().length == 0) {
                atom.negate().mIsArithmetical = true;
            }
        }
        this.mClausifier.setTermFlags(newAtomTerm, this.mClausifier.getTermFlags(newAtomTerm) | 4 | 8);
        this.mClausifier.setLiteral(newAtomTerm, atom);
        return rewrite ? atom.negate() : atom;
    }

    public QuantLiteral[] getLiteralCopies(QuantLiteral[] lits, QuantClause clause) {
        QuantLiteral[] clauseLiterals = new QuantLiteral[lits.length];
        for (int i = 0; i < lits.length; ++i) {
            QuantLiteral clauseAtom;
            QuantLiteral atom = lits[i].getAtom();
            if (atom instanceof QuantBoundConstraint) {
                clauseAtom = new QuantBoundConstraint(atom.getTerm(), ((QuantBoundConstraint)atom).getAffineTerm());
            } else if (atom instanceof QuantAuxEquality) {
                QuantAuxEquality auxAtom = (QuantAuxEquality)atom;
                clauseAtom = new QuantAuxEquality(auxAtom.getLhs(), auxAtom.getRhs(), auxAtom.getDefinition());
            } else {
                clauseAtom = new QuantEquality(((QuantEquality)atom).getLhs(), ((QuantEquality)atom).getRhs());
            }
            clauseAtom.mClause = clause;
            clauseAtom.mIsEssentiallyUninterpreted = atom.mIsEssentiallyUninterpreted;
            clauseAtom.mIsArithmetical = atom.mIsArithmetical;
            clauseAtom.mIsDERUsable = atom.mIsDERUsable;
            clauseAtom.mNegated.mClause = clause;
            clauseAtom.mNegated.mIsEssentiallyUninterpreted = atom.mNegated.mIsEssentiallyUninterpreted;
            clauseAtom.mNegated.mIsArithmetical = atom.mNegated.mIsArithmetical;
            clauseAtom.mNegated.mIsDERUsable = atom.mNegated.mIsDERUsable;
            clauseLiterals[i] = lits[i].isNegated() ? clauseAtom.negate() : clauseAtom;
        }
        return clauseLiterals;
    }

    public DestructiveEqualityReasoning.DERResult performDestructiveEqualityReasoning(TermVariable[] vars, Literal[] groundLits, QuantLiteral[] quantLits, SourceAnnotation source) {
        DestructiveEqualityReasoning der = new DestructiveEqualityReasoning(this, vars, groundLits, quantLits, source);
        if (der.applyDestructiveEqualityReasoning()) {
            DestructiveEqualityReasoning.DERResult result = der.getResult();
            if (result.isGround() && !result.isTriviallyTrue()) {
                this.mLogger.debug("Quant: DER returned ground clause.");
                ++this.mNumInstancesDER;
            }
            return result;
        }
        return null;
    }

    public void addQuantClause(TermVariable[] vars, Literal[] groundLits, QuantLiteral[] quantLits, SourceAnnotation source, Term clauseWithProof) {
        for (QuantLiteral l : quantLits) {
            if (!l.isAlmostUninterpreted()) {
                this.mLogger.info("Quant: Clause contains literal that is not almost uninterpreted: %s", l);
                continue;
            }
            if (!l.mIsDERUsable) continue;
            this.mLogger.warn("Quant: Clause contains disequality on variable not eliminated by DER: %s", l);
        }
        if (quantLits.length == 0) {
            throw new IllegalArgumentException("Cannot add clause to QuantifierTheory: No quantified literal!");
        }
        QuantClause clause = new QuantClause(vars, groundLits, quantLits, this, source, clauseWithProof);
        this.mQuantClauses.add(clause);
        this.mEMatching.addClause(clause);
        this.mInstantiationManager.addClause(clause);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Quant: Added clause: " + clause);
        }
    }

    public void addEMatchingTime(long time) {
        this.mEMatchingTime += time;
    }

    public void addDawgTime(long time) {
        this.mDawgTime += time;
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public EMatching getEMatching() {
        return this.mEMatching;
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public LinArSolve getLinAr() {
        return this.mLinArSolve;
    }

    public InstantiationManager getInstantiationManager() {
        return this.mInstantiationManager;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public Collection<QuantClause> getQuantClauses() {
        return this.mQuantClauses;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public InstantiationMethod getInstantiationMethod() {
        return this.mInstantiationMethod;
    }

    protected Term getLambda(Sort sort) {
        Term lambda;
        if (this.mLambdas.containsKey(sort)) {
            return this.mLambdas.get(sort);
        }
        if (sort.getName().equals("Bool")) {
            lambda = this.mTheory.mTrue;
        } else {
            FunctionSymbol fsym = this.mTheory.getFunctionWithResult("@0", null, sort, new Sort[0]);
            lambda = this.mTheory.term(fsym, new Term[0]);
        }
        this.mLambdas.put(sort, lambda);
        return lambda;
    }

    @Override
    public int checkCompleteness() {
        for (QuantClause qClause : this.mQuantClauses) {
            if (qClause.hasTrueGroundLits()) continue;
            for (QuantLiteral qLit : qClause.getQuantLits()) {
                if (qLit.isAlmostUninterpreted()) continue;
                return 1;
            }
            for (Term lambda : this.mLambdas.values()) {
                CCTerm lambdaCC;
                if (lambda.getSort().isNumericSort() || (lambdaCC = this.mClausifier.getCCTerm(lambda)) == null || lambdaCC.getNumMembers() <= 1) continue;
                return 1;
            }
        }
        return 0;
    }

    private Clause addInstClausesToPending(Collection<InstClause> instances) {
        if (instances == null) {
            return null;
        }
        for (InstClause inst : instances) {
            if (this.mEngine.isTerminationRequested()) {
                return null;
            }
            int numUndefLits = inst.countAndSetUndefLits();
            if (numUndefLits == -1) continue;
            if (numUndefLits == 0) {
                return inst.toClause(this.mEngine.isProofGenerationEnabled());
            }
            for (Literal lit : inst.mLits) {
                if (lit.getAtom().getDecideStatus() != null) continue;
                if (!this.mPendingInstances.containsKey(lit)) {
                    this.mPendingInstances.put(lit, new LinkedHashSet());
                }
                this.mPendingInstances.get(lit).add(inst);
            }
        }
        return null;
    }

    Term getRepresentativeTerm(Term term) {
        CCTerm ccTerm = this.getClausifier().getCCTerm(term);
        return ccTerm == null ? term : ccTerm.getRepresentative().getFlatTerm();
    }

    private void addGroundCCTerms(Term term, SourceAnnotation source) {
        HashSet<Term> seen = new HashSet<Term>();
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        todo.add(term);
        while (!todo.isEmpty()) {
            Term subTerm = (Term)todo.pop();
            if (!(subTerm instanceof ApplicationTerm) || !seen.add(subTerm)) continue;
            if (subTerm.getFreeVars().length == 0) {
                CCTerm ccTerm = this.mClausifier.getCCTerm(subTerm);
                if (ccTerm != null || !Clausifier.needCCTerm(subTerm) && !subTerm.getSort().isArraySort()) continue;
                this.mClausifier.createCCTerm(subTerm, source);
                continue;
            }
            for (Term arg : ((ApplicationTerm)subTerm).getParameters()) {
                todo.add(arg);
            }
        }
    }

    public static enum InstantiationMethod {
        AUF_CONFLICT,
        E_MATCHING_CONFLICT,
        E_MATCHING_EAGER,
        E_MATCHING_LAZY,
        E_MATCHING_CONFLICT_LAZY;

    }

    public static enum InstanceOrigin {
        CONFLICT(":conflict"),
        EMATCHING(":e-matching"),
        ENUMERATION(":enumeration");

        String mOrigin;

        private InstanceOrigin(String origin) {
            this.mOrigin = origin;
        }

        public String getOrigin() {
            return this.mOrigin;
        }
    }
}

