/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;

public class SubstitutionHelper {
    private final QuantifierTheory mQuantTheory;
    private final Clausifier mClausifier;
    private final IProofTracker mTracker;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final Map<TermVariable, Term> mSigma;

    public SubstitutionHelper(QuantifierTheory quantTheory, Literal[] groundLits, QuantLiteral[] quantLits, SourceAnnotation source, Map<TermVariable, Term> sigma) {
        this.mQuantTheory = quantTheory;
        this.mClausifier = this.mQuantTheory.getClausifier();
        this.mTracker = this.mClausifier.getTracker();
        this.mGroundLits = groundLits;
        this.mQuantLits = quantLits;
        this.mSource = source;
        this.mSigma = sigma;
    }

    public SubstitutionResult substituteInClause() {
        Term simpClause;
        Term substitutedClause;
        assert (!this.mSigma.isEmpty());
        ArrayList<Term> substitutedLitTerms = new ArrayList<Term>(this.mGroundLits.length + this.mQuantLits.length);
        ArrayList<Term> provedLitTerms = new ArrayList<Term>(this.mGroundLits.length + this.mQuantLits.length);
        LinkedHashSet<Literal> resultingGroundLits = new LinkedHashSet<Literal>();
        LinkedHashSet<ILiteral> resultingQuantLits = new LinkedHashSet<ILiteral>();
        Theory theory = this.mQuantTheory.getTheory();
        for (Literal literal : this.mGroundLits) {
            Term groundLitTerm = literal.getSMTFormula(theory);
            substitutedLitTerms.add(groundLitTerm);
            provedLitTerms.add(this.mTracker.reflexivity(groundLitTerm));
            resultingGroundLits.add(literal);
        }
        for (ILiteral iLiteral : this.mQuantLits) {
            ILiteral newLiteral;
            EqualityProxy eq;
            ILiteral newAtom;
            Object lhs;
            if (Collections.disjoint(Arrays.asList(((QuantLiteral)iLiteral).getTerm().getFreeVars()), this.mSigma.keySet())) {
                substitutedLitTerms.add(((QuantLiteral)iLiteral).getSMTFormula(theory));
                provedLitTerms.add(this.mTracker.reflexivity(((QuantLiteral)iLiteral).getSMTFormula(theory)));
                resultingQuantLits.add(iLiteral);
                continue;
            }
            FormulaUnLet unletter = new FormulaUnLet();
            unletter.addSubstitutions(this.mSigma);
            Term substituted = unletter.transform(((QuantLiteral)iLiteral).getSMTFormula(theory));
            substitutedLitTerms.add(substituted);
            Term simplified = this.normalizeAndSimplifyLitTerm(substituted);
            if (this.mTracker.getProvedTerm(simplified) == theory.mTrue) {
                return this.buildTrueResult();
            }
            if (this.mTracker.getProvedTerm(simplified) == theory.mFalse) {
                provedLitTerms.add(simplified);
                continue;
            }
            boolean isPos = true;
            Term atomTerm = this.mTracker.getProvedTerm(simplified);
            assert (atomTerm instanceof ApplicationTerm);
            if (((ApplicationTerm)atomTerm).getFunction().getName() == "not") {
                atomTerm = ((ApplicationTerm)atomTerm).getParameters()[0];
                isPos = false;
            }
            assert (atomTerm instanceof ApplicationTerm);
            ApplicationTerm atomApp = (ApplicationTerm)atomTerm;
            if (atomApp.getFunction().getName() == "<=") {
                if (atomApp.getFreeVars().length == 0) {
                    lhs = new SMTAffineTerm(atomApp.getParameters()[0]);
                    MutableAffineTerm msum = this.mClausifier.createMutableAffinTerm((SMTAffineTerm)lhs, this.mSource);
                    newAtom = this.mQuantTheory.getLinAr().generateConstraint(msum, false);
                } else {
                    newAtom = this.mQuantTheory.getQuantInequality(isPos, atomApp.getParameters()[0], this.mSource);
                }
            } else if (atomApp.getFunction().getName() == "=") {
                lhs = atomApp.getParameters()[0];
                Term rhs = atomApp.getParameters()[1];
                if (atomApp.getFreeVars().length == 0) {
                    eq = this.mClausifier.createEqualityProxy((Term)lhs, rhs, this.mSource);
                    assert (eq != EqualityProxy.getTrueProxy() && eq != EqualityProxy.getFalseProxy());
                    newAtom = eq.getLiteral(this.mSource);
                } else {
                    newAtom = this.mQuantTheory.getQuantEquality(atomApp.getParameters()[0], atomApp.getParameters()[1], this.mSource);
                }
            } else {
                assert (atomApp.getFreeVars().length == 0);
                assert (atomApp.getSort() == theory.getBooleanSort());
                ApplicationTerm sharedLhs = atomApp;
                ApplicationTerm sharedRhs = theory.mTrue;
                eq = this.mClausifier.createEqualityProxy(sharedLhs, sharedRhs, this.mSource);
                assert (eq != EqualityProxy.getTrueProxy() && eq != EqualityProxy.getFalseProxy());
                newAtom = eq.getLiteral(this.mSource);
            }
            Term atomIntern = this.mTracker.intern(atomApp, newAtom.getSMTFormula(theory));
            if (isPos) {
                simplified = this.mTracker.transitivity(simplified, atomIntern);
            } else {
                simplified = this.mTracker.congruence(simplified, new Term[]{atomIntern});
                simplified = this.mClausifier.getSimplifier().convertNot(simplified);
            }
            provedLitTerms.add(simplified);
            ILiteral iLiteral2 = newLiteral = isPos ? newAtom : newAtom.negate();
            if (newLiteral instanceof Literal) {
                Literal newGroundLit = (Literal)newLiteral;
                if (resultingGroundLits.contains(newGroundLit.negate())) {
                    return this.buildTrueResult();
                }
                resultingGroundLits.add(newGroundLit);
                continue;
            }
            QuantLiteral newQuantLit = (QuantLiteral)newLiteral;
            if (resultingQuantLits.contains(newQuantLit.negate())) {
                return this.buildTrueResult();
            }
            resultingQuantLits.add(newQuantLit);
        }
        boolean isUnitClause = substitutedLitTerms.size() == 1;
        Term term = substitutedClause = isUnitClause ? (Term)substitutedLitTerms.get(0) : theory.term("or", substitutedLitTerms.toArray(new Term[substitutedLitTerms.size()]));
        if (isUnitClause) {
            assert (provedLitTerms.size() == 1);
            simpClause = (Term)provedLitTerms.get(0);
        } else {
            simpClause = this.mTracker.congruence(this.mTracker.reflexivity(substitutedClause), provedLitTerms.toArray(new Term[provedLitTerms.size()]));
            simpClause = this.mTracker.orSimpClause(simpClause);
        }
        return new SubstitutionResult(substitutedClause, simpClause, resultingGroundLits.toArray(new Literal[resultingGroundLits.size()]), resultingQuantLits.toArray(new QuantLiteral[resultingQuantLits.size()]));
    }

    private Term normalizeAndSimplifyLitTerm(Term litTerm) {
        Term normalizedAtom;
        Theory theory = this.mQuantTheory.getTheory();
        boolean isNegated = litTerm instanceof ApplicationTerm && ((ApplicationTerm)litTerm).getFunction().getName() == "not";
        ApplicationTerm atomTerm = (ApplicationTerm)(isNegated ? ((ApplicationTerm)litTerm).getParameters()[0] : litTerm);
        Term atomRewrite = this.mTracker.reflexivity(atomTerm);
        assert (atomTerm.getFunction().getName() == "<=" || atomTerm.getFunction().getName() == "=");
        TermCompiler compiler = this.mClausifier.getTermCompiler();
        if (atomTerm.getFunction().getName() == "<=") {
            return compiler.transform(litTerm);
        }
        assert (atomTerm.getFunction().getName() == "=");
        Term lhs = atomTerm.getParameters()[0];
        Term rhs = atomTerm.getParameters()[1];
        if (QuantUtil.isAuxApplication(lhs)) {
            Term[] params = ((ApplicationTerm)lhs).getParameters();
            Term[] normalizedParams = new Term[params.length];
            for (int i = 0; i < normalizedParams.length; ++i) {
                normalizedParams[i] = compiler.transform(params[i]);
            }
            Term normalizedAux = this.mTracker.congruence(this.mTracker.reflexivity(lhs), normalizedParams);
            normalizedAtom = this.mTracker.congruence(atomRewrite, new Term[]{normalizedAux, this.mTracker.reflexivity(rhs)});
        } else {
            Term normalizedLhs = compiler.transform(lhs);
            Term normalizedRhs = compiler.transform(rhs);
            normalizedAtom = this.mTracker.congruence(atomRewrite, new Term[]{normalizedLhs, normalizedRhs});
            Term trivialEq = Clausifier.checkAndGetTrivialEquality(this.mTracker.getProvedTerm(normalizedLhs), this.mTracker.getProvedTerm(normalizedRhs), theory);
            if (trivialEq != null) {
                normalizedAtom = this.mTracker.transitivity(normalizedAtom, this.mTracker.intern(this.mTracker.getProvedTerm(normalizedAtom), trivialEq));
            }
        }
        if (isNegated) {
            return this.mClausifier.getSimplifier().convertNot(this.mTracker.congruence(this.mTracker.reflexivity(litTerm), new Term[]{normalizedAtom}));
        }
        return normalizedAtom;
    }

    private SubstitutionResult buildTrueResult() {
        return new SubstitutionResult(null, null, null, null);
    }

    static class SubstitutionResult {
        final Term mSubstituted;
        final Term mSimplified;
        final Literal[] mGroundLits;
        final QuantLiteral[] mQuantLits;

        protected SubstitutionResult(Term substituted, Term simplified, Literal[] groundLits, QuantLiteral[] quantLits) {
            this.mSubstituted = substituted;
            this.mSimplified = simplified;
            this.mGroundLits = groundLits;
            this.mQuantLits = quantLits;
        }

        public boolean isTriviallyTrue() {
            return this.mSimplified == null;
        }

        public boolean isGround() {
            return this.isTriviallyTrue() || this.mQuantLits.length == 0;
        }

        public Term getSubstituted() {
            return this.mSubstituted;
        }

        public Term getSimplified() {
            return this.mSimplified;
        }

        public Literal[] getGroundLits() {
            return this.mGroundLits;
        }

        public QuantLiteral[] getQuantLits() {
            return this.mQuantLits;
        }
    }
}

