/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Dawg<LETTER, VALUE> {
    final VALUE mFinal;
    final Map<LETTER, Dawg<LETTER, VALUE>> mTransitions;
    final Dawg<LETTER, VALUE> mElseTransition;
    static final UnifyHash<Dawg<?, ?>> sUnifier = new UnifyHash();
    Dawg<LETTER, VALUE> mCachedParent = null;

    private Dawg(VALUE value) {
        this.mFinal = value;
        this.mTransitions = null;
        this.mElseTransition = null;
    }

    private Dawg(Map<LETTER, Dawg<LETTER, VALUE>> transitions, Dawg<LETTER, VALUE> elseTransition) {
        this.mFinal = null;
        this.mTransitions = transitions;
        this.mElseTransition = elseTransition;
    }

    public static <LETTER, VALUE> Dawg<LETTER, VALUE> createConst(int levels, VALUE value) {
        int hash = value.hashCode();
        Dawg<Object, Object> constDawg = null;
        for (Dawg<?, ?> dawg : sUnifier.iterateHashCode(hash)) {
            if (!dawg.isFinal() || !dawg.mFinal.equals(value)) continue;
            constDawg = dawg;
            break;
        }
        if (constDawg == null) {
            constDawg = new Dawg<LETTER, VALUE>(value);
            sUnifier.put(hash, constDawg);
        }
        for (int i = 0; i < levels; ++i) {
            constDawg = super.createParent();
        }
        return constDawg;
    }

    private Dawg<LETTER, VALUE> createParent() {
        if (this.mCachedParent == null) {
            this.mCachedParent = new Dawg(Collections.emptyMap(), this);
        }
        return this.mCachedParent;
    }

    public static <LETTER, VALUE> Dawg<LETTER, VALUE> createDawg(Map<LETTER, Dawg<LETTER, VALUE>> transitions, Dawg<LETTER, VALUE> elseTransition) {
        if (transitions.isEmpty()) {
            return super.createParent();
        }
        Dawg<LETTER, VALUE> dawg = new Dawg<LETTER, VALUE>(transitions, elseTransition);
        return dawg;
    }

    public Dawg<LETTER, VALUE> insert(List<LETTER> key, VALUE value) {
        if (this.getValue(key) == value) {
            return this;
        }
        return this.insert(key, value, 0);
    }

    private Dawg<LETTER, VALUE> insert(List<LETTER> key, VALUE value, int offset) {
        if (offset == key.size()) {
            return Dawg.createConst(0, value);
        }
        LETTER firstLetter = key.get(offset);
        LinkedHashMap<LETTER, Dawg<LETTER, VALUE>> newTransitions = new LinkedHashMap<LETTER, Dawg<LETTER, VALUE>>();
        if (firstLetter == null) {
            Dawg<LETTER, VALUE> elseDest = super.insert(key, value, offset + 1);
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> oldTrans : this.mTransitions.entrySet()) {
                Dawg<LETTER, VALUE> newDest = super.insert(key, value, offset + 1);
                if (newDest == elseDest) continue;
                newTransitions.put(oldTrans.getKey(), newDest);
            }
            return Dawg.createDawg(newTransitions, elseDest);
        }
        Dawg<LETTER, VALUE> tailDawg = this.getNextDawg(firstLetter);
        Dawg<LETTER, VALUE> newTailDawg = super.insert(key, value, offset + 1);
        newTransitions.putAll(this.mTransitions);
        if (newTailDawg == this.mElseTransition) {
            newTransitions.remove(firstLetter);
        } else {
            newTransitions.put(firstLetter, newTailDawg);
        }
        return Dawg.createDawg(newTransitions, this.mElseTransition);
    }

    private <V2, V3> Dawg<LETTER, V3> combineInternal(Dawg<LETTER, V2> other, BiFunction<VALUE, V2, V3> combinator, Map<Pair<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>, Dawg<LETTER, V3>> cache) {
        Pair<Dawg, Dawg<LETTER, V2>> pair = new Pair<Dawg, Dawg<LETTER, V2>>(this, other);
        Dawg<Object, V3> result = cache.get(pair);
        if (result != null) {
            return result;
        }
        if (this.mElseTransition == null) {
            assert (other.mElseTransition == null);
            result = Dawg.createConst(0, combinator.apply(this.mFinal, other.mFinal));
        } else {
            Dawg<LETTER, V3> elseCase = super.combineInternal(other.mElseTransition, combinator, cache);
            if (this.mTransitions.isEmpty() && other.mTransitions.isEmpty()) {
                result = super.createParent();
            } else {
                Dawg<LETTER, V3> combined;
                LETTER key;
                LinkedHashMap<LETTER, Dawg<LETTER, V3>> newTransitions = new LinkedHashMap<LETTER, Dawg<LETTER, V3>>();
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
                    key = entry.getKey();
                    combined = super.combineInternal(other.getNextDawg(key), combinator, cache);
                    if (combined == elseCase) continue;
                    newTransitions.put(key, combined);
                }
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : other.mTransitions.entrySet()) {
                    key = entry.getKey();
                    if (this.mTransitions.containsKey(key) || (combined = super.combineInternal(entry.getValue(), combinator, cache)) == elseCase) continue;
                    newTransitions.put(key, combined);
                }
                result = Dawg.createDawg(newTransitions, elseCase);
            }
        }
        cache.put(pair, result);
        return result;
    }

    public <V2, V3> Dawg<LETTER, V3> combine(Dawg<LETTER, V2> other, BiFunction<VALUE, V2, V3> combinator) {
        return this.combineInternal(other, combinator, new HashMap<Pair<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>, Dawg<LETTER, V3>>());
    }

    private <V2> Dawg<LETTER, V2> mapInternal(Function<VALUE, V2> map, Map<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>> cache) {
        Dawg<Object, V2> result = cache.get(this);
        if (result != null) {
            return result;
        }
        if (this.mElseTransition == null) {
            result = Dawg.createConst(0, map.apply(this.mFinal));
        } else {
            Dawg<LETTER, V2> elseCase = super.mapInternal(map, cache);
            if (this.mTransitions.isEmpty()) {
                result = super.createParent();
            } else {
                LinkedHashMap<LETTER, Dawg<LETTER, V2>> newTransitions = new LinkedHashMap<LETTER, Dawg<LETTER, V2>>();
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
                    LETTER key = entry.getKey();
                    Dawg<LETTER, V2> mapped = super.mapInternal(map, cache);
                    if (mapped == elseCase) continue;
                    newTransitions.put(key, mapped);
                }
                result = Dawg.createDawg(newTransitions, elseCase);
            }
        }
        cache.put(this, result);
        return result;
    }

    public <V2> Dawg<LETTER, V2> map(Function<VALUE, V2> map) {
        return this.mapInternal(map, new HashMap<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>());
    }

    private <V2> Dawg<LETTER, V2> mapWithKeyInternal(BiFunction<List<LETTER>, VALUE, V2> map, ArrayList<LETTER> key) {
        if (this.mElseTransition == null) {
            return Dawg.createConst(0, map.apply(key, this.mFinal));
        }
        key.add(null);
        Dawg<LETTER, V2> elseCase = super.mapWithKeyInternal(map, key);
        key.remove(key.size() - 1);
        if (this.mTransitions.isEmpty()) {
            return super.createParent();
        }
        LinkedHashMap<LETTER, Dawg<LETTER, V2>> newTransitions = new LinkedHashMap<LETTER, Dawg<LETTER, V2>>();
        for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
            LETTER letter = entry.getKey();
            key.add(letter);
            Dawg<LETTER, V2> mapped = super.mapWithKeyInternal(map, key);
            key.remove(key.size() - 1);
            if (mapped == elseCase) continue;
            newTransitions.put(letter, mapped);
        }
        return Dawg.createDawg(newTransitions, elseCase);
    }

    public <V2> Dawg<LETTER, V2> mapWithKey(BiFunction<List<LETTER>, VALUE, V2> map) {
        return this.mapWithKeyInternal(map, new ArrayList());
    }

    private static <LETTER, VALUE, LETTER2> Dawg<LETTER2, VALUE> mapKeysInternal(Set<Dawg<LETTER, VALUE>> input, Function<LETTER, LETTER2> map, BiFunction<VALUE, VALUE, VALUE> union) {
        boolean isFinal = false;
        Object finalValue = null;
        LinkedHashMap<LETTER2, LinkedHashSet<Dawg<LETTER, VALUE>>> successors = new LinkedHashMap<LETTER2, LinkedHashSet<Dawg<LETTER, VALUE>>>();
        LinkedHashSet<Dawg<LETTER, VALUE>> elseSuccessors = new LinkedHashSet<Dawg<LETTER, VALUE>>();
        for (Dawg<LETTER, VALUE> inputDawg : input) {
            if (inputDawg.mElseTransition == null) {
                assert (elseSuccessors.isEmpty()) : "input set must not contain both final and non-final dawgs";
                isFinal = true;
                if (finalValue == null) {
                    finalValue = inputDawg.getFinalValue();
                    continue;
                }
                if (finalValue.equals(inputDawg.getFinalValue())) continue;
                finalValue = union.apply(finalValue, inputDawg.getFinalValue());
                continue;
            }
            assert (!isFinal) : "input set must not contain both final and non-final dawgs";
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : inputDawg.mTransitions.entrySet()) {
                LETTER2 newKey = map.apply(entry.getKey());
                LinkedHashSet<Dawg<LETTER, VALUE>> succs = (LinkedHashSet<Dawg<LETTER, VALUE>>)((HashMap)successors).get(newKey);
                if (succs == null) {
                    succs = new LinkedHashSet<Dawg<LETTER, VALUE>>();
                    successors.put(newKey, succs);
                }
                succs.add(entry.getValue());
            }
            elseSuccessors.add(inputDawg.mElseTransition);
        }
        if (isFinal) {
            return Dawg.createConst(0, finalValue);
        }
        LinkedHashMap newTransitions = new LinkedHashMap();
        for (Map.Entry entry : ((HashMap)successors).entrySet()) {
            newTransitions.put(entry.getKey(), Dawg.mapKeysInternal((Set)entry.getValue(), map, union));
        }
        return Dawg.createDawg(newTransitions, Dawg.mapKeysInternal(elseSuccessors, map, union));
    }

    public <LETTER2> Dawg<LETTER2, VALUE> mapKeys(Function<LETTER, LETTER2> map, BiFunction<VALUE, VALUE, VALUE> union) {
        return Dawg.mapKeysInternal(Collections.singleton(this), map, union);
    }

    public boolean isFinal() {
        return this.mTransitions == null;
    }

    public VALUE getFinalValue() {
        return this.mFinal;
    }

    public String toString() {
        if (this.isFinal()) {
            return "RET(" + this.mFinal + ")";
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<Dawg<LETTER, VALUE>> toPrint = new LinkedHashSet<Dawg<LETTER, VALUE>>();
        HashSet<Dawg> visited = new HashSet<Dawg>();
        toPrint.add(this);
        while (!toPrint.isEmpty()) {
            Dawg state = (Dawg)toPrint.iterator().next();
            toPrint.remove(state);
            if (!visited.add(state)) continue;
            sb.append(String.format("Dawg#%04d", state.hashCode() % 10000));
            String comma = "";
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : state.getTransitions().entrySet()) {
                sb.append(comma).append("->");
                if (entry.getValue().isFinal()) {
                    sb.append("(").append(entry.getValue().getFinalValue()).append(") ");
                } else {
                    sb.append(String.format("#%04d ", entry.getValue().hashCode() % 10000));
                    toPrint.add(entry.getValue());
                }
                sb.append(entry.getKey());
                sb.append("\n");
                comma = "         ";
            }
            sb.append(comma).append("->");
            if (state.mElseTransition.isFinal()) {
                sb.append("(").append(state.mElseTransition.getFinalValue()).append(") ");
            } else {
                sb.append(String.format("#%04d ", state.mElseTransition.hashCode() % 10000));
                toPrint.add(state.mElseTransition);
            }
            sb.append("OTHERWISE\n");
        }
        return sb.toString();
    }

    public Dawg<LETTER, VALUE> getNextDawg(LETTER key) {
        Dawg<LETTER, VALUE> result = this.mTransitions.get(key);
        if (result == null) {
            result = this.mElseTransition;
        }
        return result;
    }

    public Map<LETTER, Dawg<LETTER, VALUE>> getTransitions() {
        return this.mTransitions;
    }

    public VALUE getValue(List<LETTER> word) {
        Dawg<LETTER, VALUE> state = this;
        for (LETTER letter : word) {
            assert (!state.isFinal());
            state = state.getNextDawg(letter);
        }
        assert (state.isFinal());
        return state.getFinalValue();
    }

    public Iterable<Entry<LETTER, VALUE>> entrySet() {
        if (this.isFinal()) {
            return Collections.singleton(new Entry(Collections.emptyList(), this.mFinal));
        }
        return new Iterable<Entry<LETTER, VALUE>>(){

            @Override
            public Iterator<Entry<LETTER, VALUE>> iterator() {
                return new Iterator<Entry<LETTER, VALUE>>(){
                    Iterator<Map.Entry<LETTER, Dawg<LETTER, VALUE>>> mTransIterator;
                    Map.Entry<LETTER, Dawg<LETTER, VALUE>> mCurrentEntry;
                    Iterator<Entry<LETTER, VALUE>> mSubIterator;
                    {
                        this.mTransIterator = Dawg.this.mTransitions.entrySet().iterator();
                        this.mCurrentEntry = null;
                        this.mSubIterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.mSubIterator == null || !this.mSubIterator.hasNext()) {
                            if (this.mTransIterator == null) {
                                return false;
                            }
                            if (this.mTransIterator.hasNext()) {
                                this.mCurrentEntry = this.mTransIterator.next();
                            } else {
                                this.mTransIterator = null;
                                this.mCurrentEntry = new Map.Entry<LETTER, Dawg<LETTER, VALUE>>(){

                                    @Override
                                    public LETTER getKey() {
                                        return null;
                                    }

                                    @Override
                                    public Dawg<LETTER, VALUE> getValue() {
                                        return Dawg.this.mElseTransition;
                                    }

                                    @Override
                                    public Dawg<LETTER, VALUE> setValue(Dawg<LETTER, VALUE> value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                            this.mSubIterator = this.mCurrentEntry.getValue().entrySet().iterator();
                        }
                        return true;
                    }

                    @Override
                    public Entry<LETTER, VALUE> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.mSubIterator != null && this.mSubIterator.hasNext());
                        assert (this.mCurrentEntry != null);
                        Entry suffixEntry = this.mSubIterator.next();
                        ConsList newKey = new ConsList(this.mCurrentEntry.getKey(), suffixEntry.getKey());
                        return new Entry(newKey, suffixEntry.getValue());
                    }
                };
            }
        };
    }

    public Iterable<VALUE> values() {
        if (this.isFinal()) {
            return Collections.singleton(this.mFinal);
        }
        return new Iterable<VALUE>(){
            private Set<Dawg<LETTER, VALUE>> mVisited = new HashSet();

            @Override
            public Iterator<VALUE> iterator() {
                return new Iterator<VALUE>(){
                    Iterator<Dawg<LETTER, VALUE>> mTransIterator;
                    Dawg<LETTER, VALUE> mCurrentEntry;
                    Iterator<VALUE> mSubIterator;
                    {
                        this.mTransIterator = Dawg.this.mTransitions.values().iterator();
                        this.mCurrentEntry = null;
                        this.mSubIterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.mSubIterator == null || !this.mSubIterator.hasNext()) {
                            if (this.mTransIterator == null) {
                                return false;
                            }
                            if (this.mTransIterator.hasNext()) {
                                this.mCurrentEntry = this.mTransIterator.next();
                            } else {
                                this.mTransIterator = null;
                                this.mCurrentEntry = Dawg.this.mElseTransition;
                            }
                            if (mVisited.add(this.mCurrentEntry)) {
                                this.mSubIterator = this.mCurrentEntry.values().iterator();
                                continue;
                            }
                            this.mSubIterator = null;
                        }
                        return true;
                    }

                    @Override
                    public VALUE next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.mSubIterator != null && this.mSubIterator.hasNext());
                        assert (this.mCurrentEntry != null);
                        return this.mSubIterator.next();
                    }
                };
            }
        };
    }

    public static class Entry<LETTER, VALUE> {
        private List<LETTER> mKey;
        private VALUE mValue;

        public Entry(List<LETTER> key, VALUE value) {
            this.mKey = key;
            this.mValue = value;
        }

        public List<LETTER> getKey() {
            return this.mKey;
        }

        public VALUE getValue() {
            return this.mValue;
        }
    }

    private static class ConsList<T>
    extends AbstractList<T> {
        private T mHead;
        private List<T> mTail;
        private int mSize;

        public ConsList(T head, List<T> tail) {
            this.mHead = head;
            this.mTail = tail;
            this.mSize = tail.size() + 1;
        }

        @Override
        public T get(int index) {
            return index == 0 ? this.mHead : this.mTail.get(index - 1);
        }

        @Override
        public int size() {
            return this.mSize;
        }
    }
}

