/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;

public class CompareCode
implements ICode {
    private final EMatching mEMatching;
    private final int mFirstRegIndex;
    private final int mSecondRegIndex;
    private final ICode mRemainingCode;

    public CompareCode(EMatching eMatching, int firstRegIndex, int secondRegIndex, ICode remainingCode) {
        this.mEMatching = eMatching;
        this.mFirstRegIndex = firstRegIndex;
        this.mSecondRegIndex = secondRegIndex;
        this.mRemainingCode = remainingCode;
    }

    @Override
    public void execute(CCTerm[] register, int decisionLevel) {
        CCTerm firstTerm = register[this.mFirstRegIndex];
        CCTerm secondTerm = register[this.mSecondRegIndex];
        if (this.mEMatching.getQuantTheory().getCClosure().isEqSet(firstTerm, secondTerm)) {
            int eqDecisionLevel = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(firstTerm, secondTerm);
            this.mEMatching.addCode(this.mRemainingCode, register, eqDecisionLevel > decisionLevel ? eqDecisionLevel : decisionLevel);
        } else {
            this.mEMatching.installCompareTrigger(firstTerm, secondTerm, this.mRemainingCode, register, decisionLevel);
        }
    }

    public String toString() {
        return "compare(r" + this.mFirstRegIndex + ", r" + this.mSecondRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

