/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;

public class EMReverseTrigger
extends ReverseTrigger {
    private final EMatching mEMatching;
    private final ICode mRemainingCode;
    private final FunctionSymbol mFunc;
    private final int mArgPos;
    private final CCTerm mArg;
    private final CCTerm[] mRegister;
    private final int mOutRegIndex;
    private final int mDecisionLevel;

    public EMReverseTrigger(EMatching eMatching, ICode remainingCode, FunctionSymbol func, int argPos, CCTerm arg, CCTerm[] register, int outRegIndex, int decisionLevel) {
        this.mEMatching = eMatching;
        this.mRemainingCode = remainingCode;
        this.mFunc = func;
        this.mArgPos = argPos;
        this.mArg = arg;
        this.mRegister = register;
        this.mOutRegIndex = outRegIndex;
        this.mDecisionLevel = decisionLevel;
    }

    @Override
    public CCTerm getArgument() {
        return this.mArg;
    }

    @Override
    public int getArgPosition() {
        return this.mArgPos;
    }

    @Override
    public FunctionSymbol getFunctionSymbol() {
        return this.mFunc;
    }

    @Override
    public void activate(CCAppTerm appTerm, boolean isFresh) {
        CCTerm[] updatedRegister = Arrays.copyOf(this.mRegister, this.mRegister.length);
        updatedRegister[this.mOutRegIndex] = appTerm;
        if (this.mArg != null) {
            assert (appTerm instanceof CCAppTerm);
            CCAppTerm partialApp = appTerm;
            for (int i = 0; i < this.mFunc.getParameterSorts().length - this.mArgPos - 1; ++i) {
                partialApp = (CCAppTerm)partialApp.getFunc();
            }
            CCTerm candArg = partialApp.getArg();
            int termDecisionLevel = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(this.mArg, candArg);
            this.mEMatching.addCode(this.mRemainingCode, updatedRegister, termDecisionLevel > this.mDecisionLevel ? termDecisionLevel : this.mDecisionLevel);
        } else {
            this.mEMatching.addCode(this.mRemainingCode, updatedRegister, this.mDecisionLevel);
        }
    }
}

