/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Triple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg.Dawg;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMCompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.PatternCompiler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EMatching {
    private final QuantifierTheory mQuantTheory;
    private Deque<Triple<ICode, CCTerm[], Integer>> mTodoStack;
    private final Map<Integer, EMUndoInformation> mUndoInformation;
    private final Map<QuantLiteral, Dawg<Term, SubstitutionInfo>> mAtomSubsDawgs;
    private final Map<QuantClause, ArrayList<Triple<ICode, CCTerm[], Integer>>> mClauseCodes;
    private final Set<QuantLiteral> mEmatchingAtoms;
    private final Set<QuantLiteral> mPartialEmatchingAtoms;
    final SubstitutionInfo mEmptySubs;

    public EMatching(QuantifierTheory quantifierTheory) {
        this.mQuantTheory = quantifierTheory;
        this.mTodoStack = new ArrayDeque<Triple<ICode, CCTerm[], Integer>>();
        this.mAtomSubsDawgs = new HashMap<QuantLiteral, Dawg<Term, SubstitutionInfo>>();
        this.mClauseCodes = new HashMap<QuantClause, ArrayList<Triple<ICode, CCTerm[], Integer>>>();
        this.mUndoInformation = new LinkedHashMap<Integer, EMUndoInformation>();
        this.mEmptySubs = new SubstitutionInfo(new ArrayList<CCTerm>(), new LinkedHashMap<Term, CCTerm>());
        this.mEmatchingAtoms = new HashSet<QuantLiteral>();
        this.mPartialEmatchingAtoms = new HashSet<QuantLiteral>();
    }

    public void addClause(QuantClause qClause) {
        assert (!this.mClauseCodes.containsKey(qClause));
        ArrayList<Triple<ICode, CCTerm[], Integer>> clauseCodes = new ArrayList<Triple<ICode, CCTerm[], Integer>>();
        for (QuantLiteral qLit : qClause.getQuantLits()) {
            QuantLiteral qAtom = qLit.getAtom();
            if (qLit.isArithmetical() || !QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(qAtom)) continue;
            this.mAtomSubsDawgs.put(qAtom, Dawg.createConst(qClause.getVars().length, this.mEmptySubs));
            LinkedHashSet<Term> patterns = new LinkedHashSet<Term>();
            if (qAtom instanceof QuantEquality) {
                QuantEquality eq = (QuantEquality)qAtom;
                Term lhs = eq.getLhs();
                Term rhs = eq.getRhs();
                if (!lhs.getSort().isNumericSort()) {
                    if (!(lhs instanceof TermVariable)) {
                        patterns.add(lhs);
                    }
                    if (!(rhs instanceof TermVariable)) {
                        patterns.add(eq.getRhs());
                    }
                } else {
                    SMTAffineTerm lhsAff = new SMTAffineTerm(lhs);
                    SMTAffineTerm rhsAff = new SMTAffineTerm(eq.getRhs());
                    patterns.addAll(this.getSubPatterns(lhsAff));
                    patterns.addAll(this.getSubPatterns(rhsAff));
                }
            } else {
                SMTAffineTerm affine = ((QuantBoundConstraint)qAtom).getAffineTerm();
                patterns.addAll(this.getSubPatterns(affine));
            }
            if (patterns.isEmpty() || !QuantUtil.containsAppTermsForEachVar(qAtom)) {
                this.mPartialEmatchingAtoms.add(qAtom);
            } else {
                this.mEmatchingAtoms.add(qAtom);
            }
            if (patterns.isEmpty()) continue;
            Pair<ICode, CCTerm[]> newCode = new PatternCompiler(this.mQuantTheory, qAtom, patterns.toArray(new Term[patterns.size()])).compile();
            this.addCode(newCode.getFirst(), newCode.getSecond(), 0);
            clauseCodes.add(new Triple<ICode, CCTerm[], Integer>(newCode.getFirst(), newCode.getSecond(), 0));
        }
        this.mClauseCodes.put(qClause, clauseCodes);
    }

    public void removeClause(QuantClause qClause) {
        this.mClauseCodes.remove(qClause);
        for (QuantLiteral qLit : qClause.getQuantLits()) {
            this.mEmatchingAtoms.remove(qLit.getAtom());
            this.mPartialEmatchingAtoms.remove(qLit.getAtom());
            this.mAtomSubsDawgs.remove(qLit.getAtom());
        }
    }

    public void removeAllTriggers() {
        this.undo(-1);
    }

    public void reAddClauses(Iterable<QuantClause> clauses) {
        assert (this.mTodoStack.isEmpty() && this.mUndoInformation.isEmpty());
        for (QuantClause qClause : clauses) {
            assert (this.mClauseCodes.containsKey(qClause));
            for (Triple<ICode, CCTerm[], Integer> code : this.mClauseCodes.get(qClause)) {
                this.mTodoStack.add(code);
            }
        }
    }

    private Collection<Term> getSubPatterns(SMTAffineTerm at) {
        assert (QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(at));
        LinkedHashSet<Term> patterns = new LinkedHashSet<Term>();
        for (Term smd : at.getSummands().keySet()) {
            if (smd instanceof TermVariable || smd.getFreeVars().length == 0) continue;
            patterns.add(smd);
        }
        return patterns;
    }

    public void run() {
        long time = System.nanoTime();
        while (!this.mTodoStack.isEmpty() && !this.mQuantTheory.getEngine().isTerminationRequested()) {
            Triple<ICode, CCTerm[], Integer> code = this.mTodoStack.pop();
            code.getFirst().execute(code.getSecond(), code.getThird());
        }
        this.mQuantTheory.addEMatchingTime(System.nanoTime() - time);
    }

    public void undo(int decisionLevel) {
        Iterator<Map.Entry<Integer, EMUndoInformation>> it = this.mUndoInformation.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, EMUndoInformation> undo = it.next();
            if (undo.getKey() <= decisionLevel) continue;
            undo.getValue().undo();
            it.remove();
        }
        ArrayDeque<Triple<ICode, CCTerm[], Integer>> undoneTodoStack = new ArrayDeque<Triple<ICode, CCTerm[], Integer>>();
        for (Triple<ICode, CCTerm[], Integer> todo : this.mTodoStack) {
            if (todo.getThird() > decisionLevel) continue;
            undoneTodoStack.add(todo);
        }
        this.mTodoStack = undoneTodoStack;
    }

    public Dawg<Term, SubstitutionInfo> getSubstitutionInfos(QuantLiteral qAtom) {
        assert (this.mAtomSubsDawgs.containsKey(qAtom) && this.mAtomSubsDawgs.get(qAtom) != null);
        return this.mAtomSubsDawgs.get(qAtom);
    }

    public SubstitutionInfo getEmptySubs() {
        return this.mEmptySubs;
    }

    public QuantifierTheory getQuantTheory() {
        return this.mQuantTheory;
    }

    void addCode(ICode code, CCTerm[] register, int decisionLevel) {
        Triple<ICode, CCTerm[], Integer> todo = new Triple<ICode, CCTerm[], Integer>(code, register, decisionLevel);
        this.mTodoStack.add(todo);
    }

    void addInterestingSubstitution(QuantLiteral qLit, List<CCTerm> varSubs, Map<Term, CCTerm> equivalentCCTerms, int decisionLevel) {
        long time = System.nanoTime();
        assert (this.mAtomSubsDawgs.containsKey(qLit));
        Dawg<Term, SubstitutionInfo> subsDawg = this.mAtomSubsDawgs.get(qLit);
        ArrayList<Term> sharedTermSubs = new ArrayList<Term>(varSubs.size());
        for (int i = 0; i < qLit.getClause().getVars().length; ++i) {
            sharedTermSubs.add(varSubs.get(i) == null ? null : varSubs.get(i).getFlatTerm());
        }
        SubstitutionInfo subsInfo = new SubstitutionInfo(varSubs, equivalentCCTerms);
        subsDawg = subsDawg.insert(sharedTermSubs, subsInfo);
        this.mAtomSubsDawgs.put(qLit, subsDawg);
        this.mQuantTheory.addDawgTime(System.nanoTime() - time);
        this.addUndoInformation(qLit, sharedTermSubs, decisionLevel);
    }

    void installCompareTrigger(CCTerm lhs, CCTerm rhs, ICode remainingCode, CCTerm[] register, int decisionLevel) {
        assert (decisionLevel <= this.mQuantTheory.getClausifier().getEngine().getDecideLevel());
        EMCompareTrigger trigger = new EMCompareTrigger(this, lhs, rhs, remainingCode, register, decisionLevel);
        this.mQuantTheory.getCClosure().insertCompareTrigger(lhs, rhs, trigger);
        this.addUndoInformation(trigger, decisionLevel);
    }

    void installFindTrigger(FunctionSymbol func, int regIndex, ICode remainingCode, CCTerm[] register, int decisionLevel) {
        EMReverseTrigger trigger = new EMReverseTrigger(this, remainingCode, func, -1, null, register, regIndex, decisionLevel);
        this.mQuantTheory.getCClosure().insertReverseTrigger(func, trigger);
        this.addUndoInformation(trigger, decisionLevel);
    }

    void installReverseTrigger(FunctionSymbol func, CCTerm arg, int argPos, int regIndex, ICode remainingCode, CCTerm[] register, int decisionLevel) {
        EMReverseTrigger trigger = new EMReverseTrigger(this, remainingCode, func, argPos, arg, register, regIndex, decisionLevel);
        this.mQuantTheory.getCClosure().insertReverseTrigger(func, arg, argPos, trigger);
        this.addUndoInformation(trigger, decisionLevel);
    }

    private void addUndoInformation(EMCompareTrigger trigger, int decisionLevel) {
        EMUndoInformation info = this.getUndoInformationForLevel(decisionLevel);
        info.mCompareTriggers.add(trigger);
    }

    private void addUndoInformation(EMReverseTrigger trigger, int decisionLevel) {
        EMUndoInformation info = this.getUndoInformationForLevel(decisionLevel);
        info.mReverseTriggers.add(trigger);
    }

    private void addUndoInformation(QuantLiteral qLit, List<Term> sharedTermSubs, int decisionLevel) {
        EMUndoInformation info = this.getUndoInformationForLevel(decisionLevel);
        if (!info.mLitSubs.containsKey(qLit)) {
            info.mLitSubs.put(qLit, new ArrayList());
        }
        info.mLitSubs.get(qLit).add(sharedTermSubs);
    }

    private EMUndoInformation getUndoInformationForLevel(int decisionLevel) {
        if (!this.mUndoInformation.containsKey(decisionLevel)) {
            this.mUndoInformation.put(decisionLevel, new EMUndoInformation());
        }
        return this.mUndoInformation.get(decisionLevel);
    }

    public boolean isUsingEmatching(QuantLiteral qLit) {
        return this.mEmatchingAtoms.contains(qLit.getAtom());
    }

    public boolean isPartiallyUsingEmatching(QuantLiteral qLit) {
        return this.mPartialEmatchingAtoms.contains(qLit.getAtom());
    }

    class EMUndoInformation {
        final Collection<EMCompareTrigger> mCompareTriggers = new ArrayList<EMCompareTrigger>();
        final Collection<EMReverseTrigger> mReverseTriggers = new ArrayList<EMReverseTrigger>();
        final Map<QuantLiteral, Collection<List<Term>>> mLitSubs = new LinkedHashMap<QuantLiteral, Collection<List<Term>>>();

        EMUndoInformation() {
        }

        void undo() {
            for (EMCompareTrigger eMCompareTrigger : this.mCompareTriggers) {
                EMatching.this.mQuantTheory.getCClosure().removeCompareTrigger(eMCompareTrigger);
            }
            for (EMReverseTrigger eMReverseTrigger : this.mReverseTriggers) {
                EMatching.this.mQuantTheory.getCClosure().removeReverseTrigger(eMReverseTrigger);
            }
            for (Map.Entry entry : this.mLitSubs.entrySet()) {
                Dawg subsDawg = (Dawg)EMatching.this.mAtomSubsDawgs.get(entry.getKey());
                for (List termSubs : (Collection)entry.getValue()) {
                    subsDawg = subsDawg.insert(termSubs, EMatching.this.mEmptySubs);
                }
                EMatching.this.mAtomSubsDawgs.put((QuantLiteral)entry.getKey(), subsDawg);
            }
        }
    }

    public class SubstitutionInfo {
        final List<CCTerm> mVarSubs;
        final Map<Term, CCTerm> mEquivalentCCTerms;

        SubstitutionInfo(List<CCTerm> varSubs, Map<Term, CCTerm> equivalentCCTerms) {
            this.mVarSubs = varSubs;
            this.mEquivalentCCTerms = equivalentCCTerms;
        }

        public List<CCTerm> getVarSubs() {
            return this.mVarSubs;
        }

        public Map<Term, CCTerm> getEquivalentCCTerms() {
            return this.mEquivalentCCTerms;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Variable Subs: [" + this.mVarSubs.toString());
            sb.append("]\nEquivalent CCTerms: " + this.mEquivalentCCTerms.toString());
            return sb.toString();
        }

        public int hashCode() {
            return this.mEquivalentCCTerms.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SubstitutionInfo) {
                SubstitutionInfo otherInfo = (SubstitutionInfo)other;
                return this.mVarSubs.equals(otherInfo.getVarSubs()) && this.mEquivalentCCTerms.equals(otherInfo.getEquivalentCCTerms());
            }
            return false;
        }
    }
}

