/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;
import java.util.List;

public class FindCode
implements ICode {
    private final EMatching mEMatching;
    private final CClosure mCClosure;
    private final FunctionSymbol mFunc;
    private final int mOutRegIndex;
    private final ICode mRemainingCode;

    public FindCode(EMatching eMatching, CClosure cclosure, FunctionSymbol func, int outRegIndex, ICode remainingCode) {
        this.mEMatching = eMatching;
        this.mCClosure = cclosure;
        this.mFunc = func;
        this.mOutRegIndex = outRegIndex;
        this.mRemainingCode = remainingCode;
    }

    @Override
    public void execute(CCTerm[] register, int decisionLevel) {
        if (this.mFunc.getParameterSorts().length > 0) {
            this.mEMatching.installFindTrigger(this.mFunc, this.mOutRegIndex, this.mRemainingCode, register, decisionLevel);
        }
        List<CCTerm> funcApps = this.mCClosure.getAllFuncApps(this.mFunc);
        for (CCTerm cand : funcApps) {
            CCTerm[] updatedReg = Arrays.copyOf(register, register.length);
            updatedReg[this.mOutRegIndex] = cand;
            this.mEMatching.addCode(this.mRemainingCode, updatedReg, decisionLevel > 0 ? decisionLevel : 0);
        }
    }

    public String toString() {
        return "find(" + this.mFunc + ", r" + this.mOutRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

