/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;

public class GetArgCode
implements ICode {
    private final EMatching mEMatching;
    private final int mAppTermRegIndex;
    private final int mOutRegIndex;
    private final FunctionSymbol mFunc;
    private final int mArgPos;
    private final ICode mRemainingCode;

    public GetArgCode(EMatching eMatching, int appTermRegIndex, FunctionSymbol func, int argPos, int outRegIndex, ICode remainingCode) {
        this.mEMatching = eMatching;
        this.mAppTermRegIndex = appTermRegIndex;
        this.mFunc = func;
        this.mArgPos = argPos;
        this.mOutRegIndex = outRegIndex;
        this.mRemainingCode = remainingCode;
    }

    @Override
    public void execute(CCTerm[] register, int decisionLevel) {
        CCTerm appTerm = register[this.mAppTermRegIndex];
        assert (appTerm instanceof CCAppTerm);
        CCAppTerm partialApp = (CCAppTerm)appTerm;
        for (int i = 0; i < this.mFunc.getParameterSorts().length - this.mArgPos - 1; ++i) {
            partialApp = (CCAppTerm)partialApp.getFunc();
        }
        CCTerm arg = partialApp.getArg();
        CCTerm[] updatedRegister = Arrays.copyOf(register, register.length);
        updatedRegister[this.mOutRegIndex] = arg;
        this.mEMatching.addCode(this.mRemainingCode, updatedRegister, decisionLevel);
    }

    public String toString() {
        return "getArg(r" + this.mAppTermRegIndex + ", " + this.mFunc + ", " + this.mArgPos + ", r" + this.mOutRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

