/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.CompareCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.FindCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.GetArgCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ReverseCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.YieldCode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatternCompiler {
    private final QuantifierTheory mQuantTheory;
    private final EMatching mEMatching;
    private final QuantLiteral mQuantAtom;
    private final Term[] mPatterns;
    private int mNextFreeRegIndex;
    private final Map<Term, TermInfo> mTermInfos;

    public PatternCompiler(QuantifierTheory quantTheory, QuantLiteral qAtom, Term[] patterns) {
        this.mQuantTheory = quantTheory;
        this.mEMatching = quantTheory.getEMatching();
        assert (qAtom.getAtom() == qAtom);
        this.mQuantAtom = qAtom;
        this.mPatterns = patterns;
        this.mNextFreeRegIndex = 1;
        this.mTermInfos = new HashMap<Term, TermInfo>();
    }

    public Pair<ICode, CCTerm[]> compile() {
        this.collectTermInfos(this.mPatterns);
        ICode code = this.generateCode();
        CCTerm[] register = new CCTerm[this.getNextFreeRegIndex()];
        for (TermInfo termInfo : this.mTermInfos.values()) {
            if (termInfo.mGroundTerm == null) continue;
            register[termInfo.mRegIndex] = termInfo.mGroundTerm;
        }
        return new Pair<ICode, CCTerm[]>(code, register);
    }

    private void collectTermInfos(Term[] terms) {
        for (Term t : terms) {
            this.collectTermInfos(t);
        }
    }

    private void collectTermInfos(Term term) {
        if (this.mTermInfos.containsKey(term)) {
            TermInfo info = this.mTermInfos.get(term);
            ++info.mNumOccur;
            return;
        }
        TermInfo info = new TermInfo(this.getNextFreeRegIndex());
        if (term.getFreeVars().length == 0) {
            Clausifier clausifier = this.mEMatching.getQuantTheory().getClausifier();
            info.mGroundTerm = clausifier.createCCTerm(term, this.mQuantAtom.getClause().getSource());
        } else if (!(term instanceof TermVariable)) {
            assert (term instanceof ApplicationTerm);
            Term[] args = ((ApplicationTerm)term).getParameters();
            int startArgIndex = -1;
            for (int i = 0; i < args.length; ++i) {
                if (this.mTermInfos.containsKey(args[i])) {
                    startArgIndex = i;
                    break;
                }
                if (args[i].getFreeVars().length == 0) {
                    startArgIndex = i;
                    break;
                }
                if (!this.hasProcessedOrGroundOrNonVarSubterms(args[i]) || startArgIndex != -1) continue;
                startArgIndex = i;
            }
            info.mStartArgIndex = startArgIndex;
            BitSet visited = new BitSet(args.length);
            if (startArgIndex >= 0) {
                this.collectTermInfos(args[startArgIndex]);
                visited.set(startArgIndex);
            }
            while (visited.cardinality() != args.length) {
                int i = visited.nextClearBit(0);
                while (i < args.length) {
                    if (!this.mTermInfos.containsKey(args[i]) && args[i] instanceof TermVariable) {
                        this.collectTermInfos(args[i]);
                        info.mArgumentOrder.add(i);
                        visited.set(i);
                    }
                    i = visited.nextClearBit(i + 1);
                }
                i = visited.nextClearBit(0);
                while (i < args.length) {
                    if (this.mTermInfos.containsKey(args[i]) || args[i].getFreeVars().length == 0) {
                        this.collectTermInfos(args[i]);
                        info.mArgumentOrder.add(i);
                        visited.set(i);
                    }
                    i = visited.nextClearBit(i + 1);
                }
                i = visited.nextClearBit(0);
                if (i >= args.length) continue;
                assert (!this.mTermInfos.containsKey(args[i]) && !(args[i] instanceof TermVariable) && args[i].getFreeVars().length != 0);
                this.collectTermInfos(args[i]);
                info.mArgumentOrder.add(i);
                visited.set(i);
            }
            assert (info.mArgumentOrder.size() + (info.mStartArgIndex >= 0 ? 1 : 0) == args.length);
        }
        this.mTermInfos.put(term, info);
    }

    protected ICode generateCode() {
        HashMap<TermVariable, Integer> varPos = new HashMap<TermVariable, Integer>();
        HashMap<Term, Integer> candPos = new HashMap<Term, Integer>();
        for (TermVariable var : this.mQuantAtom.getTerm().getFreeVars()) {
            assert (this.mEMatching.isPartiallyUsingEmatching(this.mQuantAtom) || this.mTermInfos.containsKey(var));
            if (!this.mTermInfos.containsKey(var)) continue;
            varPos.put(var, this.mTermInfos.get((Object)var).mRegIndex);
            candPos.put(var, this.mTermInfos.get((Object)var).mRegIndex);
        }
        for (Term pattern : this.mPatterns) {
            candPos.put(pattern, this.mTermInfos.get((Object)pattern).mRegIndex);
        }
        ICode pieceOfCode = new YieldCode(this.mEMatching, this.mQuantAtom, this.mQuantAtom.getClause().getVars(), varPos, candPos);
        for (int i = this.mPatterns.length - 1; i >= 0; --i) {
            Term pattern = this.mPatterns[i];
            TermInfo info = this.mTermInfos.get(pattern);
            ++info.mNumSeen;
            pieceOfCode = this.generateCode(pattern, pieceOfCode);
        }
        return pieceOfCode;
    }

    private ICode generateCode(Term term, ICode remainingCode) {
        TermInfo info = this.mTermInfos.get(term);
        if (info.mNumSeen < info.mNumOccur || term instanceof TermVariable || term.getFreeVars().length == 0) {
            return remainingCode;
        }
        FunctionSymbol func = ((ApplicationTerm)term).getFunction();
        Term[] args = ((ApplicationTerm)term).getParameters();
        ICode codeForOtherArgs = remainingCode;
        if (args.length > 0) {
            for (int i = info.mArgumentOrder.size() - 1; i >= 0; --i) {
                int argIdx = info.mArgumentOrder.get(i);
                Term arg = args[argIdx];
                TermInfo argInfo = this.mTermInfos.get(arg);
                ++argInfo.mNumSeen;
                if (arg instanceof TermVariable && argInfo.mNumSeen == argInfo.mNumOccur) {
                    codeForOtherArgs = new GetArgCode(this.mEMatching, info.mRegIndex, func, argIdx, argInfo.mRegIndex, codeForOtherArgs);
                    continue;
                }
                boolean regIndexForCandidateArg = false;
                codeForOtherArgs = new CompareCode(this.mEMatching, argInfo.mRegIndex, 0, codeForOtherArgs);
                codeForOtherArgs = new GetArgCode(this.mEMatching, info.mRegIndex, func, argIdx, 0, codeForOtherArgs);
                codeForOtherArgs = this.generateCode(arg, codeForOtherArgs);
            }
        }
        if (info.mStartArgIndex >= 0) {
            int startArgIdx = info.mStartArgIndex;
            Term startArg = args[startArgIdx];
            TermInfo startArgInfo = this.mTermInfos.get(startArg);
            ++startArgInfo.mNumSeen;
            ReverseCode revert = new ReverseCode(this.mEMatching, startArgInfo.mRegIndex, func, info.mStartArgIndex, info.mRegIndex, codeForOtherArgs);
            return this.generateCode(startArg, revert);
        }
        return new FindCode(this.mEMatching, this.mQuantTheory.getCClosure(), func, info.mRegIndex, codeForOtherArgs);
    }

    private int getNextFreeRegIndex() {
        return this.mNextFreeRegIndex++;
    }

    private boolean hasProcessedOrGroundOrNonVarSubterms(Term term) {
        if (term instanceof ApplicationTerm) {
            Term[] args = ((ApplicationTerm)term).getParameters();
            for (int i = 0; i < args.length; ++i) {
                if (!this.mTermInfos.containsKey(args[i]) && args[i].getFreeVars().length != 0 && args[i] instanceof TermVariable) continue;
                return true;
            }
        }
        return false;
    }

    class TermInfo {
        CCTerm mGroundTerm;
        int mNumOccur = 1;
        int mNumSeen = 0;
        final int mRegIndex;
        int mStartArgIndex;
        List<Integer> mArgumentOrder;

        TermInfo(int regIndex) {
            this.mRegIndex = regIndex;
            this.mStartArgIndex = -1;
            this.mArgumentOrder = new ArrayList<Integer>();
        }

        public String toString() {
            return "{occ:" + this.mNumOccur + ",seen:" + this.mNumSeen + ",regIndex:" + this.mRegIndex + ",startArgIndex:" + this.mStartArgIndex + "}";
        }
    }
}

