/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;
import java.util.List;

public class ReverseCode
implements ICode {
    private final EMatching mEMatching;
    private final int mArgRegIndex;
    private final FunctionSymbol mFunc;
    private final int mArgPos;
    private final int mOutRegIndex;
    private final ICode mRemainingCode;

    public ReverseCode(EMatching eMatching, int argRegIndex, FunctionSymbol func, int argPos, int outRegIndex, ICode remainingCode) {
        this.mEMatching = eMatching;
        this.mArgRegIndex = argRegIndex;
        this.mFunc = func;
        this.mArgPos = argPos;
        this.mOutRegIndex = outRegIndex;
        this.mRemainingCode = remainingCode;
    }

    @Override
    public void execute(CCTerm[] register, int decisionLevel) {
        CCTerm arg = register[this.mArgRegIndex];
        this.mEMatching.installReverseTrigger(this.mFunc, arg, this.mArgPos, this.mOutRegIndex, this.mRemainingCode, register, decisionLevel);
        List<CCTerm> funcApps = this.mEMatching.getQuantTheory().getCClosure().getAllFuncAppsForArg(this.mFunc, arg, this.mArgPos);
        for (CCTerm cand : funcApps) {
            CCTerm[] updatedReg = Arrays.copyOf(register, register.length);
            updatedReg[this.mOutRegIndex] = cand;
            assert (cand instanceof CCAppTerm);
            CCAppTerm partialApp = (CCAppTerm)cand;
            for (int i = 0; i < this.mFunc.getParameterSorts().length - this.mArgPos - 1; ++i) {
                partialApp = (CCAppTerm)partialApp.getFunc();
            }
            CCTerm candArg = partialApp.getArg();
            int termDecisionLevel = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(arg, candArg);
            this.mEMatching.addCode(this.mRemainingCode, updatedReg, termDecisionLevel > decisionLevel ? termDecisionLevel : decisionLevel);
        }
    }

    public String toString() {
        return "reverse(" + this.mFunc + ", " + this.mArgPos + ", r" + this.mArgRegIndex + ", r" + this.mOutRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

