/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class YieldCode
implements ICode {
    private final EMatching mEMatching;
    private final QuantLiteral mQuantLiteral;
    private final TermVariable[] mVarOrder;
    private final Map<TermVariable, Integer> mVarPos;
    private final Map<Term, Integer> mEquivCCTermPos;

    public YieldCode(EMatching eMatching, QuantLiteral qLit, TermVariable[] varOrder, Map<TermVariable, Integer> varPos, Map<Term, Integer> equivCCTermPos) {
        this.mEMatching = eMatching;
        this.mQuantLiteral = qLit;
        this.mVarOrder = varOrder;
        this.mVarPos = varPos;
        this.mEquivCCTermPos = equivCCTermPos;
    }

    @Override
    public void execute(CCTerm[] register, int decisionLevel) {
        ArrayList<CCTerm> varSubs = new ArrayList<CCTerm>(this.mVarOrder.length);
        for (int i = 0; i < this.mVarOrder.length; ++i) {
            if (this.mVarPos.containsKey(this.mVarOrder[i])) {
                varSubs.add(register[this.mVarPos.get(this.mVarOrder[i])]);
                continue;
            }
            varSubs.add(null);
        }
        HashMap<Term, CCTerm> equivalentCCTerms = new HashMap<Term, CCTerm>();
        for (Map.Entry<Term, Integer> pos : this.mEquivCCTermPos.entrySet()) {
            equivalentCCTerms.put(pos.getKey(), register[pos.getValue()]);
        }
        this.mEMatching.addInterestingSubstitution(this.mQuantLiteral, varSubs, equivalentCCTerms, decisionLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("yield(" + this.mQuantLiteral);
        for (TermVariable var : this.mVarPos.keySet()) {
            sb.append(", " + var);
        }
        sb.append(")");
        return sb.toString();
    }
}

