/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ArrayQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    private int mFront;
    private int mSize;
    private Object[] mContents;

    public ArrayQueue(int size) {
        int i;
        for (i = 1; i < size; i += i) {
        }
        this.mContents = new Object[i];
        size = 0;
        this.mFront = 0;
    }

    public ArrayQueue() {
        this(32);
    }

    private void resize() {
        assert (this.mSize == this.mContents.length);
        Object[] oldcontents = this.mContents;
        this.mContents = new Object[2 * this.mSize];
        System.arraycopy(oldcontents, this.mFront, this.mContents, 0, this.mSize - this.mFront);
        System.arraycopy(oldcontents, 0, this.mContents, this.mSize - this.mFront, this.mFront);
        this.mFront = 0;
    }

    @Override
    public boolean add(E e) {
        if (this.mSize == this.mContents.length) {
            this.resize();
        }
        this.mContents[this.mFront + this.mSize++ & this.mContents.length - 1] = e;
        return true;
    }

    @Override
    public E element() {
        if (this.mSize == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.mContents[this.mFront];
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E peek() {
        return (E)this.mContents[this.mFront];
    }

    @Override
    public E poll() {
        if (this.mSize == 0) {
            return null;
        }
        Object elem = this.mContents[this.mFront];
        --this.mSize;
        this.mContents[this.mFront++] = null;
        this.mFront &= this.mContents.length - 1;
        return (E)elem;
    }

    @Override
    public E remove() {
        return this.poll();
    }

    @Override
    public void clear() {
        if (this.mFront + this.mSize > this.mContents.length) {
            this.mSize -= this.mContents.length - this.mFront;
            while (this.mFront < this.mContents.length) {
                this.mContents[this.mFront++] = null;
            }
            this.mFront = 0;
        }
        while (this.mSize > 0) {
            this.mContents[this.mFront + --this.mSize] = null;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int mPtr;
            {
                this.mPtr = ArrayQueue.this.mFront;
            }

            @Override
            public boolean hasNext() {
                return this.mPtr < ArrayQueue.this.mFront + ArrayQueue.this.mSize;
            }

            @Override
            public E next() {
                return ArrayQueue.this.mContents[this.mPtr++ & ArrayQueue.this.mContents.length - 1];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.mSize;
    }
}

