/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ComputeSCC<V> {
    ComputeSuccessor<V> mComputeSuccs;

    public ComputeSCC(ComputeSuccessor<V> computeSuccs) {
        this.mComputeSuccs = computeSuccs;
    }

    public List<List<V>> getSCCs(Iterator<V> entryPoints) {
        ArrayList<List<V>> allSCCs = new ArrayList<List<V>>();
        ArrayList<V> currentPath = new ArrayList<V>();
        ArrayList<StackEntry<Object>> stack = new ArrayList<StackEntry<Object>>();
        HashSet<V> visited = new HashSet<V>();
        HashMap<V, Integer> positionInPath = new HashMap<V, Integer>();
        int cycleHead = -1;
        Iterator<V> currentIterator = entryPoints;
        Object parent = null;
        while (true) {
            if (currentIterator.hasNext()) {
                V child = currentIterator.next();
                if (visited.add(child)) {
                    visited.add(child);
                    positionInPath.put(child, currentPath.size());
                    stack.add(new StackEntry<Object>(cycleHead, (Iterator<Object>)currentIterator, parent));
                    currentIterator = this.mComputeSuccs.getSuccessors(child);
                    cycleHead = currentPath.size();
                    currentPath.add(child);
                    parent = child;
                    continue;
                }
                Integer prevOnPath = (Integer)positionInPath.get(child);
                if (prevOnPath == null || cycleHead <= prevOnPath) continue;
                cycleHead = prevOnPath;
                continue;
            }
            if (stack.isEmpty()) {
                return allSCCs;
            }
            if (parent == currentPath.get(cycleHead)) {
                List cycle = currentPath.subList(cycleHead, currentPath.size());
                allSCCs.add(new ArrayList(cycle));
                for (Object v : cycle) {
                    positionInPath.remove(v);
                }
                cycle.clear();
            }
            StackEntry caller = (StackEntry)stack.remove(stack.size() - 1);
            parent = caller.mVertex;
            currentIterator = caller.mIterator;
            if (caller.mPrevCycleHead >= cycleHead) continue;
            cycleHead = caller.mPrevCycleHead;
        }
    }

    public static interface ComputeSuccessor<V> {
        public Iterator<V> getSuccessors(V var1);
    }

    private static class StackEntry<V> {
        int mPrevCycleHead;
        Iterator<V> mIterator;
        V mVertex;

        public StackEntry(int cycleHead, Iterator<V> iterator, V vertex) {
            this.mPrevCycleHead = cycleHead;
            this.mIterator = iterator;
            this.mVertex = vertex;
        }
    }
}

